/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.connector.MLConnectorSearchAction;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupSearchAction;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

@ToolAnnotation(value="SearchIndexTool")
public class SearchIndexTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchIndexTool.class);
    public static final String INPUT_FIELD = "input";
    public static final String INDEX_FIELD = "index";
    public static final String QUERY_FIELD = "query";
    public static final String TYPE = "SearchIndexTool";
    private static final String DEFAULT_DESCRIPTION = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    private String name = "SearchIndexTool";
    private String description = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available.";
    private Client client;
    private NamedXContentRegistry xContentRegistry;

    public SearchIndexTool(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.containsKey(INPUT_FIELD) && parameters.get(INPUT_FIELD) != null;
    }

    private SearchRequest getSearchRequest(String index, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        searchSourceBuilder.parseXContent(queryParser);
        return new SearchRequest().source(searchSourceBuilder).indices(new String[]{index});
    }

    private static Map<String, Object> processResponse(SearchHit hit) {
        HashMap<String, Object> docContent = new HashMap<String, Object>();
        docContent.put("_index", hit.getIndex());
        docContent.put("_id", hit.getId());
        docContent.put("_score", Float.valueOf(hit.getScore()));
        docContent.put("_source", hit.getSourceAsMap());
        return docContent;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            String input = parameters.get(INPUT_FIELD);
            JsonObject jsonObject = (JsonObject)StringUtils.gson.fromJson(input, JsonObject.class);
            String index = Optional.ofNullable(jsonObject).map(x -> x.get(INDEX_FIELD)).map(JsonElement::getAsString).orElse(null);
            String query = Optional.ofNullable(jsonObject).map(x -> x.get(QUERY_FIELD)).map(JsonElement::toString).orElse(null);
            if (index == null || query == null) {
                listener.onFailure((Exception)new IllegalArgumentException("SearchIndexTool's two parameter: index and query are required!"));
                return;
            }
            SearchRequest searchRequest = this.getSearchRequest(index, query);
            ActionListener actionListener = ActionListener.wrap(r -> {
                SearchHit[] hits = r.getHits().getHits();
                if (hits != null && hits.length > 0) {
                    StringBuilder contextBuilder = new StringBuilder();
                    for (SearchHit hit : hits) {
                        String doc = AccessController.doPrivileged(() -> {
                            Map<String, Object> docContent = SearchIndexTool.processResponse(hit);
                            return StringUtils.gson.toJson(docContent);
                        });
                        contextBuilder.append(doc).append("\n");
                    }
                    listener.onResponse((Object)contextBuilder.toString());
                } else {
                    listener.onResponse((Object)"");
                }
            }, e -> {
                log.error("Failed to search index", (Throwable)e);
                listener.onFailure(e);
            });
            if (Objects.equals(index, ".plugins-ml-connector")) {
                this.client.execute((ActionType)MLConnectorSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model")) {
                this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model-group")) {
                this.client.execute((ActionType)MLModelGroupSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else {
                this.client.search(searchRequest, actionListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to search index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public static class Factory
    implements Tool.Factory<SearchIndexTool> {
        private Client client;
        private static Factory INSTANCE;
        private NamedXContentRegistry xContentRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchIndexTool> clazz = SearchIndexTool.class;
            synchronized (SearchIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public SearchIndexTool create(Map<String, Object> params) {
            return new SearchIndexTool(this.client, this.xContentRegistry);
        }

        public String getDefaultDescription() {
            return SearchIndexTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

