/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.common;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.util.concurrent.UncategorizedExecutionException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;

public class SdkClientUtils {
    private SdkClientUtils() {
    }

    @SafeVarargs
    public static BiConsumer<PutDataObjectResponse, Throwable> wrapPutCompletion(ActionListener<IndexResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                IndexResponse indexResponse = r.parser() == null ? null : IndexResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)indexResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "put");
            }
        };
    }

    @SafeVarargs
    public static BiConsumer<GetDataObjectResponse, Throwable> wrapGetCompletion(ActionListener<GetResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                GetResponse getResponse = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)getResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "get");
            }
        };
    }

    @SafeVarargs
    public static BiConsumer<UpdateDataObjectResponse, Throwable> wrapUpdateCompletion(ActionListener<UpdateResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                UpdateResponse updateResponse = r.parser() == null ? null : UpdateResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)updateResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "update");
            }
        };
    }

    @SafeVarargs
    public static BiConsumer<DeleteDataObjectResponse, Throwable> wrapDeleteCompletion(ActionListener<DeleteResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                DeleteResponse deleteResponse = r.parser() == null ? null : DeleteResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)deleteResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "delete");
            }
        };
    }

    @SafeVarargs
    public static BiConsumer<BulkDataObjectResponse, Throwable> wrapBulkCompletion(ActionListener<BulkResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                BulkResponse bulkResponse = r.parser() == null ? null : BulkResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)bulkResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "bulk");
            }
        };
    }

    @SafeVarargs
    public static BiConsumer<SearchDataObjectResponse, Throwable> wrapSearchCompletion(ActionListener<SearchResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            try {
                SearchResponse searchResponse = r.parser() == null ? null : SearchResponse.fromXContent((XContentParser)r.parser());
                listener.onResponse((Object)searchResponse);
            }
            catch (IOException e) {
                SdkClientUtils.handleParseFailure(listener, "search");
            }
        };
    }

    private static void handleParseFailure(ActionListener<?> listener, String operation) {
        listener.onFailure((Exception)new OpenSearchStatusException("Failed to parse " + operation + " response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    @SafeVarargs
    private static void handleThrowable(ActionListener<?> listener, Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Exception exception = exceptionTypesToUnwrap.length > 0 ? SdkClientUtils.unwrapAndConvertToException(throwable, exceptionTypesToUnwrap) : SdkClientUtils.unwrapAndConvertToException(throwable, OpenSearchStatusException.class, CompletionException.class);
        listener.onFailure(exception);
    }

    @SafeVarargs
    public static Exception unwrapAndConvertToException(Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Throwable cause;
        List<Class<? extends Throwable>> unwrapTypes = exceptionTypesToUnwrap.length > 0 ? Arrays.asList(exceptionTypesToUnwrap) : List.of(CompletionException.class);
        for (cause = throwable; cause != null && unwrapTypes.contains(cause.getClass()) && cause.getCause() != null; cause = cause.getCause()) {
        }
        if ((cause = SdkClientUtils.getRethrownExecutionExceptionRootCause(cause)) instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new OpenSearchException(cause);
    }

    public static Throwable getRethrownExecutionExceptionRootCause(Throwable throwable) {
        if (throwable instanceof UncategorizedExecutionException && throwable.getCause() instanceof ExecutionException) {
            return throwable.getCause().getCause();
        }
        return throwable;
    }

    public static String lowerCaseEnumValues(String field, String json) {
        Matcher matcher = Pattern.compile("(\"" + Pattern.quote(field) + "\"):(\"[A-Z_]+\")").matcher(json);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1) + ":" + matcher.group(2).toLowerCase(Locale.ROOT));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

