/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.PaddingScheme;

public class CreateRawRsaKeyringInput {
    private final String keyNamespace;
    private final String keyName;
    private final PaddingScheme paddingScheme;
    private final ByteBuffer publicKey;
    private final ByteBuffer privateKey;

    protected CreateRawRsaKeyringInput(BuilderImpl builder) {
        this.keyNamespace = builder.keyNamespace();
        this.keyName = builder.keyName();
        this.paddingScheme = builder.paddingScheme();
        this.publicKey = builder.publicKey();
        this.privateKey = builder.privateKey();
    }

    public String keyNamespace() {
        return this.keyNamespace;
    }

    public String keyName() {
        return this.keyName;
    }

    public PaddingScheme paddingScheme() {
        return this.paddingScheme;
    }

    public ByteBuffer publicKey() {
        return this.publicKey;
    }

    public ByteBuffer privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyNamespace;
        protected String keyName;
        protected PaddingScheme paddingScheme;
        protected ByteBuffer publicKey;
        protected ByteBuffer privateKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateRawRsaKeyringInput model) {
            this.keyNamespace = model.keyNamespace();
            this.keyName = model.keyName();
            this.paddingScheme = model.paddingScheme();
            this.publicKey = model.publicKey();
            this.privateKey = model.privateKey();
        }

        @Override
        public Builder keyNamespace(String keyNamespace) {
            this.keyNamespace = keyNamespace;
            return this;
        }

        @Override
        public String keyNamespace() {
            return this.keyNamespace;
        }

        @Override
        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public String keyName() {
            return this.keyName;
        }

        @Override
        public Builder paddingScheme(PaddingScheme paddingScheme) {
            this.paddingScheme = paddingScheme;
            return this;
        }

        @Override
        public PaddingScheme paddingScheme() {
            return this.paddingScheme;
        }

        @Override
        public Builder publicKey(ByteBuffer publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ByteBuffer publicKey() {
            return this.publicKey;
        }

        @Override
        public Builder privateKey(ByteBuffer privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public ByteBuffer privateKey() {
            return this.privateKey;
        }

        @Override
        public CreateRawRsaKeyringInput build() {
            if (Objects.isNull(this.keyNamespace())) {
                throw new IllegalArgumentException("Missing value for required field `keyNamespace`");
            }
            if (Objects.isNull(this.keyName())) {
                throw new IllegalArgumentException("Missing value for required field `keyName`");
            }
            if (Objects.isNull((Object)this.paddingScheme())) {
                throw new IllegalArgumentException("Missing value for required field `paddingScheme`");
            }
            return new CreateRawRsaKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder keyNamespace(String var1);

        public String keyNamespace();

        public Builder keyName(String var1);

        public String keyName();

        public Builder paddingScheme(PaddingScheme var1);

        public PaddingScheme paddingScheme();

        public Builder publicKey(ByteBuffer var1);

        public ByteBuffer publicKey();

        public Builder privateKey(ByteBuffer var1);

        public ByteBuffer privateKey();

        public CreateRawRsaKeyringInput build();
    }
}

