/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm;

public class GenerateECDSASignatureKeyInput {
    private final ECDSASignatureAlgorithm signatureAlgorithm;

    protected GenerateECDSASignatureKeyInput(BuilderImpl builder) {
        this.signatureAlgorithm = builder.signatureAlgorithm();
    }

    public ECDSASignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSASignatureAlgorithm signatureAlgorithm;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GenerateECDSASignatureKeyInput model) {
            this.signatureAlgorithm = model.signatureAlgorithm();
        }

        @Override
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Override
        public ECDSASignatureAlgorithm signatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public GenerateECDSASignatureKeyInput build() {
            if (Objects.isNull((Object)this.signatureAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `signatureAlgorithm`");
            }
            return new GenerateECDSASignatureKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm var1);

        public ECDSASignatureAlgorithm signatureAlgorithm();

        public GenerateECDSASignatureKeyInput build();
    }
}

