/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.http.protocol;

import java.io.IOException;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpEntityEnclosingRequest;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpRequest;
import org.opensearch.notifications.core.repackage.org.apache.http.HttpRequestInterceptor;
import org.opensearch.notifications.core.repackage.org.apache.http.annotation.Contract;
import org.opensearch.notifications.core.repackage.org.apache.http.annotation.ThreadingBehavior;
import org.opensearch.notifications.core.repackage.org.apache.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.http.protocol.HttpDateGenerator;
import org.opensearch.notifications.core.repackage.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

