/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.threatIntel.action.ListIOCsAction;
import org.opensearch.securityanalytics.threatIntel.action.ListIOCsActionRequest;
import org.opensearch.securityanalytics.threatIntel.action.ListIOCsActionResponse;

public class RestListIOCsAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestListIOCsAction.class);

    public String getName() {
        return "list_iocs_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/threat_intel/iocs"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.ROOT, "%s %s", request.method(), "/_plugins/_security_analytics/threat_intel/iocs"));
        String sortString = request.param("sortString", "name");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        List<String> types = List.of(Strings.commaDelimitedListToStringArray((String)request.param(ListIOCsActionRequest.TYPE_FIELD, ListIOCsActionRequest.ALL_TYPES_FILTER)));
        List<String> feedIds = List.of(Strings.commaDelimitedListToStringArray((String)request.param("feed_ids", "")));
        ListIOCsActionRequest listRequest = new ListIOCsActionRequest(types, feedIds, table);
        return channel -> client.execute((ActionType)ListIOCsAction.INSTANCE, (ActionRequest)listRequest, (ActionListener)new RestResponseListener<ListIOCsActionResponse>(channel){

            public RestResponse buildResponse(ListIOCsActionResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        });
    }
}

