/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;

public class QuestionAnsweringModelConfig
extends MLModelConfig {
    public static final String PARSE_FIELD_NAME = FunctionName.QUESTION_ANSWERING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(QuestionAnsweringModelConfig.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> QuestionAnsweringModelConfig.parse(it));
    public static final String FRAMEWORK_TYPE_FIELD = "framework_type";
    public static final String NORMALIZE_RESULT_FIELD = "normalize_result";
    public static final String MODEL_MAX_LENGTH_FIELD = "model_max_length";
    private final FrameworkType frameworkType;
    private final boolean normalizeResult;
    private final Integer modelMaxLength;

    public QuestionAnsweringModelConfig(String modelType, FrameworkType frameworkType, String allConfig, boolean normalizeResult, Integer modelMaxLength) {
        super(modelType, allConfig);
        if (frameworkType == null) {
            throw new IllegalArgumentException("framework type is null");
        }
        this.frameworkType = frameworkType;
        this.normalizeResult = normalizeResult;
        this.modelMaxLength = modelMaxLength;
    }

    public static QuestionAnsweringModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        FrameworkType frameworkType = null;
        String allConfig = null;
        boolean normalizeResult = false;
        Integer modelMaxLength = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block14;
                }
                case "framework_type": {
                    frameworkType = FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block14;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block14;
                }
                case "normalize_result": {
                    normalizeResult = parser.booleanValue();
                    continue block14;
                }
                case "model_max_length": {
                    modelMaxLength = parser.intValue();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return new QuestionAnsweringModelConfig(modelType, frameworkType, allConfig, normalizeResult, modelMaxLength);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public QuestionAnsweringModelConfig(StreamInput in) throws IOException {
        super(in);
        this.frameworkType = (FrameworkType)in.readEnum(FrameworkType.class);
        this.normalizeResult = in.readBoolean();
        this.modelMaxLength = in.readOptionalInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.frameworkType);
        out.writeBoolean(this.normalizeResult);
        out.writeOptionalInt(this.modelMaxLength);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.frameworkType != null) {
            builder.field(FRAMEWORK_TYPE_FIELD, (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.modelMaxLength != null) {
            builder.field(MODEL_MAX_LENGTH_FIELD, this.modelMaxLength);
        }
        if (this.normalizeResult) {
            builder.field(NORMALIZE_RESULT_FIELD, this.normalizeResult);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static QuestionAnsweringModelConfigBuilder builder() {
        return new QuestionAnsweringModelConfigBuilder();
    }

    @Generated
    public QuestionAnsweringModelConfigBuilder toBuilder() {
        return new QuestionAnsweringModelConfigBuilder().modelType(this.modelType).frameworkType(this.frameworkType).allConfig(this.allConfig).normalizeResult(this.normalizeResult).modelMaxLength(this.modelMaxLength);
    }

    @Generated
    public FrameworkType getFrameworkType() {
        return this.frameworkType;
    }

    @Generated
    public boolean isNormalizeResult() {
        return this.normalizeResult;
    }

    @Generated
    public Integer getModelMaxLength() {
        return this.modelMaxLength;
    }

    public static enum FrameworkType {
        HUGGINGFACE_TRANSFORMERS,
        SENTENCE_TRANSFORMERS,
        HUGGINGFACE_TRANSFORMERS_NEURON;


        public static FrameworkType from(String value) {
            try {
                return FrameworkType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong framework type");
            }
        }
    }

    @Generated
    public static class QuestionAnsweringModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private FrameworkType frameworkType;
        @Generated
        private String allConfig;
        @Generated
        private boolean normalizeResult;
        @Generated
        private Integer modelMaxLength;

        @Generated
        QuestionAnsweringModelConfigBuilder() {
        }

        @Generated
        public QuestionAnsweringModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public QuestionAnsweringModelConfigBuilder frameworkType(FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public QuestionAnsweringModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public QuestionAnsweringModelConfigBuilder normalizeResult(boolean normalizeResult) {
            this.normalizeResult = normalizeResult;
            return this;
        }

        @Generated
        public QuestionAnsweringModelConfigBuilder modelMaxLength(Integer modelMaxLength) {
            this.modelMaxLength = modelMaxLength;
            return this;
        }

        @Generated
        public QuestionAnsweringModelConfig build() {
            return new QuestionAnsweringModelConfig(this.modelType, this.frameworkType, this.allConfig, this.normalizeResult, this.modelMaxLength);
        }

        @Generated
        public String toString() {
            return "QuestionAnsweringModelConfig.QuestionAnsweringModelConfigBuilder(modelType=" + this.modelType + ", frameworkType=" + String.valueOf((Object)this.frameworkType) + ", allConfig=" + this.allConfig + ", normalizeResult=" + this.normalizeResult + ", modelMaxLength=" + this.modelMaxLength + ")";
        }
    }
}

