/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.util;

import java.util.Objects;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;

public class HybridSearchResultFormatUtil {
    public static final Float MAGIC_NUMBER_START_STOP = Float.valueOf(-9.549512E9f);
    public static final Float MAGIC_NUMBER_DELIMITER = Float.valueOf(-4.4224404E9f);

    public static ScoreDoc createStartStopElementForHybridSearchResults(int docId) {
        return new ScoreDoc(docId, MAGIC_NUMBER_START_STOP.floatValue());
    }

    public static ScoreDoc createDelimiterElementForHybridSearchResults(int docId) {
        return new ScoreDoc(docId, MAGIC_NUMBER_DELIMITER.floatValue());
    }

    public static boolean isHybridQueryStartStopElement(ScoreDoc scoreDoc) {
        return Objects.nonNull(scoreDoc) && scoreDoc.doc >= 0 && Float.compare(scoreDoc.score, MAGIC_NUMBER_START_STOP.floatValue()) == 0;
    }

    public static boolean isHybridQueryDelimiterElement(ScoreDoc scoreDoc) {
        return Objects.nonNull(scoreDoc) && scoreDoc.doc >= 0 && Float.compare(scoreDoc.score, MAGIC_NUMBER_DELIMITER.floatValue()) == 0;
    }

    public static FieldDoc createFieldDocStartStopElementForHybridSearchResults(int docId, Object[] fields) {
        return new FieldDoc(docId, MAGIC_NUMBER_START_STOP.floatValue(), fields);
    }

    public static FieldDoc createFieldDocDelimiterElementForHybridSearchResults(int docId, Object[] fields) {
        return new FieldDoc(docId, MAGIC_NUMBER_DELIMITER.floatValue(), fields);
    }

    public static boolean isHybridQuerySpecialElement(ScoreDoc scoreDoc) {
        if (Objects.isNull(scoreDoc)) {
            return false;
        }
        return HybridSearchResultFormatUtil.isHybridQueryStartStopElement(scoreDoc) || HybridSearchResultFormatUtil.isHybridQueryDelimiterElement(scoreDoc);
    }

    public static boolean isHybridQueryScoreDocElement(ScoreDoc scoreDoc) {
        if (Objects.isNull(scoreDoc)) {
            return false;
        }
        return !HybridSearchResultFormatUtil.isHybridQuerySpecialElement(scoreDoc);
    }

    public static Object[] createSortFieldsForDelimiterResults(Object[] fields) {
        Object[] sortFields = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Number SORT_FIELDS_FOR_DELIMITER_RESULTS;
            SortField sortField = (SortField)fields[i];
            SortField.Type type = sortField.getType();
            if (sortField instanceof SortedNumericSortField) {
                type = ((SortedNumericSortField)sortField).getNumericType();
            }
            switch (type) {
                case DOC: 
                case INT: {
                    SORT_FIELDS_FOR_DELIMITER_RESULTS = 1;
                    break;
                }
                case LONG: {
                    SORT_FIELDS_FOR_DELIMITER_RESULTS = 1L;
                    break;
                }
                case SCORE: 
                case FLOAT: {
                    SORT_FIELDS_FOR_DELIMITER_RESULTS = Float.valueOf(1.0f);
                    break;
                }
                case DOUBLE: {
                    SORT_FIELDS_FOR_DELIMITER_RESULTS = 1.0;
                    break;
                }
                default: {
                    SORT_FIELDS_FOR_DELIMITER_RESULTS = new BytesRef();
                }
            }
            sortFields[i] = SORT_FIELDS_FOR_DELIMITER_RESULTS;
        }
        return sortFields;
    }
}

