/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.SizeBlockingQueue;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.threadpool.ThreadPoolStats;

public class ThreadPoolMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(ThreadPoolMetricsCollector.class);
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ThreadPoolMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private StringBuilder value = new StringBuilder();
    private final Map<String, ThreadPoolStatsRecord> statsRecordMap = new HashMap<String, ThreadPoolStatsRecord>();

    public ThreadPoolMetricsCollector() {
        super(SAMPLING_TIME_INTERVAL, "ThreadPoolMetrics", (MeasurementSet)StatMetrics.THREADPOOL_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.THREADPOOL_METRICS_COLLECTOR_ERROR);
    }

    public void collectMetrics(long startTime) {
        if (OpenSearchResources.INSTANCE.getThreadPool() == null) {
            return;
        }
        long mCurrT = System.currentTimeMillis();
        Iterator statsIterator = OpenSearchResources.INSTANCE.getThreadPool().stats().iterator();
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
        while (statsIterator.hasNext()) {
            ThreadPoolStatsRecord lastRecord;
            ThreadPoolStats.Stats stats = (ThreadPoolStats.Stats)statsIterator.next();
            long rejectionDelta = 0L;
            String threadPoolName = stats.getName();
            if (this.statsRecordMap.containsKey(threadPoolName) && startTime - (lastRecord = this.statsRecordMap.get(threadPoolName)).getTimestamp() <= (long)(SAMPLING_TIME_INTERVAL * 3) && (rejectionDelta = stats.getRejected() - lastRecord.getRejected()) < 0L) {
                rejectionDelta = 0L;
            }
            this.statsRecordMap.put(threadPoolName, new ThreadPoolStatsRecord(startTime, stats.getRejected()));
            long finalRejectionDelta = rejectionDelta;
            int capacity = AccessController.doPrivileged(() -> {
                try {
                    ThreadPool threadPool = (ThreadPool)FieldUtils.readField((Object)OpenSearchResources.INSTANCE.getIndicesService(), (String)"threadPool", (boolean)true);
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)threadPool.executor(threadPoolName);
                    BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
                    if (queue instanceof SizeBlockingQueue) {
                        return ((SizeBlockingQueue)queue).capacity();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Fail to read queue capacity via reflection");
                    StatsCollector.instance().logException(StatExceptionCode.THREADPOOL_METRICS_COLLECTOR_ERROR);
                }
                return -1;
            });
            ThreadPoolStatus threadPoolStatus = new ThreadPoolStatus(stats.getName(), stats.getQueue(), finalRejectionDelta, stats.getThreads(), stats.getActive(), -1.0, capacity);
            this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(threadPoolStatus.serialize());
        }
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"thread_pool"});
    }

    private static class ThreadPoolStatsRecord {
        private final long timestamp;
        private final long rejected;

        ThreadPoolStatsRecord(long timestamp, long rejected) {
            this.timestamp = timestamp;
            this.rejected = rejected;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getRejected() {
            return this.rejected;
        }
    }

    public static class ThreadPoolStatus
    extends MetricStatus {
        public final String type;
        public final int queueSize;
        public final long rejected;
        public final int threadsCount;
        public final int threadsActive;
        public final double queueLatency;
        public final int queueCapacity;

        public ThreadPoolStatus(String type, int queueSize, long rejected, int threadsCount, int threadsActive, double queueLatency, int queueCapacity) {
            this.type = type;
            this.queueSize = queueSize;
            this.rejected = rejected;
            this.threadsCount = threadsCount;
            this.threadsActive = threadsActive;
            this.queueLatency = queueLatency;
            this.queueCapacity = queueCapacity;
        }

        @JsonProperty(value="ThreadPoolType")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="ThreadPool_QueueSize")
        public int getQueueSize() {
            return this.queueSize;
        }

        @JsonProperty(value="ThreadPool_RejectedReqs")
        public long getRejected() {
            return this.rejected;
        }

        @JsonProperty(value="ThreadPool_TotalThreads")
        public int getThreadsCount() {
            return this.threadsCount;
        }

        @JsonProperty(value="ThreadPool_ActiveThreads")
        public int getThreadsActive() {
            return this.threadsActive;
        }

        @JsonProperty(value="ThreadPool_QueueLatency")
        public double getQueueLatency() {
            return this.queueLatency;
        }

        @JsonProperty(value="ThreadPool_QueueCapacity")
        public int getQueueCapacity() {
            return this.queueCapacity;
        }
    }
}

