/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference.screen;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.openide.util.actions.SystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.information.Information;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.reference.ReferenceDeleteAction;
import tr.view.reference.ReferenceEditAction;
import tr.view.reference.screen.ReferenceNode;
import tr.view.reference.screen.ReferenceNodeProvider;
import tr.view.reference.screen.ReferencesTableFormat;

public class ReferencesPanel
extends JPanel
implements ListSelectionListener,
Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.reference");
    private final ReferenceNodeProvider refsProvider;
    private final MatcherEditor refsMatcherEditor;
    private final Data data;
    private JXTable refsTable;
    private ReferencesTableFormat refsTableFormat;
    private EventTableModel<Information> refsTableModel;
    private Collection<Information> refsList;
    private EventList<Information> refsEventList;
    private EventSelectionModel<Information> selectionModel;
    private SortedList<Information> refsSortedList;
    private TableComparatorChooser<Information> tableSorter;

    public ReferencesPanel(ReferenceNodeProvider refsProvider, MatcherEditor matcherEditor) {
        this.refsProvider = refsProvider;
        this.refsMatcherEditor = matcherEditor;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.initComponents();
    }

    private void initComponents() {
        this.initTable();
        this.initPanel();
    }

    private void initTable() {
        if (this.data == null) {
            return;
        }
        this.refsList = this.data.getInformationManager().list();
        this.refsEventList = new BasicEventList();
        this.refsEventList.addAll(this.refsList);
        FilterList refsFilterList = new FilterList(this.refsEventList, this.refsMatcherEditor);
        this.data.getInformationManager().addObserver((Observer)this);
        this.refsSortedList = new SortedList((EventList)refsFilterList);
        this.refsTableFormat = new ReferencesTableFormat();
        this.refsTableModel = new EventTableModel(this.refsSortedList, (TableFormat)this.refsTableFormat);
        this.refsTable = new JXTable(this.refsTableModel);
        this.refsTable.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        this.refsTable.getSelectionMapper().setEnabled(false);
        this.refsTable.setSortable(false);
        this.refsTable.setSelectionMode(0);
        this.refsTable.setColumnControlVisible(true);
        this.refsTable.setColumnSelectionAllowed(false);
        this.refsTable.setCellSelectionEnabled(false);
        this.refsTable.setRowSelectionAllowed(true);
        this.refsTable.setShowGrid(false);
        this.refsTable.setShowHorizontalLines(false);
        this.refsTable.setShowVerticalLines(false);
        this.selectionModel = new EventSelectionModel(this.refsSortedList);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.selectionModel.setSelectionMode(0);
        this.selectionModel.setEnabled(true);
        this.refsTable.setSelectionModel(this.selectionModel);
        for (int c = 0; c < this.refsTableFormat.getColumnCount(); ++c) {
            this.refsTable.getColumnModel().getColumn(c).setPreferredWidth(this.refsTableFormat.getColumnWidth(c));
        }
        this.refsTable.setDefaultRenderer(ReferencesTableFormat.ColoredDate.class, (TableCellRenderer)new ReferencesTableFormat.ColoredDateRenderer());
        this.refsTable.setDefaultRenderer(ReferencesTableFormat.ColoredString.class, (TableCellRenderer)new ReferencesTableFormat.ColoredStringRenderer());
        this.refsTable.setDefaultRenderer(Topic.class, (TableCellRenderer)new ReferencesTableFormat.TopicRenderer());
        this.tableSorter = new TableComparatorChooser((JTable)this.refsTable, this.refsSortedList, true);
        this.refsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ReferencesPanel.this.edit();
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    ReferencesPanel.this.delete();
                }
            }
        });
        this.refsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReferencesPanel.this.edit();
                }
            }
        });
    }

    private void initPanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)this.refsTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    private void edit() {
        ((ReferenceEditAction)SystemAction.get(ReferenceEditAction.class)).actionPerformed(null);
    }

    private void delete() {
        ((ReferenceDeleteAction)SystemAction.get(ReferenceDeleteAction.class)).actionPerformed(null);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Vector<ReferenceNode> nodes = new Vector<ReferenceNode>();
        for (Information info : this.selectionModel.getSelected()) {
            nodes.add(new ReferenceNode(info));
        }
        this.refsProvider.provide(nodes);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Manager.EventAdd) {
            Manager.EventAdd event = (Manager.EventAdd)object;
            Lock lock = this.refsEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.refsEventList.add((Object)((Information)event.item));
            lock.unlock();
        } else if (object instanceof Manager.EventRemove) {
            Manager.EventRemove event = (Manager.EventRemove)object;
            Lock lock = this.refsEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.refsEventList.remove(event.item);
            lock.unlock();
        } else if (observable instanceof Information) {
            if (object == Information.Change.NOTES) {
                return;
            }
            Lock lock = this.refsEventList.getReadWriteLock().writeLock();
            lock.lock();
            Information item = (Information)observable;
            int index = this.refsEventList.indexOf((Object)item);
            if (index > -1) {
                this.refsEventList.set(index, (Object)item);
            }
            lock.unlock();
        }
        this.refsTable.invalidate();
        this.refsTable.repaint();
    }

    public Preferences getPreferences() {
        return new Preferences(this);
    }

    public void setPreferences(Preferences preferences) {
        if (preferences != null) {
            preferences.restore(this);
        }
    }

    static class Preferences
    implements Serializable {
        private static final long serialVersionUID = 943043L;
        private final int[] modelIndex;
        private final int[] columnWidth;
        private final boolean[] columnVisible;
        private final int[] columnOrder;
        private final List<Integer> sortingColumns;
        private final List<Boolean> sortingReverse;

        private Preferences(ReferencesPanel panel) {
            int i;
            JXTable table = panel.refsTable;
            this.modelIndex = new int[table.getColumnCount(true)];
            this.columnWidth = new int[table.getColumnCount(true)];
            this.columnVisible = new boolean[table.getColumnCount(true)];
            this.columnOrder = new int[table.getColumnCount(false)];
            List columns = table.getColumns(true);
            for (i = 0; i < columns.size(); ++i) {
                TableColumn c = (TableColumn)columns.get(i);
                this.modelIndex[i] = c.getModelIndex();
                this.columnWidth[i] = c.getWidth();
                this.columnVisible[i] = table.getColumnExt(c.getIdentifier()).isVisible();
            }
            for (i = 0; i < table.getColumnCount(); ++i) {
                this.columnOrder[i] = table.getColumn(i).getModelIndex();
            }
            this.sortingColumns = panel.tableSorter.getSortingColumns();
            this.sortingReverse = new Vector<Boolean>();
            for (Integer column : this.sortingColumns) {
                this.sortingReverse.add(new Boolean(panel.tableSorter.isColumnReverse(column.intValue())));
            }
        }

        private void restore(ReferencesPanel panel) {
            int i;
            if (panel == null) {
                return;
            }
            if (panel.refsTable == null) {
                return;
            }
            if (panel.refsTableFormat == null) {
                return;
            }
            for (int i2 = 0; i2 < this.modelIndex.length; ++i2) {
                String id = panel.refsTableFormat.getColumnName(this.modelIndex[i2]);
                TableColumnExt tce = panel.refsTable.getColumnExt((Object)id);
                if (panel.refsTableFormat.isResizable(this.modelIndex[i2])) {
                    tce.setPreferredWidth(this.columnWidth[i2]);
                } else {
                    int w = panel.refsTableFormat.getColumnWidth(this.modelIndex[i2]);
                    tce.setMaxWidth(w);
                    tce.setMinWidth(w);
                }
                tce.setVisible(this.columnVisible[i2]);
            }
            Object[] ids = new Object[this.columnOrder.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = panel.refsTableFormat.getColumnName(this.columnOrder[i]);
            }
            panel.refsTable.setColumnSequence(ids);
            panel.tableSorter.clearComparator();
            for (i = 0; i < this.sortingColumns.size(); ++i) {
                int column = this.sortingColumns.get(i);
                boolean reverse = this.sortingReverse.get(i);
                panel.tableSorter.appendComparator(column, 0, reverse);
            }
        }
    }
}

