/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FolderInstance
extends Task
implements InstanceCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal<Object> CURRENT = new ThreadLocal();
    private static final ThreadLocal<Object> LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap<FileObject, HoldInstance> map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private Logger err;
    private Task recognizingTask;
    private Task creationTask;

    public FolderInstance(DataFolder dataFolder) {
        this((DataObject.Container)dataFolder);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String string) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (string == null) {
                string = this.folder.getPrimaryFile().getPath().replace('/', '.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        string = string == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + string;
        this.err = Logger.getLogger(string);
        this.container = container;
        container.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)container));
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("new " + (Object)((Object)this));
        }
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException iOException) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "java.lang.Object";
        }
    }

    public Class<?> instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return Object.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.err.fine("do into waitFinished");
            this.waitFinished();
            object = this.object;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("instanceCreate: " + object);
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + ((Object)((Object)this)).getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        block7: {
            Task task;
            boolean bl = this.err.isLoggable(Level.FINE);
            do {
                this.err.fine("waitProcessingFinished on container");
                FolderInstance.waitProcessingFinished(this.container);
                task = this.checkRecognizingStarted();
                if (bl) {
                    this.err.fine("checkRecognizingStarted: " + task);
                }
                task.waitFinished();
                Task task2 = this.creationTask;
                if (bl) {
                    this.err.fine("creationTask: " + this.creationTask);
                }
                if (task2 != null) {
                    task2.waitFinished();
                }
                Task[] taskArray = this.waitFor;
                if (bl) {
                    this.err.fine("toWait: " + taskArray);
                }
                if (taskArray == null) continue;
                for (int i = 0; i < taskArray.length; ++i) {
                    if (bl) {
                        this.err.fine("  wait[" + i + "]: " + taskArray[i]);
                    }
                    taskArray[i].waitFinished();
                }
            } while (task != this.checkRecognizingStarted());
            if (!bl) break block7;
            this.err.fine("breaking the wait loop");
        }
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    protected InstanceCookie acceptDataObject(DataObject dataObject) {
        DataObject.Container container;
        int n = -1;
        Object object = dataObject.getCookie(InstanceCookie.class);
        try {
            object = object == null ? null : this.acceptCookie((InstanceCookie)object);
            n = 1;
        }
        catch (IOException iOException) {
            this.err.log(Level.WARNING, null, iOException);
            object = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.err.log(Level.WARNING, null, classNotFoundException);
            object = null;
        }
        if (object == null && (container = dataObject.getCookie(DataFolder.class)) != null) {
            HoldInstance holdInstance = this.map.get(((DataObject)((Object)container)).getPrimaryFile());
            if (holdInstance != null && holdInstance.cookie != null) {
                object = holdInstance;
                n = 2;
            } else {
                object = this.acceptFolder((DataFolder)container);
                n = 3;
            }
        }
        if (object == null && (container = dataObject.getCookie(DataObject.Container.class)) != null) {
            object = this.acceptContainer(container);
            n = 4;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("acceptDataObject: " + dataObject + " cookie: " + object + " acceptType: " + n);
        }
        return object;
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie;
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return this.acceptContainer(dataFolder);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.fine("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("  recognizing task is now " + this.recognizingTask);
        }
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private final synchronized Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    private static void waitProcessingFinished(DataObject.Container container) {
        if (container instanceof FolderList) {
            ((FolderList)container).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener folderListListener) {
        if (container instanceof FolderList) {
            FolderList folderList = (FolderList)container;
            return folderList.computeChildrenList(folderListListener);
        }
        return PROCESSOR.post(new Runnable(){

            public void run() {
                DataObject[] dataObjectArray = container.getChildren();
                ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    folderListListener.process(dataObjectArray[i], arrayList);
                }
                folderListListener.finished(arrayList);
            }
        });
    }

    final void processObjects(final Collection<DataObject> collection) {
        this.creationTask = this.postCreationTask(new Runnable(){

            public void run() {
                FolderInstance.this.defaultProcessObjects(collection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private final void defaultProcessObjects(Collection<DataObject> collection) {
        HashSet<FileObject> hashSet;
        this.err.fine("defaultProcessObjects");
        ArrayList<HoldInstance> arrayList = new ArrayList<HoldInstance>();
        HoldInstance[] holdInstanceArray = CURRENT;
        synchronized (holdInstanceArray) {
            hashSet = new HashSet<FileObject>(this.map.keySet());
        }
        for (Object object : collection) {
            HoldInstance holdInstance;
            Object object2;
            if (!((DataObject)object).isValid()) continue;
            InstanceCookie instanceCookie = this.acceptDataObject((DataObject)object);
            if (instanceCookie != null) {
                object2 = ((DataObject)object).getPrimaryFile();
                boolean bl = true;
                holdInstance = null;
                if (hashSet.remove(object2) && (holdInstance = this.map.get(object2)) != null && (holdInstance.cookie == null || !holdInstance.cookie.equals(instanceCookie))) {
                    holdInstance = null;
                    bl = false;
                }
                if (holdInstance == null) {
                    HoldInstance holdInstance2 = instanceCookie instanceof HoldInstance ? (HoldInstance)instanceCookie : new HoldInstance((DataObject)object, instanceCookie);
                    ThreadLocal<Object> threadLocal = CURRENT;
                    synchronized (threadLocal) {
                        this.map.put((FileObject)object2, holdInstance2);
                    }
                    if (bl) {
                        ((DataObject)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)object));
                    }
                    arrayList.add(holdInstance2);
                    continue;
                }
                arrayList.add(holdInstance);
                continue;
            }
            object2 = CURRENT;
            synchronized (object2) {
                FileObject fileObject = ((DataObject)object).getPrimaryFile();
                hashSet.remove(fileObject);
                holdInstance = this.map.get(fileObject);
                if (holdInstance != null && holdInstance.cookie == null) {
                    continue;
                }
                holdInstance = new HoldInstance((DataObject)object, null);
                this.map.put(fileObject, holdInstance);
            }
            ((DataObject)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)object));
        }
        holdInstanceArray = CURRENT;
        synchronized (CURRENT) {
            Object object;
            block35: {
                this.map.keySet().removeAll(hashSet);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                holdInstanceArray = new HoldInstance[arrayList.size()];
                arrayList.toArray(holdInstanceArray);
                this.updateWaitFor(holdInstanceArray);
                Object object = null;
                object = this.createInstance((InstanceCookie[])holdInstanceArray);
                Object var16_19 = null;
                if (!this.err.isLoggable(Level.FINE)) break block35;
                this.err.fine("notifying finished");
                for (int i = 0; i < holdInstanceArray.length; ++i) {
                    this.err.fine("  #" + i + ": " + holdInstanceArray[i]);
                }
            }
            this.object = object;
            Object object3 = CURRENT.get();
            CURRENT.set(object);
            Object object4 = LAST_CURRENT.get();
            LAST_CURRENT.set((Object)this);
            try {
                this.notifyFinished();
                Object var20_35 = null;
                CURRENT.set(object3);
                LAST_CURRENT.set(object4);
            }
            catch (Throwable throwable) {
                Object var20_36 = null;
                CURRENT.set(object3);
                LAST_CURRENT.set(object4);
                throw throwable;
            }
            {
                catch (IOException iOException) {
                    object = iOException;
                    Object var16_20 = null;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.fine("notifying finished");
                        for (int i = 0; i < holdInstanceArray.length; ++i) {
                            this.err.fine("  #" + i + ": " + holdInstanceArray[i]);
                        }
                    }
                    this.object = object;
                    Object object5 = CURRENT.get();
                    CURRENT.set(object);
                    Object object6 = LAST_CURRENT.get();
                    LAST_CURRENT.set((Object)this);
                    try {
                        this.notifyFinished();
                        Object var20_37 = null;
                        CURRENT.set(object5);
                        LAST_CURRENT.set(object6);
                    }
                    catch (Throwable throwable) {
                        Object var20_38 = null;
                        CURRENT.set(object5);
                        LAST_CURRENT.set(object6);
                        throw throwable;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = classNotFoundException;
                    Object var16_21 = null;
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.fine("notifying finished");
                        for (int i = 0; i < holdInstanceArray.length; ++i) {
                            this.err.fine("  #" + i + ": " + holdInstanceArray[i]);
                        }
                    }
                    this.object = object;
                    Object object7 = CURRENT.get();
                    CURRENT.set(object);
                    Object object8 = LAST_CURRENT.get();
                    LAST_CURRENT.set((Object)this);
                    try {
                        this.notifyFinished();
                        Object var20_39 = null;
                        CURRENT.set(object7);
                        LAST_CURRENT.set(object8);
                    }
                    catch (Throwable throwable) {
                        Object var20_40 = null;
                        CURRENT.set(object7);
                        LAST_CURRENT.set(object8);
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                if (this.err.isLoggable(Level.FINE)) {
                    this.err.fine("notifying finished");
                    for (int i = 0; i < holdInstanceArray.length; ++i) {
                        this.err.fine("  #" + i + ": " + holdInstanceArray[i]);
                    }
                }
                this.object = object;
                Object object9 = CURRENT.get();
                CURRENT.set(object);
                Object object10 = LAST_CURRENT.get();
                LAST_CURRENT.set((Object)this);
                try {
                    this.notifyFinished();
                    Object var20_41 = null;
                    CURRENT.set(object9);
                    LAST_CURRENT.set(object10);
                }
                catch (Throwable throwable2) {
                    Object var20_42 = null;
                    CURRENT.set(object9);
                    LAST_CURRENT.set(object10);
                    throw throwable2;
                }
                throw throwable;
            }
            return;
        }
    }

    private void updateWaitFor(HoldInstance[] holdInstanceArray) {
        ArrayList<Task> arrayList = new ArrayList<Task>(holdInstanceArray.length);
        for (int i = 0; i < holdInstanceArray.length; ++i) {
            Task task = holdInstanceArray[i].getTask();
            if (task == null) continue;
            arrayList.add(task);
        }
        this.waitFor = arrayList.toArray(new Task[arrayList.size()]);
    }

    protected Task postCreationTask(Runnable runnable) {
        return PROCESSOR.post(runnable);
    }

    final Logger err() {
        return this.err;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + "(" + this.container + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;

        public HoldInstance(DataObject dataObject, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.source = dataObject;
            if (instanceCookie instanceof Task) {
                Task task = (Task)instanceCookie;
                task.addTaskListener((TaskListener)WeakListeners.create(TaskListener.class, (EventListener)((Object)this), (Object)task));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class<?> clazz) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(clazz);
            }
            try {
                Class clazz2 = this.cookie.instanceClass();
                return clazz.isAssignableFrom(clazz2);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)this.cookie;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == FolderInstance.this.container) {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    FolderInstance.this.err.fine("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                FolderInstance.this.err.fine("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                HoldInstance holdInstance;
                DataObject dataObject = (DataObject)object;
                FolderInstance.this.err.fine("PROP_COOKIE: " + dataObject);
                InstanceCookie instanceCookie = FolderInstance.this.acceptDataObject(dataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    holdInstance = (HoldInstance)FolderInstance.this.map.get(fileObject);
                }
                if (holdInstance != null) {
                    FolderInstance.this.err.fine("previous instance: " + holdInstance + " new instance " + instanceCookie);
                    if (instanceCookie == null || instanceCookie != holdInstance && !instanceCookie.equals(holdInstance.cookie)) {
                        holdInstance = new HoldInstance(dataObject, instanceCookie);
                        threadLocal = CURRENT;
                        synchronized (threadLocal) {
                            FolderInstance.this.map.put(fileObject, holdInstance);
                        }
                        FolderInstance.this.recreate();
                    }
                }
            }
        }

        @Override
        public void finished(List<DataObject> list) {
            FolderInstance.this.processObjects(list);
        }

        @Override
        public void process(DataObject dataObject, List<DataObject> list) {
            list.add(dataObject);
        }
    }
}

