/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlidingFx;

final class ScaleFx
implements SlidingFx,
ActionListener {
    private float initialAlpha = 0.1f;
    private float finishAlpha = 0.9f;
    private int iterCount = 9;
    private int curIter = 0;
    private static final float DIVIDING_FACTOR = 2.0f;
    private static final int FRAME_DELAY = 20;
    private Rectangle middle = new Rectangle();
    private Rectangle current = new Rectangle();
    private Timer timer = null;
    private StretchedImageComp stretchedImage = new StretchedImageComp();
    private Rectangle[] path;
    private JLayeredPane pane;
    private SlideOperation operation;
    private Image preparedImage;
    private ChangeListener finishL;
    private final boolean shouldOperationWait;

    public ScaleFx(float f, float f2, boolean bl) {
        this.setTransparency(f, f2);
        this.shouldOperationWait = bl;
    }

    public void prepareEffect(SlideOperation slideOperation) {
        Component component = slideOperation.getComponent();
        this.preparedImage = this.createCompImage(slideOperation.getComponent(), slideOperation.getComponent().getSize());
    }

    public void showEffect(JLayeredPane jLayeredPane, Integer n, SlideOperation slideOperation) {
        this.pane = jLayeredPane;
        this.operation = slideOperation;
        Component component = slideOperation.getComponent();
        Graphics2D graphics2D = (Graphics2D)jLayeredPane.getGraphics();
        Rectangle rectangle = slideOperation.getStartBounds();
        Rectangle rectangle2 = slideOperation.getFinishBounds();
        Dimension dimension = rectangle2.getSize();
        Dimension dimension2 = rectangle.getSize();
        Rectangle rectangle3 = rectangle;
        Image image = this.preparedImage;
        jLayeredPane.add((Component)this.stretchedImage, n);
        this.path = this.computePath(rectangle, rectangle2);
        this.curIter = 1;
        if (image != null) {
            this.stretchedImage.setOrigImage(image);
        } else if (dimension.width * dimension.height > dimension2.width * dimension2.height) {
            this.stretchedImage.setComp(component, dimension);
        } else {
            this.stretchedImage.setComp(component, dimension2);
        }
        this.stretchedImage.setBoundsAndAlpha(rectangle, this.initialAlpha);
        this.getTimer().start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = (float)this.curIter / (float)(this.iterCount - 1);
        float f2 = (1.0f - f) * this.initialAlpha + f * this.finishAlpha;
        this.stretchedImage.setBoundsAndAlpha(this.path[this.curIter], f2);
        ++this.curIter;
        if (this.curIter >= this.iterCount) {
            this.getTimer().stop();
            this.finish();
        }
    }

    private void finish() {
        this.pane.remove(this.stretchedImage);
        this.stretchedImage.cleanup();
        if (this.finishL != null) {
            this.finishL.stateChanged(null);
        }
    }

    public void setTransparency(float f, float f2) {
        this.initialAlpha = f;
        this.finishAlpha = f2;
    }

    private void setSuggestedIterations(int n) {
        if (n < 3) {
            n = 3;
        }
        this.iterCount = n % 2 == 0 ? n + 1 : n;
    }

    private Rectangle[] computePath(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        Rectangle[] rectangleArray = new Rectangle[this.iterCount];
        this.middle.x = Math.abs((rectangle2.x + rectangle.x) / 2);
        this.middle.y = Math.abs((rectangle2.y + rectangle.y) / 2);
        this.middle.width = Math.abs((rectangle2.width + rectangle.width) / 2);
        this.middle.height = Math.abs((rectangle2.height + rectangle.height) / 2);
        this.current = new Rectangle(this.middle);
        for (n = this.iterCount / 2 - 1; n >= 0; --n) {
            this.current.x = (int)Math.abs((float)(this.current.x + rectangle.x) / 2.0f);
            this.current.y = (int)Math.abs((float)(this.current.y + rectangle.y) / 2.0f);
            this.current.width = (int)Math.abs((float)(this.current.width + rectangle.width) / 2.0f);
            this.current.height = (int)Math.abs((float)(this.current.height + rectangle.height) / 2.0f);
            rectangleArray[n] = new Rectangle(this.current);
        }
        rectangleArray[this.iterCount / 2] = new Rectangle(this.middle);
        this.current = this.middle;
        for (n = this.iterCount / 2 + 1; n < this.iterCount; ++n) {
            this.current.x = (int)Math.abs((float)(this.current.x + rectangle2.x) / 2.0f);
            this.current.y = (int)Math.abs((float)(this.current.y + rectangle2.y) / 2.0f);
            this.current.width = (int)Math.abs((float)(this.current.width + rectangle2.width) / 2.0f);
            this.current.height = (int)Math.abs((float)(this.current.height + rectangle2.height) / 2.0f);
            rectangleArray[n] = new Rectangle(this.current);
        }
        return rectangleArray;
    }

    private Image createCompImage(Component component, Dimension dimension) {
        if (!component.isShowing()) {
            return null;
        }
        Image image = component.createImage(component.getWidth(), component.getHeight());
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        component.paint(graphics2D);
        graphics2D.dispose();
        return image;
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(20, this);
            this.timer.setRepeats(true);
        }
        return this.timer;
    }

    public void setFinishListener(ChangeListener changeListener) {
        this.finishL = changeListener;
    }

    public boolean shouldOperationWait() {
        return this.shouldOperationWait;
    }

    private class StretchedImageComp
    extends JComponent {
        private Image origImage;
        private float alpha = 1.0f;
        private Component comp;
        private Dimension scaleSource;
        private Dimension targetSize;

        private StretchedImageComp() {
        }

        public void setComp(Component component, Dimension dimension) {
            this.comp = component;
            this.targetSize = dimension;
        }

        public void setOrigImage(Image image) {
            this.origImage = image;
        }

        public void setScaleSource(Dimension dimension) {
            this.scaleSource = dimension;
        }

        public void setBoundsAndAlpha(Rectangle rectangle, float f) {
            this.alpha = f;
            this.setBounds(rectangle);
            if (this.origImage == null) {
                this.origImage = this.tryCreateImage();
            }
        }

        private Image tryCreateImage() {
            Image image = null;
            if (this.comp != null && this.isDisplayable()) {
                this.comp.setSize(this.targetSize);
                this.add(this.comp);
                image = ScaleFx.this.createCompImage(this.comp, this.targetSize);
                this.remove(this.comp);
            }
            return image;
        }

        public void cleanup() {
            this.comp = null;
            this.origImage = null;
            this.scaleSource = null;
            this.targetSize = null;
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            if (this.origImage == null) {
                if (this.comp == null) {
                    return;
                }
                this.origImage = this.tryCreateImage();
                if (this.origImage == null) {
                    return;
                }
            }
            Image image = this.origImage;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
            graphics2D.drawImage(image, 0, 0, rectangle.width, rectangle.height, null);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }
    }
}

