'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.TH tk_getOpenFile n 4.2 Tk "Tk Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tk_getOpenFile, tk_getSaveFile \- pop up a dialog box for the user to select a file to open or save.
.SH SYNOPSIS
.nf
\fBtk_getOpenFile \fR?\fIoption value ...\fR?
\fBtk_getSaveFile \fR?\fIoption value ...\fR?
.fi
.BE
.SH DESCRIPTION
.PP
The procedures \fBtk_getOpenFile\fR and \fBtk_getSaveFile\fR pop up a
dialog box for the user to select a file to open or save. The
\fBtk_getOpenFile\fR command is usually associated with the \fBOpen\fR
command in the \fBFile\fR menu. Its purpose is for the user to select an
existing file \fIonly\fR. If the user enters a non-existent file, the
dialog box gives the user an error prompt and requires the user to give
an alternative selection. If an application allows the user to create
new files, it should do so by providing a separate \fBNew\fR menu command.
.PP
The \fBtk_getSaveFile\fR command is usually associated with the \fBSave
as\fR command in the \fBFile\fR menu. If the user enters a file that
already exists, the dialog box prompts the user for confirmation
whether the existing file should be overwritten or not.
.PP
The following \fIoption\-value\fR pairs are possible as command line
arguments to these two commands:
.TP
\fB\-confirmoverwrite\fR \fIboolean\fR
Configures how the Save dialog reacts when the selected file already
exists, and saving would overwrite it.  A true value requests a
confirmation dialog be presented to the user.  A false value requests
that the overwrite take place without confirmation.  Default value is true.
.TP
\fB\-defaultextension\fR \fIextension\fR
Specifies a string that will be appended to the filename if the user
enters a filename without an extension. The default value is the empty
string, which means no extension will be appended to the filename in
any case. This option is ignored on Mac OS X, which
does not require extensions to filenames,
and the UNIX implementation guesses reasonable values for this from
the \fB\-filetypes\fR option when this is not supplied.
.TP
\fB\-filetypes\fR \fIfilePatternList\fR
If a \fBFile types\fR listbox exists in the file dialog on the particular
platform, this option gives the \fIfiletype\fRs in this listbox. When
the user choose a filetype in the listbox, only the files of that type
are listed. If this option is unspecified, or if it is set to the
empty list, or if the \fBFile types\fR listbox is not supported by the
particular platform then all files are listed regardless of their
types. See the section \fBSPECIFYING FILE PATTERNS\fR below for a
discussion on the contents of \fIfilePatternList\fR.
.TP
\fB\-initialdir\fR \fIdirectory\fR
Specifies that the files in \fIdirectory\fR should be displayed
when the dialog pops up. If this parameter is not specified, then
the files in the current working directory are displayed. If the
parameter specifies a relative path, the return value will convert the
relative path to an absolute path.
.TP
\fB\-initialfile\fR \fIfilename\fR
Specifies a filename to be displayed in the dialog when it pops up.
.TP
\fB\-message\fR \fIstring\fR
Specifies a message to include in the client area of the dialog.
This is only available on Mac OS X.
.TP
\fB\-multiple\fR \fIboolean\fR
Allows the user to choose multiple files from the Open dialog.
.TP
\fB\-parent\fR \fIwindow\fR
Makes \fIwindow\fR the logical parent of the file dialog. The file
dialog is displayed on top of its parent window. On Mac OS X, this
turns the file dialog into a sheet attached to the parent window.
.TP
\fB\-title\fR \fItitleString\fR
Specifies a string to display as the title of the dialog box. If this
option is not specified, then a default title is displayed. 
.TP
\fB\-typevariable\fR \fIvariableName\fR
The global variable \fIvariableName\fR is used to preselect which filter is
used from \fIfilterList\fR when the dialog box is opened and is
updated when the dialog box is closed, to the last selected
filter. The variable is read once at the beginning to select the
appropriate filter. If the variable does not exist, or its value does
not match any filter typename, or is empty (\fB{}\fR), the dialog box
will revert to the default behavior of selecting the first filter in
the list. If the dialog is canceled, the variable is not modified.
.PP
If the user selects a file, both \fBtk_getOpenFile\fR and
\fBtk_getSaveFile\fR return the full pathname of this file. If the
user cancels the operation, both commands return the empty string.
.SH "SPECIFYING FILE PATTERNS"
.PP
The \fIfilePatternList\fR value given by the \fB\-filetypes\fR option
is a list of file patterns. Each file pattern is a list of the
form
.CS
\fItypeName\fR {\fIextension\fR ?\fIextension ...\fR?} ?{\fImacType\fR ?\fImacType ...\fR?}?
.CE
\fItypeName\fR is the name of the file type described by this
file pattern and is the text string that appears in the \fBFile types\fR
listbox. \fIextension\fR is a file extension for this file pattern.
\fImacType\fR is a four-character Macintosh file type. The list of
\fImacType\fRs is optional and may be omitted for applications that do
not need to execute on the Macintosh platform.
.PP
Several file patterns may have the same \fItypeName,\fR in which case
they refer to the same file type and share the same entry in the
listbox. When the user selects an entry in the listbox, all the files
that match at least one of the file patterns corresponding
to that entry are listed. Usually, each file pattern corresponds to a
distinct type of file. The use of more than one file pattern for one
type of file is only necessary on the Macintosh platform.
.PP
On the Macintosh platform, a file matches a file pattern if its
name matches at least one of the \fIextension\fR(s) AND it
belongs to at least one of the \fImacType\fR(s) of the
file pattern. For example, the \fBC Source Files\fR file pattern in the
sample code matches with files that have a \fB\.c\fR extension AND
belong to the \fImacType\fR \fBTEXT\fR. To use the OR rule instead,
you can use two file patterns, one with the \fIextensions\fR only and
the other with the \fImacType\fR only. The \fBGIF Files\fR file type
in the sample code matches files that \fIeither\fR have a \fB\.gif\fR
extension OR belong to the \fImacType\fR \fBGIFF\fR.
.PP
On the Unix and Windows platforms, a file matches a file pattern
if its name matches at least one of the \fIextension\fR(s) of
the file pattern. The \fImacType\fRs are ignored.
.SH "SPECIFYING EXTENSIONS"
.PP
On the Unix and Macintosh platforms, extensions are matched using
glob-style pattern matching. On the Windows platform, extensions are
matched by the underlying operating system. The types of possible
extensions are:
.IP (1)
the special extension
.QW *
matches any file;
.IP (2)
the special extension
.MT
matches any files that do not have an extension (i.e., the filename
contains no full stop character);
.IP (3)
any character string that does not contain any wild card characters (*
and ?).
.PP
Due to the different pattern matching rules on the various platforms,
to ensure portability, wild card characters are not allowed in the
extensions, except as in the special extension
.QW * .
Extensions without a full stop character (e.g.
.QW ~ )
are allowed but may not work on all platforms.
.SH EXAMPLE
.CS
set types {
    {{Text Files}       {.txt}        }
    {{TCL Scripts}      {.tcl}        }
    {{C Source Files}   {.c}      TEXT}
    {{GIF Files}        {.gif}        }
    {{GIF Files}        {}        GIFF}
    {{All Files}        *             }
}
set filename [tk_getOpenFile \-filetypes $types]

if {$filename != ""} {
    # Open the file ...
}
.CE
.SH "SEE ALSO"
tk_chooseDirectory
.SH KEYWORDS
file selection dialog
