/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class HereGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key, String language) {
        if (url == null) {
            url = "https://revgeocode.search.hereapi.com/v1/revgeocode";
        }
        url = (String)url + "?types=address&limit=1";
        url = (String)url + "&at=%f,%f";
        url = (String)url + "&apiKey=" + key;
        if (language != null) {
            url = (String)url + "&lang=" + language;
        }
        return url;
    }

    public HereGeocoder(Client client, String url, String key, String language, int cacheSize, AddressFormat addressFormat) {
        super(client, HereGeocoder.formatUrl(url, key, language), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject result = json.getJsonArray("items").getJsonObject(0).getJsonObject("address");
        if (result != null) {
            Address address = new Address();
            if (result.containsKey((Object)"label")) {
                address.setFormattedAddress(result.getString("label"));
            }
            if (result.containsKey((Object)"houseNumber")) {
                address.setHouse(result.getString("houseNumber"));
            }
            if (result.containsKey((Object)"street")) {
                address.setStreet(result.getString("street"));
            }
            if (result.containsKey((Object)"city")) {
                address.setSettlement(result.getString("city"));
            }
            if (result.containsKey((Object)"district")) {
                address.setDistrict(result.getString("district"));
            }
            if (result.containsKey((Object)"state")) {
                address.setState(result.getString("state"));
            }
            if (result.containsKey((Object)"countryCode")) {
                address.setCountry(result.getString("countryCode").toUpperCase());
            }
            if (result.containsKey((Object)"postalCode")) {
                address.setPostcode(result.getString("postalCode"));
            }
            return address;
        }
        return null;
    }
}

