/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.createfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.createfile.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCreateFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename;
    private boolean failIfFileExists;
    private boolean addfilenameresult;

    public JobEntryCreateFile(String n) {
        super(n, "");
        this.filename = null;
        this.failIfFileExists = true;
        this.addfilenameresult = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.CREATE_FILE);
    }

    public JobEntryCreateFile() {
        this("");
    }

    public JobEntryCreateFile(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryCreateFile je = (JobEntryCreateFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_if_file_exists", (boolean)this.failIfFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addfilenameresult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.failIfFileExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_if_file_exists"));
            this.addfilenameresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create file' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.failIfFileExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_if_file_exists");
            this.addfilenameresult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create file' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "fail_if_file_exists", this.failIfFileExists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_filename_result", this.addfilenameresult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create file' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            FileObject fileObject;
            String realFilename;
            block14: {
                realFilename = this.getRealFilename();
                fileObject = null;
                fileObject = KettleVFS.getFileObject((String)realFilename);
                if (fileObject.exists()) {
                    if (this.isFailIfFileExists()) {
                        result.setResult(false);
                        log.logError(this.toString(), "File [" + realFilename + "] exists, failing.", new Object[0]);
                    } else {
                        result.setResult(true);
                        log.logBasic(this.toString(), "File [" + realFilename + "] already exists, not recreating.", new Object[0]);
                    }
                    if (this.isAddFilenameToResult()) {
                        this.addFilenameToResult(realFilename, log, result, parentJob);
                    }
                    break block14;
                }
                fileObject.createFile();
                log.logBasic(this.toString(), "File [" + realFilename + "] created!", new Object[0]);
                if (this.isAddFilenameToResult()) {
                    this.addFilenameToResult(realFilename, log, result, parentJob);
                }
                result.setResult(true);
            }
            Object var11_9 = null;
            if (fileObject == null) return result;
            try {
                fileObject.close();
                return result;
            }
            catch (IOException ex) {}
            return result;
            {
                catch (IOException e) {
                    log.logError(this.toString(), "Could not create file [" + realFilename + "], exception: " + e.getMessage(), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var11_10 = null;
                    if (fileObject == null) return result;
                    try {
                        fileObject.close();
                        return result;
                    }
                    catch (IOException ex) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (fileObject == null) throw throwable;
                try {
                    fileObject.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        log.logError(this.toString(), "No filename is defined.", new Object[0]);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFilenameToResult(String targetFilename, LogWriter log, Result result, Job parentJob) throws KettleException {
        FileObject targetFile = null;
        try {
            try {
                targetFile = KettleVFS.getFileObject((String)targetFilename);
                ResultFile resultFile = new ResultFile(0, targetFile, parentJob.getJobname(), this.toString());
                resultFile.setComment("");
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryCreateFile.FileAddedToResult", targetFilename), new Object[0]);
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                targetFile.close();
                targetFile = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        targetFile.close();
        return;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isFailIfFileExists() {
        return this.failIfFileExists;
    }

    public void setFailIfFileExists(boolean failIfFileExists) {
        this.failIfFileExists = failIfFileExists;
    }

    public boolean isAddFilenameToResult() {
        return this.addfilenameresult;
    }

    public void setAddFilenameToResult(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryCreateFile().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

