/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class MultipleMessage
extends AttributeMessage {
    public static final String TAG = "multiple";
    private final List<Message> messages = new ArrayList<Message>();

    public MultipleMessage() {
        super(TAG);
        this.messages.clear();
    }

    public MultipleMessage(List<Message> messages) {
        this();
        if (messages != null) {
            this.messages.addAll(messages);
        }
    }

    public MultipleMessage(Game game, FreeColXMLReader xr) throws XMLStreamException, FreeColException {
        this();
        this.setStringAttributeMap(xr.getAllAttributes());
        this.messages.clear();
        while (xr.moreTags()) {
            String mt = xr.getLocalName();
            Message m = Message.read(game, xr);
            if (m != null) {
                this.messages.add(m);
            }
            xr.expectTag(mt);
        }
        xr.expectTag(TAG);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.messages.isEmpty();
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) throws FreeColException {
        Connection conn = aiPlayer.getConnection();
        if (conn == null) {
            return;
        }
        if (!this.messages.isEmpty()) {
            for (Message m : this.messages) {
                Message ret = conn.handle(m);
                assert (ret == null);
            }
        }
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) throws FreeColException {
        Connection conn = freeColClient.askServer().getConnection();
        if (conn == null) {
            return;
        }
        if (!this.messages.isEmpty()) {
            for (Message m : this.messages) {
                Message ret = conn.handle(m);
                assert (ret == null);
            }
        }
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Connection conn = serverPlayer.getConnection();
        if (conn == null) {
            return null;
        }
        if (!this.messages.isEmpty()) {
            ChangeSet cs = new ChangeSet();
            for (Message m : this.messages) {
                try {
                    Message r = conn.handle(m);
                    if (r == null) continue;
                    cs.add(ChangeSet.See.only(serverPlayer), r);
                }
                catch (FreeColException fce) {
                    logger.log(Level.WARNING, "MultipleMessage server fail", fce);
                }
            }
            return cs.isEmpty() ? null : cs;
        }
        return null;
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        for (Message m : this.messages) {
            m.toXML(xw);
        }
    }

    public Message simplify() {
        Message ret;
        switch (this.messages.size()) {
            case 0: {
                ret = this.isEmpty() ? null : this;
                break;
            }
            case 1: {
                ret = this.messages.get(0);
                if (this.getStringAttributeMap().isEmpty()) break;
                if (ret instanceof AttributeMessage) {
                    ret.setStringAttributeMap(this.getStringAttributeMap());
                    break;
                }
                ret = this;
                break;
            }
            default: {
                ret = this;
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        MultipleMessage.pretty(sb, this.getType(), this.getStringAttributeMap(), null);
        for (Message m : this.messages) {
            sb.append(' ').append(m);
        }
        sb.append(']');
        return sb.toString();
    }
}

