/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.serialization;

import com.google.common.base.CharMatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Interner;
import java.io.IOException;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class HierarchicalNameSerializer
extends AbstractSerializer<String> {
    private static final CharMatcher SEPARATOR_MATCHER = CharMatcher.anyOf((CharSequence)".$/").or(CharMatcher.inRange((char)'A', (char)'Z'));
    private final Interner<String> interner;
    private final BiMap<Integer, String> namesById = HashBiMap.create();

    public HierarchicalNameSerializer(Interner<String> interner) {
        this.interner = interner;
    }

    public String read(Decoder decoder) throws Exception {
        String name = this.readName(decoder);
        return (String)this.interner.intern((Object)name);
    }

    public void write(Encoder encoder, String name) throws Exception {
        this.writeName(name, encoder);
    }

    private String readName(Decoder decoder) throws IOException {
        int id = decoder.readSmallInt();
        String name = (String)this.namesById.get((Object)id);
        if (name == null) {
            name = this.readFirstOccurrenceOfName(decoder);
            this.namesById.put((Object)id, (Object)name);
        }
        return name;
    }

    private String readFirstOccurrenceOfName(Decoder decoder) throws IOException {
        byte separator = decoder.readByte();
        if (separator == 0) {
            return decoder.readString();
        }
        String parent = this.readName(decoder);
        String child = this.readName(decoder);
        return parent + (char)(separator & 0xFF) + child;
    }

    private void writeName(String name, Encoder encoder) throws IOException {
        Integer id = (Integer)this.namesById.inverse().get((Object)name);
        if (id == null) {
            id = this.namesById.inverse().size();
            this.namesById.inverse().put((Object)name, (Object)id);
            encoder.writeSmallInt(id.intValue());
            this.writeFirstOccurrenceOfName(name, encoder);
        } else {
            encoder.writeSmallInt(id.intValue());
        }
    }

    private void writeFirstOccurrenceOfName(String name, Encoder encoder) throws IOException {
        int separator = SEPARATOR_MATCHER.lastIndexIn((CharSequence)name);
        if (separator > 0) {
            String parent = name.substring(0, separator);
            String child = name.substring(separator + 1);
            encoder.writeByte((byte)name.charAt(separator));
            this.writeName(parent, encoder);
            this.writeName(child, encoder);
        } else {
            encoder.writeByte((byte)0);
            encoder.writeString((CharSequence)name);
        }
    }
}

