/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.URIParameter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.ConfigurationSpi;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public final class ConfigFile
extends Configuration {
    private final Spi spi = new Spi();

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        return this.spi.engineGetAppConfigurationEntry(string);
    }

    @Override
    public synchronized void refresh() {
        this.spi.engineRefresh();
    }

    public static final class Spi
    extends ConfigurationSpi {
        private URL url;
        private boolean expandProp = true;
        private Map<String, List<AppConfigurationEntry>> configuration;
        private int linenum;
        private StreamTokenizer st;
        private int lookahead;
        private static Debug debugConfig = Debug.getInstance("configfile");
        private static Debug debugParser = Debug.getInstance("configparser");

        public Spi() {
            try {
                this.init();
            }
            catch (IOException iOException) {
                throw new SecurityException(iOException);
            }
        }

        public Spi(URI uRI) {
            try {
                this.url = uRI.toURL();
                this.init();
            }
            catch (IOException iOException) {
                throw new SecurityException(iOException);
            }
        }

        public Spi(final Configuration.Parameters parameters) throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        if (parameters == null) {
                            this.init();
                        } else {
                            if (!(parameters instanceof URIParameter)) {
                                throw new IllegalArgumentException("Unrecognized parameter: " + parameters);
                            }
                            URIParameter uRIParameter = (URIParameter)parameters;
                            url = uRIParameter.getURI().toURL();
                            this.init();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }

        private void init() throws IOException {
            String string;
            Object object;
            String string2;
            boolean bl = false;
            String string3 = Security.getProperty("policy.expandProperties");
            if (string3 == null) {
                string3 = System.getProperty("policy.expandProperties");
            }
            if ("false".equals(string3)) {
                this.expandProp = false;
            }
            HashMap<String, List<AppConfigurationEntry>> hashMap = new HashMap<String, List<AppConfigurationEntry>>();
            if (this.url != null) {
                if (debugConfig != null) {
                    debugConfig.println("reading " + this.url);
                }
                this.init(this.url, hashMap);
                this.configuration = hashMap;
                return;
            }
            String string4 = Security.getProperty("policy.allowSystemProperty");
            if ("true".equalsIgnoreCase(string4) && (string2 = System.getProperty("java.security.auth.login.config")) != null) {
                boolean bl2 = false;
                if (string2.startsWith("=")) {
                    bl2 = true;
                    string2 = string2.substring(1);
                }
                try {
                    string2 = PropertyExpander.expand(string2);
                }
                catch (PropertyExpander.ExpandException expandException) {
                    throw this.ioException("Unable.to.properly.expand.config", string2);
                }
                object = null;
                try {
                    object = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string2);
                    if (file.exists()) {
                        object = file.toURI().toURL();
                    }
                    throw this.ioException("extra.config.No.such.file.or.directory.", string2);
                }
                if (debugConfig != null) {
                    debugConfig.println("reading " + object);
                }
                this.init((URL)object, hashMap);
                bl = true;
                if (bl2) {
                    if (debugConfig != null) {
                        debugConfig.println("overriding other policies!");
                    }
                    this.configuration = hashMap;
                    return;
                }
            }
            int n = 1;
            while ((string = Security.getProperty("login.config.url." + n)) != null) {
                try {
                    string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
                    if (debugConfig != null) {
                        debugConfig.println("\tReading config: " + string);
                    }
                    this.init(new URL(string), hashMap);
                    bl = true;
                }
                catch (PropertyExpander.ExpandException expandException) {
                    throw this.ioException("Unable.to.properly.expand.config", string);
                }
                ++n;
            }
            if (!bl && n == 1 && string == null) {
                if (debugConfig != null) {
                    debugConfig.println("\tReading Policy from ~/.java.login.config");
                }
                if (new File((String)(object = (string = System.getProperty("user.home")) + File.separatorChar + ".java.login.config")).exists()) {
                    this.init(new File((String)object).toURI().toURL(), hashMap);
                }
            }
            this.configuration = hashMap;
        }

        private void init(URL uRL, Map<String, List<AppConfigurationEntry>> map) throws IOException {
            try (InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL), "UTF-8");){
                this.readConfig(inputStreamReader, map);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debugConfig != null) {
                    debugConfig.println(fileNotFoundException.toString());
                }
                throw new IOException(ResourcesMgr.getString("Configuration.Error.No.such.file.or.directory", "sun.security.util.AuthResources"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppConfigurationEntry[] engineGetAppConfigurationEntry(String string) {
            List<AppConfigurationEntry> list = null;
            AppConfigurationEntry[] appConfigurationEntryArray = this.configuration;
            synchronized (this.configuration) {
                list = this.configuration.get(string);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (list == null || list.size() == 0) {
                    return null;
                }
                appConfigurationEntryArray = new AppConfigurationEntry[list.size()];
                Iterator<AppConfigurationEntry> iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    AppConfigurationEntry appConfigurationEntry = iterator.next();
                    appConfigurationEntryArray[n] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
                    ++n;
                }
                return appConfigurationEntryArray;
            }
        }

        @Override
        public synchronized void engineRefresh() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        this.init();
                    }
                    catch (IOException iOException) {
                        throw new SecurityException(iOException.getLocalizedMessage(), iOException);
                    }
                    return null;
                }
            });
        }

        private void readConfig(Reader reader, Map<String, List<AppConfigurationEntry>> map) throws IOException {
            this.linenum = 1;
            if (!(reader instanceof BufferedReader)) {
                reader = new BufferedReader(reader);
            }
            this.st = new StreamTokenizer(reader);
            this.st.quoteChar(34);
            this.st.wordChars(36, 36);
            this.st.wordChars(95, 95);
            this.st.wordChars(45, 45);
            this.st.wordChars(42, 42);
            this.st.lowerCaseMode(false);
            this.st.slashSlashComments(true);
            this.st.slashStarComments(true);
            this.st.eolIsSignificant(true);
            this.lookahead = this.nextToken();
            while (this.lookahead != -1) {
                this.parseLoginEntry(map);
            }
        }

        private void parseLoginEntry(Map<String, List<AppConfigurationEntry>> map) throws IOException {
            LinkedList<AppConfigurationEntry> linkedList = new LinkedList<AppConfigurationEntry>();
            String string = this.st.sval;
            this.lookahead = this.nextToken();
            if (debugParser != null) {
                debugParser.println("\tReading next config entry: " + string);
            }
            this.match("{");
            while (!this.peek("}")) {
                AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag;
                String string2 = this.match("module class name");
                String string3 = this.match("controlFlag").toUpperCase(Locale.ENGLISH);
                switch (string3) {
                    case "REQUIRED": {
                        loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                        break;
                    }
                    case "REQUISITE": {
                        loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                        break;
                    }
                    case "SUFFICIENT": {
                        loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                        break;
                    }
                    case "OPTIONAL": {
                        loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                        break;
                    }
                    default: {
                        throw this.ioException("Configuration.Error.Invalid.control.flag.flag", string3);
                    }
                }
                Object object = new HashMap();
                while (!this.peek(";")) {
                    String string4 = this.match("option key");
                    this.match("=");
                    try {
                        object.put(string4, this.expand(this.match("option value")));
                    }
                    catch (PropertyExpander.ExpandException expandException) {
                        throw new IOException(expandException.getLocalizedMessage());
                    }
                }
                this.lookahead = this.nextToken();
                if (debugParser != null) {
                    debugParser.println("\t\t" + string2 + ", " + string3);
                    for (String string5 : object.keySet()) {
                        debugParser.println("\t\t\t" + string5 + "=" + (String)object.get(string5));
                    }
                }
                linkedList.add(new AppConfigurationEntry(string2, loginModuleControlFlag, (Map<String, ?>)object));
            }
            this.match("}");
            this.match(";");
            if (map.containsKey(string)) {
                throw this.ioException("Configuration.Error.Can.not.specify.multiple.entries.for.appName", string);
            }
            map.put(string, linkedList);
        }

        private String match(String string) throws IOException {
            String string2 = null;
            switch (this.lookahead) {
                case -1: {
                    throw this.ioException("Configuration.Error.expected.expect.read.end.of.file.", string);
                }
                case -3: 
                case 34: {
                    if (string.equalsIgnoreCase("module class name") || string.equalsIgnoreCase("controlFlag") || string.equalsIgnoreCase("option key") || string.equalsIgnoreCase("option value")) {
                        string2 = this.st.sval;
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.found.value.", new Integer(this.linenum), string, this.st.sval);
                }
                case 123: {
                    if (string.equalsIgnoreCase("{")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), string, this.st.sval);
                }
                case 59: {
                    if (string.equalsIgnoreCase(";")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), string, this.st.sval);
                }
                case 125: {
                    if (string.equalsIgnoreCase("}")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), string, this.st.sval);
                }
                case 61: {
                    if (string.equalsIgnoreCase("=")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), string, this.st.sval);
                }
                default: {
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.found.value.", new Integer(this.linenum), string, this.st.sval);
                }
            }
            return string2;
        }

        private boolean peek(String string) {
            switch (this.lookahead) {
                case 44: {
                    return string.equalsIgnoreCase(",");
                }
                case 59: {
                    return string.equalsIgnoreCase(";");
                }
                case 123: {
                    return string.equalsIgnoreCase("{");
                }
                case 125: {
                    return string.equalsIgnoreCase("}");
                }
            }
            return false;
        }

        private int nextToken() throws IOException {
            int n;
            while ((n = this.st.nextToken()) == 10) {
                ++this.linenum;
            }
            return n;
        }

        private InputStream getInputStream(URL uRL) throws IOException {
            if ("file".equalsIgnoreCase(uRL.getProtocol())) {
                try {
                    return uRL.openStream();
                }
                catch (Exception exception) {
                    String string = uRL.getPath();
                    if (uRL.getHost().length() > 0) {
                        string = "//" + uRL.getHost() + string;
                    }
                    if (debugConfig != null) {
                        debugConfig.println("cannot read " + uRL + ", try " + string);
                    }
                    return new FileInputStream(string);
                }
            }
            return uRL.openStream();
        }

        private String expand(String string) throws PropertyExpander.ExpandException, IOException {
            if (string.isEmpty()) {
                return string;
            }
            if (!this.expandProp) {
                return string;
            }
            String string2 = PropertyExpander.expand(string);
            if (string2 == null || string2.length() == 0) {
                throw this.ioException("Configuration.Error.Line.line.system.property.value.expanded.to.empty.value", new Integer(this.linenum), string);
            }
            return string2;
        }

        private IOException ioException(String string, Object ... objectArray) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString(string, "sun.security.util.AuthResources"));
            return new IOException(messageFormat.format(objectArray));
        }
    }
}

