/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members.nb;

import au.com.trgtd.tr.autoupdate.members.nb.ProxySettings;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbProxySelector
extends ProxySelector {
    private ProxySelector original = ProxySelector.getDefault();
    private static Logger log = Logger.getLogger(NbProxySelector.class.getName());
    private static Object useSystemProxies;

    public NbProxySelector() {
        log.fine("Override the original ProxySelector: " + this.original);
        log.fine("java.net.useSystemProxies has been set to " + NbProxySelector.useSystemProxies());
        log.fine("In launcher was detected netbeans.system_http_proxy: " + System.getProperty("netbeans.system_http_proxy", "N/A"));
        log.fine("In launcher was detected netbeans.system_socks_proxy: " + System.getProperty("netbeans.system_socks_proxy", "N/A"));
        ProxySettings.addPreferenceChangeListener(new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Object> res = new ArrayList();
        int proxyType = ProxySettings.getProxyType();
        if (0 == proxyType) {
            res = Collections.singletonList(Proxy.NO_PROXY);
        } else if (1 == proxyType) {
            if (NbProxySelector.useSystemProxies()) {
                res = this.original.select(uri);
            } else {
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.SystemProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String ports = ProxySettings.SystemProxySettings.getHttpPort();
                    if (ports != null && ports.length() > 0 && ProxySettings.SystemProxySettings.getHttpHost().length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.SystemProxySettings.getHttpHost(), porti));
                        res.add(p);
                    }
                } else {
                    String ports = ProxySettings.SystemProxySettings.getSocksPort();
                    String hosts = ProxySettings.SystemProxySettings.getSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    }
                }
                res.addAll(this.original.select(uri));
            }
        } else if (2 == proxyType) {
            String protocol = uri.getScheme();
            assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
            if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                res.add(Proxy.NO_PROXY);
            }
            if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                String hosts = ProxySettings.getHttpHost();
                String ports = ProxySettings.getHttpPort();
                if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                    int porti = Integer.parseInt(ports);
                    Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hosts, porti));
                    res.add(p);
                } else {
                    log.info("Incomplete HTTP Proxy [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                    log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                    res.addAll(this.original.select(uri));
                }
            } else {
                String ports = ProxySettings.getSocksPort();
                String hosts = ProxySettings.getSocksHost();
                if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                    int porti = Integer.parseInt(ports);
                    Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                    res.add(p);
                } else {
                    log.info("Incomplete SOCKS Server [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                    log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                    res.addAll(this.original.select(uri));
                }
            }
            res.add(Proxy.NO_PROXY);
        } else assert (false) : "Invalid proxy type: " + ProxySettings.getProxyType();
        log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + ", Use HTTP for all protocols: " + ProxySettings.useProxyAllProtocols() + "] returns " + res + " for URI " + uri);
        return res;
    }

    @Override
    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
        log.log(Level.INFO, "connectionFailed(" + arg0 + ", " + arg1 + ")", arg2);
    }

    private void copySettingsToSystem() {
        String host = null;
        String port = null;
        String nonProxyHosts = null;
        String sHost = null;
        String sPort = null;
        String httpsHost = null;
        String httpsPort = null;
        int proxyType = ProxySettings.getProxyType();
        if (0 == proxyType) {
            host = null;
            port = null;
            httpsHost = null;
            httpsPort = null;
            nonProxyHosts = null;
            sHost = null;
            sPort = null;
        } else if (1 == proxyType) {
            host = ProxySettings.SystemProxySettings.getHttpHost();
            port = ProxySettings.SystemProxySettings.getHttpPort();
            httpsHost = ProxySettings.SystemProxySettings.getHttpsHost();
            httpsPort = ProxySettings.SystemProxySettings.getHttpsPort();
            nonProxyHosts = ProxySettings.SystemProxySettings.getNonProxyHosts();
            sHost = ProxySettings.SystemProxySettings.getSocksHost();
            sPort = ProxySettings.SystemProxySettings.getSocksPort();
        } else if (2 == proxyType) {
            host = ProxySettings.getHttpHost();
            port = ProxySettings.getHttpPort();
            httpsHost = ProxySettings.getHttpsHost();
            httpsPort = ProxySettings.getHttpsPort();
            nonProxyHosts = ProxySettings.getNonProxyHosts();
            sHost = ProxySettings.getSocksHost();
            sPort = ProxySettings.getSocksPort();
        } else assert (false) : "Invalid proxy type: " + proxyType;
        this.setOrClearProperty("http.proxyHost", host, false);
        this.setOrClearProperty("http.proxyPort", port, true);
        this.setOrClearProperty("http.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("https.proxyHost", httpsHost, false);
        this.setOrClearProperty("https.proxyPort", httpsPort, true);
        this.setOrClearProperty("https.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("socksProxyHost", sHost, false);
        this.setOrClearProperty("socksProxyPort", sPort, true);
        log.fine("Set System's http.proxyHost/Port/NonProxyHost to " + host + "/" + port + "/" + nonProxyHosts);
        log.fine("Set System's https.proxyHost/Port to " + httpsHost + "/" + httpsPort);
        log.fine("Set System's socksProxyHost/Port to " + sHost + "/" + sPort);
    }

    private void setOrClearProperty(String key, String value, boolean isInteger) {
        assert (key != null);
        if (value == null || value.length() == 0) {
            System.clearProperty(key);
        } else {
            if (isInteger) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    log.log(Level.INFO, nfe.getMessage(), nfe);
                }
            }
            System.setProperty(key, value);
        }
    }

    static boolean dontUseProxy(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        if (NbProxySelector.dontUseIp(nonProxyHosts, host)) {
            return true;
        }
        return NbProxySelector.dontUseHostName(nonProxyHosts, host);
    }

    private static boolean dontUseHostName(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            dontUseProxy = host.startsWith(start) && host.endsWith(end);
            if (!dontUseProxy) continue;
            log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
        }
        return dontUseProxy;
    }

    private static boolean dontUseIp(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        String ip = null;
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            log.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
        if (ip == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String nonProxyHost = st.nextToken();
            int star = nonProxyHost.indexOf("*");
            if (star == -1) {
                dontUseProxy = nonProxyHost.equals(ip);
                if (!dontUseProxy) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP " + ip + " found in nonProxyHosts: " + nonProxyHosts);
                continue;
            }
            try {
                dontUseProxy = Pattern.matches(nonProxyHost, ip);
                if (!dontUseProxy) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP" + ip + " found in nonProxyHosts: " + nonProxyHosts);
            }
            catch (PatternSyntaxException pse) {}
        }
        return dontUseProxy;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            try {
                Class<?> clazz = Class.forName("sun.net.NetProperties");
                Method getBoolean = clazz.getMethod("getBoolean", String.class);
                useSystemProxies = getBoolean.invoke(null, "java.net.useSystemProxies");
            }
            catch (Exception x) {
                log.log(Level.FINEST, "Cannot get value of java.net.useSystemProxies bacause " + x.getMessage(), x);
            }
        }
        return useSystemProxies != null && "true".equalsIgnoreCase(useSystemProxies.toString());
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey().startsWith("proxy") || evt.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

