/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.rights.User;

public class SessionManager {
    AtomicLong sessionIdCount = new AtomicLong();
    private LongKeyHashMap sessionMap = new LongKeyHashMap();
    private Session sysSession;
    private Session sysLobSession;

    public SessionManager(Database database) {
        User user = database.getUserManager().getSysUser();
        this.sysSession = new Session(database, user, false, false, this.sessionIdCount.getAndIncrement(), null, 0);
        this.sysLobSession = new Session(database, user, true, false, this.sessionIdCount.getAndIncrement(), null, 0);
    }

    public synchronized Session newSession(Database database, User user, boolean bl, boolean bl2, String string, int n) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, user, bl2, bl, l, string, n);
        this.sessionMap.put(l, session);
        return session;
    }

    public synchronized Session newSessionForLog(Database database) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, l, null, 0);
        session.isProcessingLog = true;
        this.sessionMap.put(l, session);
        return session;
    }

    public Session getSysSessionForScript(Database database) {
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, 0L, null, 0);
        session.setCurrentSchemaHsqlName(database.schemaManager.defaultSchemaHsqlName);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public synchronized Session newSysSession() {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, l, null, 0);
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(l, session);
        return session;
    }

    public synchronized Session newSysSession(HsqlNameManager.HsqlName hsqlName, User user) {
        long l = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, user, false, false, l, null, 0);
        session.currentSchema = hsqlName;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Session[] sessionArray = this.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            sessionArray[i].close();
        }
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            this.sessionMap.clear();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long l) {
        return (Session)this.sessionMap.get(l);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = (Session)iterator.next();
            ++n;
        }
        return sessionArray;
    }

    public synchronized boolean isUserActive(String string) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (!session.isClosed() && string.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session.getCurrentSchemaHsqlName() == hsqlName) {
                session.resetSchema();
            }
            ++n;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.loggedSchema = null;
            ++n;
        }
        this.sysLobSession.loggedSchema = null;
    }
}

