/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusHead
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int CHANNEL_COUNT;
    public static final int PRE_SKIP;
    public static final int INPUT_SAMPLE_RATE;
    public static final int OUTPUT_GAIN;
    public static final int MAPPING_FAMILY;
    public static final int STREAM_COUNT;
    public static final int COUPLED_COUNT;
    public static final int MAPPING;

    public OpusHead(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OpusHead.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int version() {
        return OpusHead.nversion(this.address());
    }

    public int channel_count() {
        return OpusHead.nchannel_count(this.address());
    }

    @NativeType(value="unsigned int")
    public int pre_skip() {
        return OpusHead.npre_skip(this.address());
    }

    @NativeType(value="opus_uint32")
    public int input_sample_rate() {
        return OpusHead.ninput_sample_rate(this.address());
    }

    public int output_gain() {
        return OpusHead.noutput_gain(this.address());
    }

    public int mapping_family() {
        return OpusHead.nmapping_family(this.address());
    }

    public int stream_count() {
        return OpusHead.nstream_count(this.address());
    }

    public int coupled_count() {
        return OpusHead.ncoupled_count(this.address());
    }

    @NativeType(value="unsigned char[255]")
    public ByteBuffer mapping() {
        return OpusHead.nmapping(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mapping(int index) {
        return OpusHead.nmapping(this.address(), index);
    }

    public static OpusHead malloc() {
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OpusHead calloc() {
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OpusHead create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OpusHead create(long address) {
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)address);
    }

    @Nullable
    public static OpusHead createSafe(long address) {
        return address == 0L ? null : (OpusHead)OpusHead.wrap(OpusHead.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OpusHead.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OpusHead.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OpusHead.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusHead.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OpusHead.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OpusHead.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OpusHead.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OpusHead malloc(MemoryStack stack) {
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OpusHead calloc(MemoryStack stack) {
        return (OpusHead)OpusHead.wrap(OpusHead.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusHead.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OpusHead.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static int nchannel_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHANNEL_COUNT);
    }

    public static int npre_skip(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRE_SKIP);
    }

    public static int ninput_sample_rate(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUT_SAMPLE_RATE);
    }

    public static int noutput_gain(long struct) {
        return UNSAFE.getInt(null, struct + (long)OUTPUT_GAIN);
    }

    public static int nmapping_family(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAPPING_FAMILY);
    }

    public static int nstream_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)STREAM_COUNT);
    }

    public static int ncoupled_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUPLED_COUNT);
    }

    public static ByteBuffer nmapping(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)MAPPING), (int)255);
    }

    public static byte nmapping(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)MAPPING + Checks.check((int)index, (int)255) * 1L);
    }

    static {
        Struct.Layout layout = OpusHead.__struct((Struct.Member[])new Struct.Member[]{OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__member((int)4), OpusHead.__array((int)1, (int)255)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        CHANNEL_COUNT = layout.offsetof(1);
        PRE_SKIP = layout.offsetof(2);
        INPUT_SAMPLE_RATE = layout.offsetof(3);
        OUTPUT_GAIN = layout.offsetof(4);
        MAPPING_FAMILY = layout.offsetof(5);
        STREAM_COUNT = layout.offsetof(6);
        COUPLED_COUNT = layout.offsetof(7);
        MAPPING = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<OpusHead, Buffer>
    implements NativeResource {
        private static final OpusHead ELEMENT_FACTORY = OpusHead.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OpusHead getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int version() {
            return OpusHead.nversion(this.address());
        }

        public int channel_count() {
            return OpusHead.nchannel_count(this.address());
        }

        @NativeType(value="unsigned int")
        public int pre_skip() {
            return OpusHead.npre_skip(this.address());
        }

        @NativeType(value="opus_uint32")
        public int input_sample_rate() {
            return OpusHead.ninput_sample_rate(this.address());
        }

        public int output_gain() {
            return OpusHead.noutput_gain(this.address());
        }

        public int mapping_family() {
            return OpusHead.nmapping_family(this.address());
        }

        public int stream_count() {
            return OpusHead.nstream_count(this.address());
        }

        public int coupled_count() {
            return OpusHead.ncoupled_count(this.address());
        }

        @NativeType(value="unsigned char[255]")
        public ByteBuffer mapping() {
            return OpusHead.nmapping(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mapping(int index) {
            return OpusHead.nmapping(this.address(), index);
        }
    }
}

