/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::StructByValue"}, parent="FFI::Type")
public final class StructByValue
extends Type {
    private final StructLayout structLayout;
    private final RubyClass structClass;

    public static RubyClass createStructByValueClass(ThreadContext context, RubyModule FFI2, RubyClass Type2) {
        return (RubyClass)Type2.setConstant(context, "Struct", (IRubyObject)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, "StructByValue", Type2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, StructByValue.class)).defineConstants(context, StructByValue.class));
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static final IRubyObject newStructByValue(ThreadContext context, IRubyObject klass, IRubyObject structClass1) {
        RubyClass structClass = Convert.castAsClass(context, structClass1);
        if (!structClass.isKindOfModule(context.runtime.getFFI().structClass)) {
            throw Error.typeError(context, (IRubyObject)structClass, "subclass of FFI::Struct");
        }
        return new StructByValue(context, (RubyClass)klass, structClass, Struct.getStructLayout(context, structClass));
    }

    private StructByValue(ThreadContext context, RubyClass klass, RubyClass structClass, StructLayout structLayout) {
        super(context.runtime, klass, NativeType.STRUCT, structLayout.size, structLayout.alignment);
        this.structClass = structClass;
        this.structLayout = structLayout;
    }

    @Deprecated(since="10.0")
    StructByValue(Ruby runtime2, RubyClass structClass, StructLayout structLayout) {
        super(runtime2, Access.getClass(runtime2.getCurrentContext(), "FFI", "Type", "Struct"), NativeType.STRUCT, structLayout.size, structLayout.alignment);
        this.structClass = structClass;
        this.structLayout = structLayout;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        return Create.newString(context, String.format("#<FFI::StructByValue:%s>", this.structClass.getName(context)));
    }

    @JRubyMethod(name={"layout"})
    public final IRubyObject layout(ThreadContext context) {
        return this.structLayout;
    }

    @JRubyMethod(name={"struct_class"})
    public final IRubyObject struct_class(ThreadContext context) {
        return this.structClass;
    }

    public final StructLayout getStructLayout() {
        return this.structLayout;
    }

    public final RubyClass getStructClass() {
        return this.structClass;
    }
}

