/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.value.SequenceExtent;

public class ArrayIterator
implements UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    protected Item[] items;
    private int index;
    protected int start;
    protected int end;
    private Item current = null;

    public ArrayIterator(Item[] nodes) {
        this.items = nodes;
        this.start = 0;
        this.end = nodes.length;
        this.index = 0;
    }

    public ArrayIterator(Item[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = start;
    }

    public SequenceIterator makeSliceIterator(int min, int max) {
        int newEnd;
        int newStart;
        Item[] items = this.getArray();
        int currentStart = this.getStartPosition();
        int currentEnd = this.getEndPosition();
        if (min < 1) {
            min = 1;
        }
        if ((newStart = currentStart + (min - 1)) < currentStart) {
            newStart = currentStart;
        }
        int n = newEnd = max == Integer.MAX_VALUE ? currentEnd : newStart + (max - min + 1);
        if (newEnd > currentEnd) {
            newEnd = currentEnd;
        }
        if (newEnd <= newStart) {
            return EmptyIterator.getInstance();
        }
        return new ArrayIterator(items, newStart, newEnd);
    }

    public boolean hasNext() {
        return this.index < this.end;
    }

    public Item next() {
        if (this.index >= this.end) {
            this.index = this.end + 1;
            this.current = null;
            return null;
        }
        this.current = this.items[this.index++];
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        if (this.index > this.end) {
            return -1;
        }
        return this.index - this.start;
    }

    public int getLastPosition() {
        return this.end - this.start;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new ArrayIterator(this.items, this.start, this.end);
    }

    public SequenceIterator getReverseIterator() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    public Item[] getArray() {
        return this.items;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }

    public GroundedValue materialize() {
        if (this.start == 0 && this.end == this.items.length) {
            return new SequenceExtent(this.items);
        }
        SequenceExtent e = new SequenceExtent(this.items);
        return new SequenceExtent(e, this.start, this.end - this.start);
    }

    public int getProperties() {
        return 7;
    }
}

