<?php
/**
 * SecurityAndAccessEndpointsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * SecurityAndAccessEndpointsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SecurityAndAccessEndpointsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteOrgsIDMembersID
     *
     * Remove a member from an organization
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsIDMembersID($user_id, $org_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDMembersIDWithHttpInfo($user_id, $org_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDMembersIDWithHttpInfo
     *
     * Remove a member from an organization
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDMembersIDWithHttpInfo($user_id, $org_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDMembersIDRequest($user_id, $org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsIDMembersID'
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDMembersIDRequest($user_id, $org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteOrgsIDMembersID'
            );
        }
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsIDMembersID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteOrgsIDOwnersID
     *
     * Remove an owner from an organization
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsIDOwnersID($user_id, $org_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDOwnersIDWithHttpInfo($user_id, $org_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDOwnersIDWithHttpInfo
     *
     * Remove an owner from an organization
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDOwnersIDWithHttpInfo($user_id, $org_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDOwnersIDRequest($user_id, $org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDOwnersIDRequest($user_id, $org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteOrgsIDOwnersID'
            );
        }
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteOrgsIDSecretsID
     *
     * Delete a secret from an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $secret_id The secret ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrgsIDSecretsID($org_id, $secret_id, $zap_trace_span = null)
    {
        $this->deleteOrgsIDSecretsIDWithHttpInfo($org_id, $secret_id, $zap_trace_span);
    }

    /**
     * Operation deleteOrgsIDSecretsIDWithHttpInfo
     *
     * Delete a secret from an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $secret_id The secret ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrgsIDSecretsIDWithHttpInfo($org_id, $secret_id, $zap_trace_span = null)
    {
        $request = $this->deleteOrgsIDSecretsIDRequest($org_id, $secret_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteOrgsIDSecretsID'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $secret_id The secret ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteOrgsIDSecretsIDRequest($org_id, $secret_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteOrgsIDSecretsID'
            );
        }
        // verify the required parameter 'secret_id' is set
        if ($secret_id === null || (is_array($secret_id) && count($secret_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secret_id when calling deleteOrgsIDSecretsID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/secrets/{secretID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($secret_id !== null) {
            $resourcePath = str_replace(
                '{' . 'secretID' . '}',
                ObjectSerializer::toPathValue($secret_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getAuthorizations
     *
     * List authorizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorizations|string|object|\InfluxDB2\Model\Error|string
     */
    public function getAuthorizations($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {
        list($response) = $this->getAuthorizationsWithHttpInfo($zap_trace_span, $user_id, $user, $org_id, $org);
        return $response;
    }

    /**
     * Operation getAuthorizationsWithHttpInfo
     *
     * List authorizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorizations|string|object|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAuthorizationsWithHttpInfo($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {
        $request = $this->getAuthorizationsRequest($zap_trace_span, $user_id, $user, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorizations';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getAuthorizations'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $user_id A user ID. Only returns authorizations scoped to this user. (optional)
     * @param  string $user A user name. Only returns authorizations scoped to this user. (optional)
     * @param  string $org_id An organization ID. Only returns authorizations that belong to this organization. (optional)
     * @param  string $org An organization name. Only returns authorizations that belong to this organization. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getAuthorizationsRequest($zap_trace_span = null, $user_id = null, $user = null, $org_id = null, $org = null)
    {

        $resourcePath = '/api/v2/authorizations';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($user_id !== null) {
            $queryParams['userID'] = ObjectSerializer::toQueryValue($user_id);
        }
        // query params
        if ($user !== null) {
            $queryParams['user'] = ObjectSerializer::toQueryValue($user);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getAuthorizationsID
     *
     * Retrieve an authorization
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Authorization|string
     */
    public function getAuthorizationsID($auth_id, $zap_trace_span = null)
    {
        list($response) = $this->getAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getAuthorizationsIDWithHttpInfo
     *
     * Retrieve an authorization
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Authorization|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAuthorizationsIDWithHttpInfo($auth_id, $zap_trace_span = null)
    {
        $request = $this->getAuthorizationsIDRequest($auth_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Authorization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getAuthorizationsID'
     *
     * @param  string $auth_id The ID of the authorization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getAuthorizationsIDRequest($auth_id, $zap_trace_span = null)
    {
        // verify the required parameter 'auth_id' is set
        if ($auth_id === null || (is_array($auth_id) && count($auth_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $auth_id when calling getAuthorizationsID'
            );
        }

        $resourcePath = '/api/v2/authorizations/{authID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($auth_id !== null) {
            $resourcePath = str_replace(
                '{' . 'authID' . '}',
                ObjectSerializer::toPathValue($auth_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgs
     *
     * List organizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organizations|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getOrgs($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        list($response) = $this->getOrgsWithHttpInfo($zap_trace_span, $offset, $limit, $descending, $org, $org_id, $user_id);
        return $response;
    }

    /**
     * Operation getOrgsWithHttpInfo
     *
     * List organizations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organizations|\InfluxDB2\Model\Error|object|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsWithHttpInfo($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        $request = $this->getOrgsRequest($zap_trace_span, $offset, $limit, $descending, $org, $org_id, $user_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organizations';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgs'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $org An organization name. Only returns organizations with this name. (optional)
     * @param  string $org_id An organization ID. Only returns the organization with this ID. (optional)
     * @param  string $user_id A user ID. Only returns organizations where this user is a member or owner. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsRequest($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $org = null, $org_id = null, $user_id = null)
    {
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling SecurityAndAccessEndpointsService.getOrgs, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling SecurityAndAccessEndpointsService.getOrgs, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling SecurityAndAccessEndpointsService.getOrgs, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/orgs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($descending !== null) {
            $queryParams['descending'] = ObjectSerializer::toQueryValue($descending);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($user_id !== null) {
            $queryParams['userID'] = ObjectSerializer::toQueryValue($user_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsID
     *
     * Retrieve an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error
     */
    public function getOrgsID($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDWithHttpInfo
     *
     * Retrieve an organization
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Organization|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Organization';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsID'
     *
     * @param  string $org_id The ID of the organization to get. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsID'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsIDMembers
     *
     * List all members of an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getOrgsIDMembers($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDMembersWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDMembersWithHttpInfo
     *
     * List all members of an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDMembersWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDMembersRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsIDMembers'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDMembersRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsIDMembers'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsIDOwners
     *
     * List all owners of an organization
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getOrgsIDOwners($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDOwnersWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDOwnersWithHttpInfo
     *
     * List all owners of an organization
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDOwnersWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDOwnersRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsIDOwners'
     *
     * @param  string $org_id The ID of the organization to list owners for. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDOwnersRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsIDOwners'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getOrgsIDSecrets
     *
     * List all secret keys for an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\SecretKeysResponse|\InfluxDB2\Model\Error
     */
    public function getOrgsIDSecrets($org_id, $zap_trace_span = null)
    {
        list($response) = $this->getOrgsIDSecretsWithHttpInfo($org_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getOrgsIDSecretsWithHttpInfo
     *
     * List all secret keys for an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\SecretKeysResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgsIDSecretsWithHttpInfo($org_id, $zap_trace_span = null)
    {
        $request = $this->getOrgsIDSecretsRequest($org_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\SecretKeysResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getOrgsIDSecrets'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getOrgsIDSecretsRequest($org_id, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgsIDSecrets'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/secrets';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getUsers
     *
     * List users
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $name name (optional)
     * @param  string $id id (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Users|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string
     */
    public function getUsers($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $name = null, $id = null)
    {
        list($response) = $this->getUsersWithHttpInfo($zap_trace_span, $offset, $limit, $after, $name, $id);
        return $response;
    }

    /**
     * Operation getUsersWithHttpInfo
     *
     * List users
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $name (optional)
     * @param  string $id (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Users|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUsersWithHttpInfo($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $name = null, $id = null)
    {
        $request = $this->getUsersRequest($zap_trace_span, $offset, $limit, $after, $name, $id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Users';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getUsers'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  string $after Resource ID to seek from. Results are not inclusive of this ID. Use &#x60;after&#x60; instead of &#x60;offset&#x60;. (optional)
     * @param  string $name (optional)
     * @param  string $id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getUsersRequest($zap_trace_span = null, $offset = null, $limit = 20, $after = null, $name = null, $id = null)
    {
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling SecurityAndAccessEndpointsService.getUsers, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling SecurityAndAccessEndpointsService.getUsers, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling SecurityAndAccessEndpointsService.getUsers, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/users';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($after !== null) {
            $queryParams['after'] = ObjectSerializer::toQueryValue($after);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = ObjectSerializer::toQueryValue($name);
        }
        // query params
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getUsersID
     *
     * Retrieve a user
     *
     * @param  string $user_id The user ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\User|string
     */
    public function getUsersID($user_id, $zap_trace_span = null)
    {
        list($response) = $this->getUsersIDWithHttpInfo($user_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getUsersIDWithHttpInfo
     *
     * Retrieve a user
     *
     * @param  string $user_id The user ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\User|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUsersIDWithHttpInfo($user_id, $zap_trace_span = null)
    {
        $request = $this->getUsersIDRequest($user_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\User';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getUsersID'
     *
     * @param  string $user_id The user ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getUsersIDRequest($user_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling getUsersID'
            );
        }

        $resourcePath = '/api/v2/users/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postOrgsIDSecrets
     *
     * Delete secrets from an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\SecretKeys $secret_keys Secret key to delete (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postOrgsIDSecrets($org_id, $secret_keys, $zap_trace_span = null)
    {
        $this->postOrgsIDSecretsWithHttpInfo($org_id, $secret_keys, $zap_trace_span);
    }

    /**
     * Operation postOrgsIDSecretsWithHttpInfo
     *
     * Delete secrets from an organization
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\SecretKeys $secret_keys Secret key to delete (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postOrgsIDSecretsWithHttpInfo($org_id, $secret_keys, $zap_trace_span = null)
    {
        $request = $this->postOrgsIDSecretsRequest($org_id, $secret_keys, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postOrgsIDSecrets'
     *
     * @param  string $org_id The organization ID. (required)
     * @param  \InfluxDB2\Model\SecretKeys $secret_keys Secret key to delete (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postOrgsIDSecretsRequest($org_id, $secret_keys, $zap_trace_span = null)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling postOrgsIDSecrets'
            );
        }
        // verify the required parameter 'secret_keys' is set
        if ($secret_keys === null || (is_array($secret_keys) && count($secret_keys) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secret_keys when calling postOrgsIDSecrets'
            );
        }

        $resourcePath = '/api/v2/orgs/{orgID}/secrets/delete';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orgID' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($secret_keys)) {
            $_tempBody = $secret_keys;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postUsersIDPassword
     *
     * Update a password
     *
     * @param  string $user_id The user ID. (required)
     * @param  \InfluxDB2\Model\PasswordResetBody $password_reset_body New password (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $authorization An auth credential for the Basic scheme (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postUsersIDPassword($user_id, $password_reset_body, $zap_trace_span = null, $authorization = null)
    {
        $this->postUsersIDPasswordWithHttpInfo($user_id, $password_reset_body, $zap_trace_span, $authorization);
    }

    /**
     * Operation postUsersIDPasswordWithHttpInfo
     *
     * Update a password
     *
     * @param  string $user_id The user ID. (required)
     * @param  \InfluxDB2\Model\PasswordResetBody $password_reset_body New password (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $authorization An auth credential for the Basic scheme (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postUsersIDPasswordWithHttpInfo($user_id, $password_reset_body, $zap_trace_span = null, $authorization = null)
    {
        $request = $this->postUsersIDPasswordRequest($user_id, $password_reset_body, $zap_trace_span, $authorization);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postUsersIDPassword'
     *
     * @param  string $user_id The user ID. (required)
     * @param  \InfluxDB2\Model\PasswordResetBody $password_reset_body New password (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $authorization An auth credential for the Basic scheme (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postUsersIDPasswordRequest($user_id, $password_reset_body, $zap_trace_span = null, $authorization = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling postUsersIDPassword'
            );
        }
        // verify the required parameter 'password_reset_body' is set
        if ($password_reset_body === null || (is_array($password_reset_body) && count($password_reset_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $password_reset_body when calling postUsersIDPassword'
            );
        }

        $resourcePath = '/api/v2/users/{userID}/password';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($authorization !== null) {
            $headerParams['Authorization'] = ObjectSerializer::toHeaderValue($authorization);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($password_reset_body)) {
            $_tempBody = $password_reset_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
