/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.util.HashMap;

public class RtfImportHeader {
    private HashMap importFontMapping = null;
    private HashMap importColorMapping = null;
    private RtfDocument rtfDoc = null;

    public RtfImportHeader(RtfDocument rtfDocument) {
        this.rtfDoc = rtfDocument;
        this.importFontMapping = new HashMap();
        this.importColorMapping = new HashMap();
    }

    public void importFont(String string, String string2) {
        RtfFont rtfFont = new RtfFont(string2);
        rtfFont.setRtfDocument(this.rtfDoc);
        this.importFontMapping.put(string, Integer.toString(this.rtfDoc.getDocumentHeader().getFontNumber(rtfFont)));
    }

    public String mapFontNr(String string) {
        if (this.importFontMapping.containsKey(string)) {
            return (String)this.importFontMapping.get(string);
        }
        return "0";
    }

    public void importColor(String string, Color color) {
        RtfColor rtfColor = new RtfColor(this.rtfDoc, color);
        this.importColorMapping.put(string, Integer.toString(rtfColor.getColorNumber()));
    }

    public String mapColorNr(String string) {
        if (this.importColorMapping.containsKey(string)) {
            return (String)this.importColorMapping.get(string);
        }
        return "0";
    }
}

