/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.ListWithCallbacks;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.NumberHelper;

public abstract class ProjectEntityContainer<T extends ProjectEntityWithUniqueID>
extends ListWithCallbacks<T> {
    protected final ProjectFile m_projectFile;
    protected Map<Integer, T> m_uniqueIDMap = new HashMap<Integer, T>();
    private static final int MS_PROJECT_MAX_UNIQUE_ID = 0x1FFFFF;

    public ProjectEntityContainer(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    protected int firstUniqueID() {
        return 1;
    }

    public void renumberUniqueIDs() {
        int n = this.firstUniqueID();
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this) {
            projectEntityWithUniqueID.setUniqueID(n++);
        }
    }

    public void validateUniqueIDsForMicrosoftProject() {
        if (!this.isEmpty()) {
            for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this) {
                if (NumberHelper.getInt(projectEntityWithUniqueID.getUniqueID()) <= 0x1FFFFF) continue;
                this.renumberUniqueIDs();
                break;
            }
        }
    }

    public T getByUniqueID(Integer n) {
        return (T)((ProjectEntityWithUniqueID)this.m_uniqueIDMap.get(n));
    }

    public void unmapUniqueID(Integer n) {
        this.m_uniqueIDMap.remove(n);
    }

    public void mapUniqueID(Integer n, T t) {
        this.m_uniqueIDMap.put(n, t);
    }
}

