/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InfoFromMemberName;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    private static final Permission ACCESS_PERMISSION;
    private static final MethodHandle[] IDENTITY_MHS;
    private static final MethodHandle[] ZERO_MHS;

    private MethodHandles() {
    }

    @CallerSensitive
    public static Lookup lookup() {
        return new Lookup(Reflection.getCallerClass());
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static <T extends Member> T reflectAs(Class<T> clazz, MethodHandle methodHandle) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        Lookup lookup = Lookup.IMPL_LOOKUP;
        return lookup.revealDirect(methodHandle).reflectAs(clazz, lookup);
    }

    public static MethodHandle arrayElementGetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(clazz, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(clazz, true);
    }

    public static MethodHandle spreadInvoker(MethodType methodType, int n) {
        if (n < 0 || n > methodType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad argument count", n);
        }
        methodType = methodType.asSpreaderType(Object[].class, methodType.parameterCount() - n);
        return methodType.invokers().spreadInvoker(n);
    }

    public static MethodHandle exactInvoker(MethodType methodType) {
        return methodType.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType methodType) {
        return methodType.invokers().genericInvoker();
    }

    static MethodHandle basicInvoker(MethodType methodType) {
        return methodType.invokers().basicInvoker();
    }

    public static MethodHandle explicitCastArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodHandles.explicitCastArgumentsChecks(methodHandle, methodType);
        MethodType methodType2 = methodHandle.type();
        if (methodType2 == methodType) {
            return methodHandle;
        }
        if (methodType2.explicitCastEquivalentToAsType(methodType)) {
            return methodHandle.asFixedArity().asType(methodType);
        }
        return MethodHandleImpl.makePairwiseConvert(methodHandle, methodType, false);
    }

    private static void explicitCastArgumentsChecks(MethodHandle methodHandle, MethodType methodType) {
        if (methodHandle.type().parameterCount() != methodType.parameterCount()) {
            throw new WrongMethodTypeException("cannot explicitly cast " + methodHandle + " to " + methodType);
        }
    }

    public static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, int ... nArray) {
        int n;
        nArray = (int[])nArray.clone();
        MethodType methodType2 = methodHandle.type();
        MethodHandles.permuteArgumentChecks(nArray, methodType, methodType2);
        int[] nArray2 = nArray;
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        LambdaForm lambdaForm = boundMethodHandle.form;
        int n2 = methodType.parameterCount();
        while ((n = MethodHandles.findFirstDupOrDrop(nArray, n2)) != 0) {
            int n3;
            int n4;
            int n5;
            if (n > 0) {
                int n6;
                n4 = n5 = n;
                int n7 = nArray[n5];
                n3 = 0;
                while ((n6 = nArray[--n4]) != n7) {
                    if (n7 <= n6) continue;
                    n3 = 1;
                }
                if (n3 == 0) {
                    n5 = n4;
                    n4 = n;
                }
                lambdaForm = lambdaForm.editor().dupArgumentForm(1 + n5, 1 + n4);
                assert (nArray[n5] == nArray[n4]);
                methodType2 = methodType2.dropParameterTypes(n4, n4 + 1);
                n6 = n4 + 1;
                System.arraycopy(nArray, n6, nArray, n4, nArray.length - n6);
                nArray = Arrays.copyOf(nArray, nArray.length - 1);
            } else {
                n5 = ~n;
                for (n4 = 0; n4 < nArray.length && nArray[n4] < n5; ++n4) {
                }
                Class<?> clazz = methodType.parameterType(n5);
                lambdaForm = lambdaForm.editor().addArgumentForm(1 + n4, LambdaForm.BasicType.basicType(clazz));
                methodType2 = methodType2.insertParameterTypes(n4, clazz);
                n3 = n4 + 1;
                nArray = Arrays.copyOf(nArray, nArray.length + 1);
                System.arraycopy(nArray, n4, nArray, n3, nArray.length - n3);
                nArray[n4] = n5;
            }
            assert (MethodHandles.permuteArgumentChecks(nArray, methodType, methodType2));
        }
        assert (nArray.length == n2);
        lambdaForm = lambdaForm.editor().permuteArgumentsForm(1, nArray);
        if (methodType == boundMethodHandle.type() && lambdaForm == boundMethodHandle.internalForm()) {
            return boundMethodHandle;
        }
        return boundMethodHandle.copyWith(methodType, lambdaForm);
    }

    private static int findFirstDupOrDrop(int[] nArray, int n) {
        int n2;
        if (n < 63) {
            long l = 0L;
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                if (n3 >= n) {
                    return nArray.length;
                }
                long l2 = 1L << n3;
                if ((l & l2) != 0L) {
                    return i;
                }
                l |= l2;
            }
            if (l == (1L << n) - 1L) {
                assert (Long.numberOfTrailingZeros(Long.lowestOneBit(l ^ 0xFFFFFFFFFFFFFFFFL)) == n);
                return 0;
            }
            long l3 = Long.lowestOneBit(l ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = Long.numberOfTrailingZeros(l3);
            assert (n4 <= n);
            if (n4 == n) {
                return 0;
            }
            return ~n4;
        }
        BitSet bitSet = new BitSet(n);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n5 = nArray[n2];
            if (n5 >= n) {
                return nArray.length;
            }
            if (bitSet.get(n5)) {
                return n2;
            }
            bitSet.set(n5);
        }
        n2 = bitSet.nextClearBit(0);
        assert (n2 <= n);
        if (n2 == n) {
            return 0;
        }
        return ~n2;
    }

    private static boolean permuteArgumentChecks(int[] nArray, MethodType methodType, MethodType methodType2) {
        if (methodType.returnType() != methodType2.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", methodType2, methodType);
        }
        if (nArray.length == methodType2.parameterCount()) {
            int n = methodType.parameterCount();
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                Class<?> clazz;
                int n2 = nArray[i];
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                    break;
                }
                Class<?> clazz2 = methodType.parameterType(n2);
                if (clazz2 == (clazz = methodType2.parameterType(i))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", methodType2, methodType);
            }
            if (!bl) {
                return true;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(nArray));
    }

    public static MethodHandle constant(Class<?> clazz, Object object) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            object = wrapper.convert(object, clazz);
            if (wrapper.zero().equals(object)) {
                return MethodHandles.zero(wrapper, clazz);
            }
            return MethodHandles.insertArguments(MethodHandles.identity(clazz), 0, object);
        }
        if (object == null) {
            return MethodHandles.zero(Wrapper.OBJECT, clazz);
        }
        return MethodHandles.identity(clazz).bindTo(object);
    }

    public static MethodHandle identity(Class<?> clazz) {
        Wrapper wrapper = clazz.isPrimitive() ? Wrapper.forPrimitiveType(clazz) : Wrapper.OBJECT;
        int n = wrapper.ordinal();
        MethodHandle methodHandle = IDENTITY_MHS[n];
        if (methodHandle == null) {
            methodHandle = MethodHandles.setCachedMethodHandle(IDENTITY_MHS, n, MethodHandles.makeIdentity(wrapper.primitiveType()));
        }
        if (methodHandle.type().returnType() == clazz) {
            return methodHandle;
        }
        assert (wrapper == Wrapper.OBJECT);
        return MethodHandles.makeIdentity(clazz);
    }

    private static MethodHandle makeIdentity(Class<?> clazz) {
        MethodType methodType = MethodType.methodType(clazz, clazz);
        LambdaForm lambdaForm = LambdaForm.identityForm(LambdaForm.BasicType.basicType(clazz));
        return MethodHandleImpl.makeIntrinsic(methodType, lambdaForm, MethodHandleImpl.Intrinsic.IDENTITY);
    }

    private static MethodHandle zero(Wrapper wrapper, Class<?> clazz) {
        int n = wrapper.ordinal();
        MethodHandle methodHandle = ZERO_MHS[n];
        if (methodHandle == null) {
            methodHandle = MethodHandles.setCachedMethodHandle(ZERO_MHS, n, MethodHandles.makeZero(wrapper.primitiveType()));
        }
        if (methodHandle.type().returnType() == clazz) {
            return methodHandle;
        }
        assert (wrapper == Wrapper.OBJECT);
        return MethodHandles.makeZero(clazz);
    }

    private static MethodHandle makeZero(Class<?> clazz) {
        MethodType methodType = MethodType.methodType(clazz);
        LambdaForm lambdaForm = LambdaForm.zeroForm(LambdaForm.BasicType.basicType(clazz));
        return MethodHandleImpl.makeIntrinsic(methodType, lambdaForm, MethodHandleImpl.Intrinsic.ZERO);
    }

    private static synchronized MethodHandle setCachedMethodHandle(MethodHandle[] methodHandleArray, int n, MethodHandle methodHandle) {
        MethodHandle methodHandle2 = methodHandleArray[n];
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        methodHandleArray[n] = methodHandle;
        return methodHandleArray[n];
    }

    public static MethodHandle insertArguments(MethodHandle methodHandle, int n, Object ... objectArray) {
        int n2 = objectArray.length;
        Class<?>[] classArray = MethodHandles.insertArgumentsChecks(methodHandle, n2, n);
        if (n2 == 0) {
            return methodHandle;
        }
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            Class<?> clazz = classArray[n + i];
            if (clazz.isPrimitive()) {
                boundMethodHandle = MethodHandles.insertArgumentPrimitive(boundMethodHandle, n, clazz, object);
                continue;
            }
            object = clazz.cast(object);
            boundMethodHandle = boundMethodHandle.bindArgumentL(n, object);
        }
        return boundMethodHandle;
    }

    private static BoundMethodHandle insertArgumentPrimitive(BoundMethodHandle boundMethodHandle, int n, Class<?> clazz, Object object) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        object = wrapper.convert(object, clazz);
        switch (wrapper) {
            case INT: {
                return boundMethodHandle.bindArgumentI(n, (Integer)object);
            }
            case LONG: {
                return boundMethodHandle.bindArgumentJ(n, (Long)object);
            }
            case FLOAT: {
                return boundMethodHandle.bindArgumentF(n, ((Float)object).floatValue());
            }
            case DOUBLE: {
                return boundMethodHandle.bindArgumentD(n, (Double)object);
            }
        }
        return boundMethodHandle.bindArgumentI(n, ValueConversions.widenSubword(object));
    }

    private static Class<?>[] insertArgumentsChecks(MethodHandle methodHandle, int n, int n2) throws RuntimeException {
        MethodType methodType = methodHandle.type();
        int n3 = methodType.parameterCount();
        int n4 = n3 - n;
        if (n4 < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (n2 < 0 || n2 > n4) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        return methodType.ptypes();
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, List<Class<?>> list) {
        list = MethodHandles.copyTypes(list);
        MethodType methodType = methodHandle.type();
        int n2 = MethodHandles.dropArgumentChecks(methodType, n, list);
        MethodType methodType2 = methodType.insertParameterTypes(n, list);
        if (n2 == 0) {
            return methodHandle;
        }
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        LambdaForm lambdaForm = boundMethodHandle.form;
        int n3 = 1 + n;
        for (Class<?> clazz : list) {
            lambdaForm = lambdaForm.editor().addArgumentForm(n3++, LambdaForm.BasicType.basicType(clazz));
        }
        boundMethodHandle = boundMethodHandle.copyWith(methodType2, lambdaForm);
        return boundMethodHandle;
    }

    private static List<Class<?>> copyTypes(List<Class<?>> list) {
        Object[] objectArray = list.toArray();
        return Arrays.asList(Arrays.copyOf(objectArray, objectArray.length, Class[].class));
    }

    private static int dropArgumentChecks(MethodType methodType, int n, List<Class<?>> list) {
        int n2 = list.size();
        MethodType.checkSlotCount(n2);
        int n3 = methodType.parameterCount();
        int n4 = n3 + n2;
        if (n < 0 || n > n3) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove" + Arrays.asList(methodType, n, list, n4, n3));
        }
        return n2;
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        return MethodHandles.dropArguments(methodHandle, n, Arrays.asList(classArray));
    }

    public static MethodHandle filterArguments(MethodHandle methodHandle, int n, MethodHandle ... methodHandleArray) {
        MethodHandles.filterArgumentsCheckArity(methodHandle, n, methodHandleArray);
        MethodHandle methodHandle2 = methodHandle;
        int n2 = n - 1;
        for (MethodHandle methodHandle3 : methodHandleArray) {
            ++n2;
            if (methodHandle3 == null) continue;
            methodHandle2 = MethodHandles.filterArgument(methodHandle2, n2, methodHandle3);
        }
        return methodHandle2;
    }

    static MethodHandle filterArgument(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        MethodHandles.filterArgumentChecks(methodHandle, n, methodHandle2);
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        Class<?> clazz = methodType2.parameterType(0);
        LambdaForm lambdaForm = boundMethodHandle.editor().filterArgumentForm(1 + n, LambdaForm.BasicType.basicType(clazz));
        MethodType methodType3 = methodType.changeParameterType(n, clazz);
        boundMethodHandle = boundMethodHandle.copyWithExtendL(methodType3, lambdaForm, methodHandle2);
        return boundMethodHandle;
    }

    private static void filterArgumentsCheckArity(MethodHandle methodHandle, int n, MethodHandle[] methodHandleArray) {
        MethodType methodType = methodHandle.type();
        int n2 = methodType.parameterCount();
        if (n + methodHandleArray.length > n2) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
    }

    private static void filterArgumentChecks(MethodHandle methodHandle, int n, MethodHandle methodHandle2) throws RuntimeException {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (methodType2.parameterCount() != 1 || methodType2.returnType() != methodType.parameterType(n)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", methodType, methodType2);
        }
    }

    public static MethodHandle collectArguments(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        LambdaForm lambdaForm;
        MethodType methodType = MethodHandles.collectArgumentsChecks(methodHandle, n, methodHandle2);
        MethodType methodType2 = methodHandle2.type();
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        if (methodType2.returnType().isArray() && methodHandle2.intrinsicName() == MethodHandleImpl.Intrinsic.NEW_ARRAY && (lambdaForm = boundMethodHandle.editor().collectArgumentArrayForm(1 + n, methodHandle2)) != null) {
            return boundMethodHandle.copyWith(methodType, lambdaForm);
        }
        lambdaForm = boundMethodHandle.editor().collectArgumentsForm(1 + n, methodType2.basicType());
        return boundMethodHandle.copyWithExtendL(methodType, lambdaForm, methodHandle2);
    }

    private static MethodType collectArgumentsChecks(MethodHandle methodHandle, int n, MethodHandle methodHandle2) throws RuntimeException {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        Class<?> clazz = methodType2.returnType();
        List<Class<?>> list = methodType2.parameterList();
        if (clazz == Void.TYPE) {
            return methodType.insertParameterTypes(n, list);
        }
        if (clazz != methodType.parameterType(n)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", methodType, methodType2);
        }
        return methodType.dropParameterTypes(n, n + 1).insertParameterTypes(n, list);
    }

    public static MethodHandle filterReturnValue(MethodHandle methodHandle, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        MethodHandles.filterReturnValueChecks(methodType, methodType2);
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(methodType2.returnType());
        LambdaForm lambdaForm = boundMethodHandle.editor().filterReturnForm(basicType, false);
        MethodType methodType3 = methodType.changeReturnType(methodType2.returnType());
        boundMethodHandle = boundMethodHandle.copyWithExtendL(methodType3, lambdaForm, methodHandle2);
        return boundMethodHandle;
    }

    private static void filterReturnValueChecks(MethodType methodType, MethodType methodType2) throws RuntimeException {
        Class<?> clazz = methodType.returnType();
        int n = methodType2.parameterCount();
        if (n == 0 ? clazz != Void.TYPE : clazz != methodType2.parameterType(0) || n != 1) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", methodType, methodType2);
        }
    }

    public static MethodHandle foldArguments(MethodHandle methodHandle, MethodHandle methodHandle2) {
        int n = 0;
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        Class<?> clazz = MethodHandles.foldArgumentChecks(n, methodType, methodType2);
        BoundMethodHandle boundMethodHandle = methodHandle.rebind();
        boolean bl = clazz == Void.TYPE;
        LambdaForm lambdaForm = boundMethodHandle.editor().foldArgumentsForm(1 + n, bl, methodType2.basicType());
        MethodType methodType3 = methodType;
        if (!bl) {
            methodType3 = methodType3.dropParameterTypes(n, n + 1);
        }
        boundMethodHandle = boundMethodHandle.copyWithExtendL(methodType3, lambdaForm, methodHandle2);
        return boundMethodHandle;
    }

    private static Class<?> foldArgumentChecks(int n, MethodType methodType, MethodType methodType2) {
        boolean bl;
        int n2 = methodType2.parameterCount();
        Class<?> clazz = methodType2.returnType();
        int n3 = clazz == Void.TYPE ? 0 : 1;
        int n4 = n + n3;
        boolean bl2 = bl = methodType.parameterCount() >= n4 + n2;
        if (bl && !methodType2.parameterList().equals(methodType.parameterList().subList(n4, n4 + n2))) {
            bl = false;
        }
        if (bl && n3 != 0 && methodType2.returnType() != methodType.parameterType(0)) {
            bl = false;
        }
        if (!bl) {
            throw MethodHandles.misMatchedTypes("target and combiner types", methodType, methodType2);
        }
        return clazz;
    }

    public static MethodHandle guardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        List<Class<?>> list;
        MethodType methodType;
        MethodType methodType2 = methodHandle.type();
        MethodType methodType3 = methodHandle2.type();
        if (!methodType3.equals((Object)(methodType = methodHandle3.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", methodType3, methodType);
        }
        if (methodType2.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + methodType2);
        }
        List<Class<?>> list2 = methodType3.parameterList();
        if (!list2.equals(list = methodType2.parameterList())) {
            int n;
            int n2 = list.size();
            if (n2 >= (n = list2.size()) || !list2.subList(0, n2).equals(list)) {
                throw MethodHandles.misMatchedTypes("target and test types", methodType3, methodType2);
            }
            methodHandle = MethodHandles.dropArguments(methodHandle, n2, list2.subList(n2, n));
            methodType2 = methodHandle.type();
        }
        return MethodHandleImpl.makeGuardWithTest(methodHandle, methodHandle2, methodHandle3);
    }

    static RuntimeException misMatchedTypes(String string, MethodType methodType, MethodType methodType2) {
        return MethodHandleStatics.newIllegalArgumentException(string + " must match: " + methodType + " != " + methodType2);
    }

    public static MethodHandle catchException(MethodHandle methodHandle, Class<? extends Throwable> clazz, MethodHandle methodHandle2) {
        MethodType methodType = methodHandle.type();
        MethodType methodType2 = methodHandle2.type();
        if (methodType2.parameterCount() < 1 || !methodType2.parameterType(0).isAssignableFrom(clazz)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + clazz);
        }
        if (methodType2.returnType() != methodType.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", methodType, methodType2);
        }
        List<Class<?>> list = methodType.parameterList();
        List<Class<?>> list2 = methodType2.parameterList();
        if (!list.equals(list2 = list2.subList(1, list2.size()))) {
            int n;
            int n2 = list2.size();
            if (n2 >= (n = list.size()) || !list.subList(0, n2).equals(list2)) {
                throw MethodHandles.misMatchedTypes("target and handler types", methodType, methodType2);
            }
            methodHandle2 = MethodHandles.dropArguments(methodHandle2, 1 + n2, list.subList(n2, n));
            methodType2 = methodHandle2.type();
        }
        return MethodHandleImpl.makeGuardWithCatch(methodHandle, clazz, methodHandle2);
    }

    public static MethodHandle throwException(Class<?> clazz, Class<? extends Throwable> clazz2) {
        if (!Throwable.class.isAssignableFrom(clazz2)) {
            throw new ClassCastException(clazz2.getName());
        }
        return MethodHandleImpl.throwException(MethodType.methodType(clazz, clazz2));
    }

    static {
        MethodHandleImpl.initStatics();
        ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
        IDENTITY_MHS = new MethodHandle[Wrapper.values().length];
        ZERO_MHS = new MethodHandle[Wrapper.values().length];
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;
        static ConcurrentHashMap<MemberName, DirectMethodHandle> LOOKASIDE_TABLE;

        private static int fixmods(int n) {
            return (n &= 7) != 0 ? n : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup(Class<?> clazz) {
            this(clazz, 15);
            Lookup.checkUnprivilegedlookupClass(clazz, 15);
        }

        private Lookup(Class<?> clazz, int n) {
            this.lookupClass = clazz;
            this.allowedModes = n;
        }

        public Lookup in(Class<?> clazz) {
            clazz.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(clazz, 15);
            }
            if (clazz == this.lookupClass) {
                return this;
            }
            int n = this.allowedModes & 0xB;
            if ((n & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, clazz)) {
                n &= 0xFFFFFFF5;
            }
            if ((n & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, clazz)) {
                n &= 0xFFFFFFFD;
            }
            if ((n & 1) != 0 && !VerifyAccess.isClassAccessible(clazz, this.lookupClass, this.allowedModes)) {
                n = 0;
            }
            Lookup.checkUnprivilegedlookupClass(clazz, n);
            return new Lookup(clazz, n);
        }

        private static void checkUnprivilegedlookupClass(Class<?> clazz, int n) {
            String string = clazz.getName();
            if (string.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + clazz);
            }
            if (n == 15 && clazz.getClassLoader() == null && (string.startsWith("java.") || string.startsWith("sun.") && !string.startsWith("sun.invoke.") && !string.equals("sun.reflect.ReflectionFactory"))) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + clazz);
            }
        }

        public String toString() {
            String string = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return string + "/noaccess";
                }
                case 1: {
                    return string + "/public";
                }
                case 9: {
                    return string + "/package";
                }
                case 11: {
                    return string + "/private";
                }
                case 15: {
                    return string;
                }
                case -1: {
                    return "/trusted";
                }
            }
            string = string + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : string;
            return string;
        }

        public MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail((byte)6, clazz, string, methodType);
            return this.getDirectMethod((byte)6, clazz, memberName, this.findBoundCallerClass(memberName));
        }

        public MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle methodHandle;
            if (clazz == MethodHandle.class && (methodHandle = this.findVirtualForMH(string, methodType)) != null) {
                return methodHandle;
            }
            byte by = clazz.isInterface() ? (byte)9 : 5;
            MemberName memberName = this.resolveOrFail(by, clazz, string, methodType);
            return this.getDirectMethod(by, clazz, memberName, this.findBoundCallerClass(memberName));
        }

        private MethodHandle findVirtualForMH(String string, MethodType methodType) {
            if ("invoke".equals(string)) {
                return MethodHandles.invoker(methodType);
            }
            if ("invokeExact".equals(string)) {
                return MethodHandles.exactInvoker(methodType);
            }
            assert (!MemberName.isMethodHandleInvokeName(string));
            return null;
        }

        public MethodHandle findConstructor(Class<?> clazz, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            if (clazz.isArray()) {
                throw new NoSuchMethodException("no constructor for array class: " + clazz.getName());
            }
            String string = "<init>";
            MemberName memberName = this.resolveOrFail((byte)8, clazz, string, methodType);
            return this.getDirectConstructor(clazz, memberName);
        }

        public MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(clazz2);
            Lookup lookup = this.in(clazz2);
            MemberName memberName = lookup.resolveOrFail((byte)7, clazz, string, methodType);
            return lookup.getDirectMethod((byte)7, clazz, memberName, this.findBoundCallerClass(memberName));
        }

        public MethodHandle findGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail((byte)1, clazz, string, clazz2);
            return this.getDirectField((byte)1, clazz, memberName);
        }

        public MethodHandle findSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail((byte)3, clazz, string, clazz2);
            return this.getDirectField((byte)3, clazz, memberName);
        }

        public MethodHandle findStaticGetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail((byte)2, clazz, string, clazz2);
            return this.getDirectField((byte)2, clazz, memberName);
        }

        public MethodHandle findStaticSetter(Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            MemberName memberName = this.resolveOrFail((byte)4, clazz, string, clazz2);
            return this.getDirectField((byte)4, clazz, memberName);
        }

        public MethodHandle bind(Object object, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            Class<?> clazz = object.getClass();
            MemberName memberName = this.resolveOrFail((byte)7, clazz, string, methodType);
            MethodHandle methodHandle = this.getDirectMethodNoRestrict((byte)7, clazz, memberName, this.findBoundCallerClass(memberName));
            return methodHandle.bindArgumentL(0, object).setVarargs(memberName);
        }

        public MethodHandle unreflect(Method method) throws IllegalAccessException {
            Object object;
            if (method.getDeclaringClass() == MethodHandle.class && (object = this.unreflectForMH(method)) != null) {
                return object;
            }
            object = new MemberName(method);
            byte by = ((MemberName)object).getReferenceKind();
            if (by == 7) {
                by = 5;
            }
            assert (((MemberName)object).isMethod());
            Lookup lookup = method.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectMethodNoSecurityManager(by, ((MemberName)object).getDeclaringClass(), (MemberName)object, this.findBoundCallerClass((MemberName)object));
        }

        private MethodHandle unreflectForMH(Method method) {
            if (MemberName.isMethodHandleInvokeName(method.getName())) {
                return MethodHandleImpl.fakeMethodHandleInvoke(new MemberName(method));
            }
            return null;
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> clazz) throws IllegalAccessException {
            this.checkSpecialCaller(clazz);
            Lookup lookup = this.in(clazz);
            MemberName memberName = new MemberName(method, true);
            assert (memberName.isMethod());
            return lookup.getDirectMethodNoSecurityManager((byte)7, memberName.getDeclaringClass(), memberName, this.findBoundCallerClass(memberName));
        }

        public MethodHandle unreflectConstructor(Constructor<?> constructor) throws IllegalAccessException {
            MemberName memberName = new MemberName(constructor);
            assert (memberName.isConstructor());
            Lookup lookup = constructor.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectConstructorNoSecurityManager(memberName.getDeclaringClass(), memberName);
        }

        public MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
            return this.unreflectField(field, false);
        }

        private MethodHandle unreflectField(Field field, boolean bl) throws IllegalAccessException {
            MemberName memberName = new MemberName(field, bl);
            assert (!bl ? MethodHandleNatives.refKindIsGetter(memberName.getReferenceKind()) : MethodHandleNatives.refKindIsSetter(memberName.getReferenceKind()));
            Lookup lookup = field.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectFieldNoSecurityManager(memberName.getReferenceKind(), field.getDeclaringClass(), memberName);
        }

        public MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
            return this.unreflectField(field, true);
        }

        public MethodHandleInfo revealDirect(MethodHandle methodHandle) {
            MemberName memberName = methodHandle.internalMemberName();
            if (memberName == null || !memberName.isResolved() && !memberName.isMethodHandleInvoke()) {
                throw MethodHandleStatics.newIllegalArgumentException("not a direct method handle");
            }
            Class<?> clazz = memberName.getDeclaringClass();
            byte by = memberName.getReferenceKind();
            assert (MethodHandleNatives.refKindIsValid(by));
            if (by == 7 && !methodHandle.isInvokeSpecial()) {
                by = 5;
            }
            if (by == 5 && clazz.isInterface()) {
                by = 9;
            }
            try {
                this.checkAccess(by, clazz, memberName);
                this.checkSecurityManager(clazz, memberName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException);
            }
            if (this.allowedModes != -1 && memberName.isCallerSensitive()) {
                Class<?> clazz2 = methodHandle.internalCallerClass();
                if (!this.hasPrivateAccess() || clazz2 != this.lookupClass()) {
                    throw new IllegalArgumentException("method handle is caller sensitive: " + clazz2);
                }
            }
            return new InfoFromMemberName(this, memberName, by);
        }

        MemberName resolveOrFail(byte by, Class<?> clazz, String string, Class<?> clazz2) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(clazz);
            string.getClass();
            clazz2.getClass();
            return IMPL_NAMES.resolveOrFail(by, new MemberName(clazz, string, clazz2, by), this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(byte by, Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(clazz);
            string.getClass();
            methodType.getClass();
            this.checkMethodName(by, string);
            return IMPL_NAMES.resolveOrFail(by, new MemberName(clazz, string, methodType, by), this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        MemberName resolveOrFail(byte by, MemberName memberName) throws ReflectiveOperationException {
            this.checkSymbolicClass(memberName.getDeclaringClass());
            memberName.getName().getClass();
            memberName.getType().getClass();
            return IMPL_NAMES.resolveOrFail(by, memberName, this.lookupClassOrNull(), ReflectiveOperationException.class);
        }

        void checkSymbolicClass(Class<?> clazz) throws IllegalAccessException {
            clazz.getClass();
            Class<?> clazz2 = this.lookupClassOrNull();
            if (clazz2 != null && !VerifyAccess.isClassAccessible(clazz, clazz2, this.allowedModes)) {
                throw new MemberName(clazz).makeAccessException("symbolic reference class is not public", this);
            }
        }

        void checkMethodName(byte by, String string) throws NoSuchMethodException {
            if (string.startsWith("<") && by != 8) {
                throw new NoSuchMethodException("illegal method name: " + string);
            }
        }

        Class<?> findBoundCallerClass(MemberName memberName) throws IllegalAccessException {
            Class<?> clazz = null;
            if (MethodHandleNatives.isCallerSensitive(memberName)) {
                if (this.hasPrivateAccess()) {
                    clazz = this.lookupClass;
                } else {
                    throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
                }
            }
            return clazz;
        }

        private boolean hasPrivateAccess() {
            return (this.allowedModes & 2) != 0;
        }

        void checkSecurityManager(Class<?> clazz, MemberName memberName) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            boolean bl = this.hasPrivateAccess();
            if (!bl || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, clazz)) {
                ReflectUtil.checkPackageAccess(clazz);
            }
            if (memberName.isPublic()) {
                return;
            }
            if (!bl) {
                securityManager.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            Class<?> clazz2 = memberName.getDeclaringClass();
            if (!bl && clazz2 != clazz) {
                ReflectUtil.checkPackageAccess(clazz2);
            }
        }

        void checkMethod(byte by, Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            String string;
            boolean bl;
            boolean bl2 = bl = by == 6;
            if (memberName.isConstructor()) {
                string = "expected a method, not a constructor";
            } else if (!memberName.isMethod()) {
                string = "expected a method";
            } else if (bl != memberName.isStatic()) {
                string = bl ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(by, clazz, memberName);
                return;
            }
            throw memberName.makeAccessException(string, this);
        }

        void checkField(byte by, Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            boolean bl;
            boolean bl2 = bl = !MethodHandleNatives.refKindHasReceiver(by);
            if (bl == memberName.isStatic()) {
                this.checkAccess(by, clazz, memberName);
                return;
            }
            String string = bl ? "expected a static field" : "expected a non-static field";
            throw memberName.makeAccessException(string, this);
        }

        void checkAccess(byte by, Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            assert (memberName.referenceKindIsConsistentWith(by) && MethodHandleNatives.refKindIsValid(by) && MethodHandleNatives.refKindIsField(by) == memberName.isField());
            int n = this.allowedModes;
            if (n == -1) {
                return;
            }
            int n2 = memberName.getModifiers();
            if (Modifier.isProtected(n2) && by == 5 && memberName.getDeclaringClass() == Object.class && memberName.getName().equals("clone") && clazz.isArray()) {
                n2 ^= 5;
            }
            if (Modifier.isProtected(n2) && by == 8) {
                n2 ^= 4;
            }
            if (Modifier.isFinal(n2) && MethodHandleNatives.refKindIsSetter(by)) {
                throw memberName.makeAccessException("unexpected set of a final field", this);
            }
            if (Modifier.isPublic(n2) && Modifier.isPublic(clazz.getModifiers()) && n != 0) {
                return;
            }
            int n3 = Lookup.fixmods(n2);
            if ((n3 & n) != 0 ? VerifyAccess.isMemberAccessible(clazz, memberName.getDeclaringClass(), n2, this.lookupClass(), n) : (n3 & 4) != 0 && (n & 8) != 0 && VerifyAccess.isSamePackage(memberName.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw memberName.makeAccessException(this.accessFailedMessage(clazz, memberName), this);
        }

        String accessFailedMessage(Class<?> clazz, MemberName memberName) {
            boolean bl;
            Class<?> clazz2 = memberName.getDeclaringClass();
            int n = memberName.getModifiers();
            boolean bl2 = bl = Modifier.isPublic(clazz2.getModifiers()) && (clazz2 == clazz || Modifier.isPublic(clazz.getModifiers()));
            if (!bl && (this.allowedModes & 8) != 0) {
                boolean bl3 = bl = VerifyAccess.isClassAccessible(clazz2, this.lookupClass(), 15) && (clazz2 == clazz || VerifyAccess.isClassAccessible(clazz, this.lookupClass(), 15));
            }
            if (!bl) {
                return "class is not public";
            }
            if (Modifier.isPublic(n)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(n)) {
                return "member is private";
            }
            if (Modifier.isProtected(n)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> clazz) throws IllegalAccessException {
            int n = this.allowedModes;
            if (n == -1) {
                return;
            }
            if (!this.hasPrivateAccess() || clazz != this.lookupClass()) {
                throw new MemberName(clazz).makeAccessException("no private access for invokespecial", this);
            }
        }

        private boolean restrictProtectedReceiver(MemberName memberName) {
            return memberName.isProtected() && !memberName.isStatic() && this.allowedModes != -1 && memberName.getDeclaringClass() != this.lookupClass() && !VerifyAccess.isSamePackage(memberName.getDeclaringClass(), this.lookupClass());
            {
            }
        }

        private MethodHandle restrictReceiver(MemberName memberName, DirectMethodHandle directMethodHandle, Class<?> clazz) throws IllegalAccessException {
            assert (!memberName.isStatic());
            if (!memberName.getDeclaringClass().isAssignableFrom(clazz)) {
                throw memberName.makeAccessException("caller class must be a subclass below the method", clazz);
            }
            MethodType methodType = directMethodHandle.type();
            if (methodType.parameterType(0) == clazz) {
                return directMethodHandle;
            }
            MethodType methodType2 = methodType.changeParameterType(0, clazz);
            assert (!directMethodHandle.isVarargsCollector());
            assert (directMethodHandle.viewAsTypeChecks(methodType2, true));
            return directMethodHandle.copyWith(methodType2, directMethodHandle.form);
        }

        private MethodHandle getDirectMethod(byte by, Class<?> clazz, MemberName memberName, Class<?> clazz2) throws IllegalAccessException {
            return this.getDirectMethodCommon(by, clazz, memberName, true, true, clazz2);
        }

        private MethodHandle getDirectMethodNoRestrict(byte by, Class<?> clazz, MemberName memberName, Class<?> clazz2) throws IllegalAccessException {
            return this.getDirectMethodCommon(by, clazz, memberName, true, false, clazz2);
        }

        private MethodHandle getDirectMethodNoSecurityManager(byte by, Class<?> clazz, MemberName memberName, Class<?> clazz2) throws IllegalAccessException {
            return this.getDirectMethodCommon(by, clazz, memberName, false, true, clazz2);
        }

        private MethodHandle getDirectMethodCommon(byte by, Class<?> clazz, MemberName object, boolean bl, boolean bl2, Class<?> clazz2) throws IllegalAccessException {
            Object object2;
            Class clazz3;
            this.checkMethod(by, clazz, (MemberName)object);
            if (bl) {
                this.checkSecurityManager(clazz, (MemberName)object);
            }
            assert (!((MemberName)object).isMethodHandleInvoke());
            if (by == 7 && clazz != this.lookupClass() && !clazz.isInterface() && clazz != this.lookupClass().getSuperclass() && clazz.isAssignableFrom(this.lookupClass())) {
                assert (!((MemberName)object).getName().equals("<init>"));
                clazz3 = this.lookupClass();
                do {
                    clazz3 = clazz3.getSuperclass();
                    object2 = new MemberName(clazz3, ((MemberName)object).getName(), ((MemberName)object).getMethodType(), 7);
                } while ((object2 = IMPL_NAMES.resolveOrNull(by, (MemberName)object2, this.lookupClassOrNull())) == null && clazz != clazz3);
                if (object2 == null) {
                    throw new InternalError(((MemberName)object).toString());
                }
                object = object2;
                clazz = clazz3;
                this.checkMethod(by, clazz, (MemberName)object);
            }
            clazz3 = DirectMethodHandle.make(by, clazz, (MemberName)object);
            object2 = clazz3;
            if (bl2 && (by == 7 || MethodHandleNatives.refKindHasReceiver(by) && this.restrictProtectedReceiver((MemberName)object))) {
                object2 = this.restrictReceiver((MemberName)object, (DirectMethodHandle)((Object)clazz3), this.lookupClass());
            }
            object2 = this.maybeBindCaller((MemberName)object, (MethodHandle)object2, clazz2);
            object2 = ((MethodHandle)object2).setVarargs((MemberName)object);
            return object2;
        }

        private MethodHandle maybeBindCaller(MemberName memberName, MethodHandle methodHandle, Class<?> clazz) throws IllegalAccessException {
            if (this.allowedModes == -1 || !MethodHandleNatives.isCallerSensitive(memberName)) {
                return methodHandle;
            }
            Class<?> clazz2 = this.lookupClass;
            if (!this.hasPrivateAccess()) {
                clazz2 = clazz;
            }
            MethodHandle methodHandle2 = MethodHandleImpl.bindCaller(methodHandle, clazz2);
            return methodHandle2;
        }

        private MethodHandle getDirectField(byte by, Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            return this.getDirectFieldCommon(by, clazz, memberName, true);
        }

        private MethodHandle getDirectFieldNoSecurityManager(byte by, Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            return this.getDirectFieldCommon(by, clazz, memberName, false);
        }

        private MethodHandle getDirectFieldCommon(byte by, Class<?> clazz, MemberName memberName, boolean bl) throws IllegalAccessException {
            boolean bl2;
            this.checkField(by, clazz, memberName);
            if (bl) {
                this.checkSecurityManager(clazz, memberName);
            }
            DirectMethodHandle directMethodHandle = DirectMethodHandle.make(clazz, memberName);
            boolean bl3 = bl2 = MethodHandleNatives.refKindHasReceiver(by) && this.restrictProtectedReceiver(memberName);
            if (bl2) {
                return this.restrictReceiver(memberName, directMethodHandle, this.lookupClass());
            }
            return directMethodHandle;
        }

        private MethodHandle getDirectConstructor(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            return this.getDirectConstructorCommon(clazz, memberName, true);
        }

        private MethodHandle getDirectConstructorNoSecurityManager(Class<?> clazz, MemberName memberName) throws IllegalAccessException {
            return this.getDirectConstructorCommon(clazz, memberName, false);
        }

        private MethodHandle getDirectConstructorCommon(Class<?> clazz, MemberName memberName, boolean bl) throws IllegalAccessException {
            assert (memberName.isConstructor());
            this.checkAccess((byte)8, clazz, memberName);
            if (bl) {
                this.checkSecurityManager(clazz, memberName);
            }
            assert (!MethodHandleNatives.isCallerSensitive(memberName));
            return DirectMethodHandle.make(memberName).setVarargs(memberName);
        }

        MethodHandle linkMethodHandleConstant(byte by, Class<?> clazz, String string, Object object) throws ReflectiveOperationException {
            if (!(object instanceof Class) && !(object instanceof MethodType)) {
                throw new InternalError("unresolved MemberName");
            }
            MemberName memberName = new MemberName(by, clazz, string, object);
            MethodHandle methodHandle = LOOKASIDE_TABLE.get(memberName);
            if (methodHandle != null) {
                this.checkSymbolicClass(clazz);
                return methodHandle;
            }
            if (clazz == MethodHandle.class && by == 5 && (methodHandle = this.findVirtualForMH(memberName.getName(), memberName.getMethodType())) != null) {
                return methodHandle;
            }
            MemberName memberName2 = this.resolveOrFail(by, memberName);
            methodHandle = this.getDirectMethodForConstant(by, clazz, memberName2);
            if (methodHandle instanceof DirectMethodHandle && this.canBeCached(by, clazz, memberName2)) {
                MemberName memberName3 = methodHandle.internalMemberName();
                if (memberName3 != null) {
                    memberName3 = memberName3.asNormalOriginal();
                }
                if (memberName.equals(memberName3)) {
                    LOOKASIDE_TABLE.put(memberName3, (DirectMethodHandle)methodHandle);
                }
            }
            return methodHandle;
        }

        private boolean canBeCached(byte by, Class<?> clazz, MemberName memberName) {
            Object object;
            if (by == 7) {
                return false;
            }
            if (!Modifier.isPublic(clazz.getModifiers()) || !Modifier.isPublic(memberName.getDeclaringClass().getModifiers()) || !memberName.isPublic() || memberName.isCallerSensitive()) {
                return false;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            if (!VM.isSystemDomainLoader(classLoader)) {
                boolean bl = false;
                for (object = ClassLoader.getSystemClassLoader(); object != null; object = ((ClassLoader)object).getParent()) {
                    if (classLoader != object) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            try {
                object = MethodHandles.publicLookup().resolveOrFail(by, new MemberName(by, clazz, memberName.getName(), memberName.getType()));
                this.checkSecurityManager(clazz, (MemberName)object);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                return false;
            }
            return true;
        }

        private MethodHandle getDirectMethodForConstant(byte by, Class<?> clazz, MemberName memberName) throws ReflectiveOperationException {
            if (MethodHandleNatives.refKindIsField(by)) {
                return this.getDirectFieldNoSecurityManager(by, clazz, memberName);
            }
            if (MethodHandleNatives.refKindIsMethod(by)) {
                return this.getDirectMethodNoSecurityManager(by, clazz, memberName, this.lookupClass);
            }
            if (by == 8) {
                return this.getDirectConstructorNoSecurityManager(clazz, memberName);
            }
            throw MethodHandleStatics.newIllegalArgumentException("bad MethodHandle constant #" + memberName);
        }

        static {
            IMPL_NAMES.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
            LOOKASIDE_TABLE = new ConcurrentHashMap();
        }
    }
}

