/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;
    private static final String regexMetaChars = ".^$+{[]|()";
    private static final String globMetaChars = "\\*?[{";
    private static char EOL = '\u0000';

    ZipUtils() {
    }

    public static void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
    }

    public static void writeInt(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        outputStream.write((int)(l >>> 32 & 0xFFL));
        outputStream.write((int)(l >>> 40 & 0xFFL));
        outputStream.write((int)(l >>> 48 & 0xFFL));
        outputStream.write((int)(l >>> 56 & 0xFFL));
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray, 0, byArray.length);
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(byArray, n, n2);
    }

    public static byte[] toDirectoryPath(byte[] byArray) {
        if (byArray.length != 0 && byArray[byArray.length - 1] != 47) {
            byArray = Arrays.copyOf(byArray, byArray.length + 1);
            byArray[byArray.length - 1] = 47;
        }
        return byArray;
    }

    public static long dosToJavaTime(long l) {
        Date date = new Date((int)((l >> 25 & 0x7FL) + 80L), (int)((l >> 21 & 0xFL) - 1L), (int)(l >> 16 & 0x1FL), (int)(l >> 11 & 0x1FL), (int)(l >> 5 & 0x3FL), (int)(l << 1 & 0x3EL));
        return date.getTime();
    }

    public static long javaToDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return 0x210000L;
        }
        return n - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    public static final long winToJavaTime(long l) {
        return TimeUnit.MILLISECONDS.convert(l / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    public static final long javaToWinTime(long l) {
        return (TimeUnit.MICROSECONDS.convert(l, TimeUnit.MILLISECONDS) - -11644473600000000L) * 10L;
    }

    public static final long unixToJavaTime(long l) {
        return TimeUnit.MILLISECONDS.convert(l, TimeUnit.SECONDS);
    }

    public static final long javaToUnixTime(long l) {
        return TimeUnit.SECONDS.convert(l, TimeUnit.MILLISECONDS);
    }

    private static boolean isRegexMeta(char c) {
        return regexMetaChars.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return globMetaChars.indexOf(c) != -1;
    }

    private static char next(String string, int n) {
        if (n < string.length()) {
            return string.charAt(n);
        }
        return EOL;
    }

    public static String toRegexPattern(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("^");
        int n = 0;
        block10: while (n < string.length()) {
            char c = string.charAt(n++);
            switch (c) {
                case '\\': {
                    char c2;
                    if (n == string.length()) {
                        throw new PatternSyntaxException("No character to escape", string, n - 1);
                    }
                    if (ZipUtils.isGlobMeta(c2 = string.charAt(n++)) || ZipUtils.isRegexMeta(c2)) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                case '/': {
                    stringBuilder.append(c);
                    continue block10;
                }
                case '[': {
                    stringBuilder.append("[[^/]&&[");
                    if (ZipUtils.next(string, n) == '^') {
                        stringBuilder.append("\\^");
                        ++n;
                    } else {
                        if (ZipUtils.next(string, n) == '!') {
                            stringBuilder.append('^');
                            ++n;
                        }
                        if (ZipUtils.next(string, n) == '-') {
                            stringBuilder.append('-');
                            ++n;
                        }
                    }
                    boolean bl2 = false;
                    char c3 = '\u0000';
                    while (n < string.length() && (c = string.charAt(n++)) != ']') {
                        if (c == '/') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", string, n - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && ZipUtils.next(string, n) == '&') {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                        if (c == '-') {
                            if (!bl2) {
                                throw new PatternSyntaxException("Invalid range", string, n - 1);
                            }
                            if ((c = ZipUtils.next(string, n++)) == EOL || c == ']') break;
                            if (c < c3) {
                                throw new PatternSyntaxException("Invalid range", string, n - 3);
                            }
                            stringBuilder.append(c);
                            bl2 = false;
                            continue;
                        }
                        bl2 = true;
                        c3 = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", string, n - 1);
                    }
                    stringBuilder.append("]]");
                    continue block10;
                }
                case '{': {
                    if (bl) {
                        throw new PatternSyntaxException("Cannot nest groups", string, n - 1);
                    }
                    stringBuilder.append("(?:(?:");
                    bl = true;
                    continue block10;
                }
                case '}': {
                    if (bl) {
                        stringBuilder.append("))");
                        bl = false;
                        continue block10;
                    }
                    stringBuilder.append('}');
                    continue block10;
                }
                case ',': {
                    if (bl) {
                        stringBuilder.append(")|(?:");
                        continue block10;
                    }
                    stringBuilder.append(',');
                    continue block10;
                }
                case '*': {
                    if (ZipUtils.next(string, n) == '*') {
                        stringBuilder.append(".*");
                        ++n;
                        continue block10;
                    }
                    stringBuilder.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    stringBuilder.append("[^/]");
                    continue block10;
                }
            }
            if (ZipUtils.isRegexMeta(c)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        if (bl) {
            throw new PatternSyntaxException("Missing '}", string, n - 1);
        }
        return stringBuilder.append('$').toString();
    }
}

