/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.OctoConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.HealthCheckListener;
import org.jitsi.jicofo.bridge.ParticipantProperties;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.LongGaugeMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.event.AsyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.json.simple.JSONObject;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u000256B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011J\u001c\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\t2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010$H\u0007J\u0010\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\tJ\u0010\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010#\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020\tH\u0016J\u000e\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011J\u000e\u0010+\u001a\u00020 2\u0006\u0010#\u001a\u00020\tJ6\u0010,\u001a\u0004\u0018\u00010\n2\u0014\b\u0002\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020/0.2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u000103H\u0007J\u0006\u00104\u001a\u00020 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00067"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelector;", "Lorg/jitsi/jicofo/bridge/HealthCheckListener;", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "bridgeSelectionStrategy", "Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "bridges", "", "Lorg/jxmpp/jid/Jid;", "Lorg/jitsi/jicofo/bridge/Bridge;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "eventEmitter", "Lorg/jitsi/utils/event/AsyncEventEmitter;", "Lorg/jitsi/jicofo/bridge/BridgeSelector$EventHandler;", "eventEmitterExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "logger", "Lorg/jitsi/utils/logging2/Logger;", "operationalBridgeCount", "", "getOperationalBridgeCount", "()I", "stats", "Lorg/json/simple/JSONObject;", "getStats", "()Lorg/json/simple/JSONObject;", "addHandler", "", "eventHandler", "addJvbAddress", "bridgeJid", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "get", "jid", "healthCheckFailed", "healthCheckPassed", "healthCheckTimedOut", "removeHandler", "removeJvbAddress", "selectBridge", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "version", "", "updateMetrics", "Companion", "EventHandler", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nBridgeSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeSelector.kt\norg/jitsi/jicofo/bridge/BridgeSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1774#2,4:293\n766#2:298\n857#2,2:299\n766#2:301\n857#2,2:302\n766#2:304\n857#2,2:305\n766#2:307\n857#2,2:308\n766#2:310\n857#2,2:311\n1855#2,2:313\n1774#2,4:315\n1774#2,4:319\n1549#2:323\n1620#2,3:324\n1#3:297\n*S KotlinDebug\n*F\n+ 1 BridgeSelector.kt\norg/jitsi/jicofo/bridge/BridgeSelector\n*L\n71#1:293,4\n180#1:298\n180#1:299,2\n186#1:301\n186#1:302,2\n193#1:304\n193#1:305,2\n201#1:307\n201#1:308,2\n207#1:310\n207#1:311,2\n240#1:313,2\n245#1:315,4\n246#1:319,4\n247#1:323\n247#1:324,3\n*E\n"})
public final class BridgeSelector
implements HealthCheckListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    private final ExecutorService eventEmitterExecutor;
    @NotNull
    private final AsyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final BridgeSelectionStrategy bridgeSelectionStrategy;
    @NotNull
    private final Map<Jid, Bridge> bridges;
    @JvmField
    @NotNull
    public static final CounterMetric lostBridges = MetricsContainer.registerCounter$default(JicofoMetricsContainer.Companion.getInstance(), "bridge_selector_lost_bridges", "Number of bridges which disconnected unexpectedly.", 0L, 4, null);
    @JvmField
    @NotNull
    public static final LongGaugeMetric bridgeCount = MetricsContainer.registerLongGauge$default(JicofoMetricsContainer.Companion.getInstance(), "bridge_selector_bridge_count", "The current number of bridges", 0L, 4, null);
    @NotNull
    private static final LongGaugeMetric operationalBridgeCountMetric = MetricsContainer.registerLongGauge$default(JicofoMetricsContainer.Companion.getInstance(), "bridge_selector_bridge_count_operational", "The current number of operational bridges", 0L, 4, null);
    @NotNull
    private static final LongGaugeMetric inShutdownBridgeCountMetric = MetricsContainer.registerLongGauge$default(JicofoMetricsContainer.Companion.getInstance(), "bridge_selector_bridge_count_in_shutdown", "The current number of bridges in graceful shutdown", 0L, 4, null);
    @NotNull
    private static final LongGaugeMetric bridgeVersionCount = MetricsContainer.registerLongGauge$default(JicofoMetricsContainer.Companion.getInstance(), "bridge_selector_bridge_version_count", "The current number of different bridge versions", 0L, 4, null);

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BridgeSelector(@NotNull Clock clock) {
        void it;
        BridgeSelectionStrategy bridgeSelectionStrategy;
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        ExecutorService executorService = this.eventEmitterExecutor = Executors.newSingleThreadExecutor(new CustomizableThreadFactory("BridgeSelector-AsyncEventEmitter", false));
        Intrinsics.checkNotNullExpressionValue(executorService, "eventEmitterExecutor");
        this.eventEmitter = new AsyncEventEmitter(executorService);
        BridgeSelectionStrategy bridgeSelectionStrategy2 = bridgeSelectionStrategy = BridgeConfig.config.getSelectionStrategy();
        BridgeSelector bridgeSelector = this;
        boolean bl = false;
        this.logger.info("Using " + it.getClass().getName());
        bridgeSelector.bridgeSelectionStrategy = bridgeSelectionStrategy;
        this.bridges = new ConcurrentHashMap();
        JicofoMetricsContainer.Companion.getInstance().getMetricsUpdater().addUpdateTask(new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.updateMetrics();
            }
        });
    }

    public /* synthetic */ BridgeSelector(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC(...)");
            clock = clock2;
        }
        this(clock);
    }

    public final void addHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventEmitter.addHandler(eventHandler);
    }

    public final void removeHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventEmitter.removeHandler(eventHandler);
    }

    @Nullable
    public final Bridge get(@NotNull Jid jid) {
        Intrinsics.checkNotNullParameter(jid, "jid");
        return this.bridges.get(jid);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int getOperationalBridgeCount() {
        int n;
        Iterable $this$count$iv = this.bridges.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(it.isOperational() && !it.isInGracefulShutdown()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @JvmOverloads
    @NotNull
    public final synchronized Bridge addJvbAddress(@NotNull Jid bridgeJid, @Nullable ColibriStatsExtension stats) {
        Bridge bridge2;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge3 = this.bridges.get(bridgeJid);
        if (bridge3 != null) {
            Bridge it = bridge3;
            boolean bl = false;
            boolean wasShutingDown = it.isShuttingDown();
            it.setStats(stats);
            if (!wasShutingDown && it.isShuttingDown()) {
                this.logger.info(it.getJid() + " entered SHUTTING_DOWN");
                this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                    final /* synthetic */ Bridge $it;
                    {
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull EventHandler $this$fireEvent) {
                        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                        $this$fireEvent.bridgeIsShuttingDown(this.$it);
                    }
                });
            }
            return it;
        }
        Bridge newBridge = bridge2 = new Bridge(bridgeJid, this.clock);
        boolean bl = false;
        if (stats != null) {
            newBridge.setStats(stats);
        }
        this.logger.info("Added new videobridge: " + newBridge);
        this.bridges.put(bridgeJid, newBridge);
        bridgeCount.inc();
        this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(newBridge){
            final /* synthetic */ Bridge $newBridge;
            {
                this.$newBridge = $newBridge;
                super(1);
            }

            public final void invoke(@NotNull EventHandler $this$fireEvent) {
                Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                $this$fireEvent.bridgeAdded(this.$newBridge);
            }
        });
        return bridge2;
    }

    public static /* synthetic */ Bridge addJvbAddress$default(BridgeSelector bridgeSelector, Jid jid, ColibriStatsExtension colibriStatsExtension, int n, Object object) {
        if ((n & 2) != 0) {
            colibriStatsExtension = null;
        }
        return bridgeSelector.addJvbAddress(jid, colibriStatsExtension);
    }

    public final synchronized void removeJvbAddress(@NotNull Jid bridgeJid) {
        block1: {
            Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
            this.logger.info("Removing JVB: " + bridgeJid);
            Bridge bridge2 = this.bridges.remove(bridgeJid);
            if (bridge2 == null) break block1;
            Bridge it = bridge2;
            boolean bl = false;
            if (!it.isInGracefulShutdown() && !it.isShuttingDown()) {
                this.logger.warn("Lost a bridge: " + bridgeJid);
                lostBridges.inc();
            }
            bridgeCount.dec();
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                final /* synthetic */ Bridge $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeRemoved(this.$it);
                }
            });
        }
    }

    @Override
    public void healthCheckPassed(@NotNull Jid bridgeJid) {
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            bridge2.setOperational(true);
        }
    }

    @Override
    public void healthCheckFailed(@NotNull Jid bridgeJid) {
        Unit unit;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            Bridge it = bridge2;
            boolean bl = false;
            it.setOperational(false);
            this.eventEmitter.fireEvent(new Function1<EventHandler, Unit>(it){
                final /* synthetic */ Bridge $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeRemoved(this.$it);
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    @Override
    public void healthCheckTimedOut(@NotNull Jid bridgeJid) {
        Unit unit;
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        Bridge bridge2 = this.bridges.get(bridgeJid);
        if (bridge2 != null) {
            Bridge it = bridge2;
            boolean bl = false;
            it.setOperational(false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public final synchronized Bridge selectBridge(@NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String version) {
        Bridge bridge2;
        block17: {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Bridge it;
            Iterable $this$filterTo$iv$iv3;
            ArrayList<Bridge> $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22;
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            String v = null;
            Bridge bridge3 = (Bridge)CollectionsKt.firstOrNull((Iterable)conferenceBridges.keySet());
            String string = v = bridge3 != null ? bridge3.getFullVersion() : null;
            if (v == null) {
                v = version;
            } else if (version != null && !Intrinsics.areEqual(version, v)) {
                this.logger.warn("An inconsistent version was requested: " + version + ". Conference is using version: " + v);
                return null;
            }
            BridgeSelector bridgeSelector = this;
            synchronized (bridgeSelector) {
                boolean $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22 = false;
                $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22 = new ArrayList<Bridge>(this.bridges.values());
            }
            ArrayList<Bridge> prioritizedBridges = $i$a$-synchronized-BridgeSelector$selectBridge$prioritizedBridges$22;
            CollectionsKt.sort((List)prioritizedBridges);
            Iterable $this$filter$iv = prioritizedBridges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!it.isOperational()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Bridge> candidateBridges = CollectionsKt.toList((List)destination$iv$iv);
            if (candidateBridges.isEmpty()) {
                this.logger.warn("There are no operational bridges.");
                return null;
            }
            $this$filter$iv = candidateBridges;
            $i$f$filter = false;
            $this$filterTo$iv$iv3 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it.isShuttingDown())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidateBridges = CollectionsKt.toList((List)destination$iv$iv);
            if (candidateBridges.isEmpty()) {
                this.logger.warn("All operational bridges are SHUTTING_DOWN");
                return null;
            }
            if (v != null && !OctoConfig.config.getAllowMixedVersions()) {
                $this$filter$iv = candidateBridges;
                $i$f$filter = false;
                $this$filterTo$iv$iv3 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    it = (Bridge)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getFullVersion(), v)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidateBridges = (List<Bridge>)destination$iv$iv;
                if (candidateBridges.isEmpty()) {
                    this.logger.warn("There are no bridges with the required version: " + v);
                    return null;
                }
            }
            Iterable $this$filter$iv2 = candidateBridges;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Bridge it2 = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it2.isDraining())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List<Bridge> activeBridges = CollectionsKt.toList((List)destination$iv$iv2);
            if (!activeBridges.isEmpty()) {
                candidateBridges = activeBridges;
            }
            Iterable $this$filter$iv3 = candidateBridges;
            boolean $i$f$filter3 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Bridge it3 = (Bridge)element$iv$iv;
                boolean bl = false;
                if (!(!it3.isInGracefulShutdown())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List runningBridges = CollectionsKt.toList((List)destination$iv$iv3);
            if (!runningBridges.isEmpty()) {
                candidateBridges = runningBridges;
            }
            Bridge it4 = bridge2 = this.bridgeSelectionStrategy.select(candidateBridges, conferenceBridges, participantProperties, OctoConfig.config.getEnabled());
            boolean bl = false;
            Bridge bridge4 = it4;
            if (bridge4 == null) break block17;
            bridge4.endpointAdded();
        }
        return bridge2;
    }

    public static /* synthetic */ Bridge selectBridge$default(BridgeSelector bridgeSelector, Map map, ParticipantProperties participantProperties, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            participantProperties = new ParticipantProperties(null, false, 3, null);
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return bridgeSelector.selectBridge(map, participantProperties, string);
    }

    @NotNull
    public final synchronized JSONObject getStats() {
        JSONObject jSONObject;
        JSONObject $this$_get_stats__u24lambda_u2414 = jSONObject = this.bridgeSelectionStrategy.getStats();
        boolean bl = false;
        ((Map)$this$_get_stats__u24lambda_u2414).put("bridge_count", bridgeCount.get());
        ((Map)$this$_get_stats__u24lambda_u2414).put("operational_bridge_count", operationalBridgeCountMetric.get());
        ((Map)$this$_get_stats__u24lambda_u2414).put("in_shutdown_bridge_count", inShutdownBridgeCountMetric.get());
        ((Map)$this$_get_stats__u24lambda_u2414).put("lost_bridges", lostBridges.get());
        ((Map)$this$_get_stats__u24lambda_u2414).put("bridge_version_count", bridgeVersionCount.get());
        return jSONObject;
    }

    @NotNull
    public final synchronized OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u2417 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Map map = $this$_get_debugState__u24lambda_u2417;
        String string = "strategy";
        String string2 = this.bridgeSelectionStrategy.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        Object object = string2;
        map.put(string, object);
        map = $this$_get_debugState__u24lambda_u2417;
        string = "bridge";
        Object $this$_get_debugState__u24lambda_u2417_u24lambda_u2416 = object = new OrderedJsonObject();
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.bridges.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bridge it = (Bridge)element$iv;
            boolean bl3 = false;
            ((OrderedJsonObject)$this$_get_debugState__u24lambda_u2417_u24lambda_u2416).put(((Object)it.getJid()).toString(), it.getDebugState());
        }
        map.put(string, object);
        return orderedJsonObject;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateMetrics() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n;
        Bridge it;
        int count$iv;
        int n2;
        Iterable $this$count$iv;
        Iterable iterable = this.bridges.values();
        LongGaugeMetric longGaugeMetric = inShutdownBridgeCountMetric;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Bridge)element$iv;
                boolean bl = false;
                if (!it.isInGracefulShutdown() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int n3 = n2;
        longGaugeMetric.set(n3);
        $this$count$iv = this.bridges.values();
        longGaugeMetric = operationalBridgeCountMetric;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Bridge)element$iv;
                boolean bl = false;
                if (!it.isOperational() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n3 = n;
        longGaugeMetric.set(n3);
        $this$count$iv = this.bridges.values();
        longGaugeMetric = bridgeVersionCount;
        boolean $i$f$map = false;
        void count$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Bridge bridge2 = (Bridge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getFullVersion());
        }
        longGaugeMetric.set(CollectionsKt.toSet((List)destination$iv$iv).size());
    }

    @JvmOverloads
    public BridgeSelector() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Bridge addJvbAddress(@NotNull Jid bridgeJid) {
        Intrinsics.checkNotNullParameter(bridgeJid, "bridgeJid");
        return BridgeSelector.addJvbAddress$default(this, bridgeJid, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge(@NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
        return BridgeSelector.selectBridge$default(this, conferenceBridges, participantProperties, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge(@NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges) {
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        return BridgeSelector.selectBridge$default(this, conferenceBridges, null, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final Bridge selectBridge() {
        return BridgeSelector.selectBridge$default(this, null, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelector$Companion;", "", "()V", "bridgeCount", "Lorg/jitsi/metrics/LongGaugeMetric;", "bridgeVersionCount", "getBridgeVersionCount", "()Lorg/jitsi/metrics/LongGaugeMetric;", "inShutdownBridgeCountMetric", "getInShutdownBridgeCountMetric", "lostBridges", "Lorg/jitsi/metrics/CounterMetric;", "operationalBridgeCountMetric", "getOperationalBridgeCountMetric", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongGaugeMetric getOperationalBridgeCountMetric() {
            return operationalBridgeCountMetric;
        }

        @NotNull
        public final LongGaugeMetric getInShutdownBridgeCountMetric() {
            return inShutdownBridgeCountMetric;
        }

        @NotNull
        public final LongGaugeMetric getBridgeVersionCount() {
            return bridgeVersionCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelector$EventHandler;", "", "bridgeAdded", "", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridgeIsShuttingDown", "bridgeRemoved", "jicofo-selector"})
    public static interface EventHandler {
        public void bridgeRemoved(@NotNull Bridge var1);

        public void bridgeAdded(@NotNull Bridge var1);

        public void bridgeIsShuttingDown(@NotNull Bridge var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void bridgeIsShuttingDown(@NotNull EventHandler $this, @NotNull Bridge bridge2) {
                Intrinsics.checkNotNullParameter(bridge2, "bridge");
            }
        }
    }
}

