/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import java.util.Locale;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class PhysicalNamingStrategySnakeCaseImpl
implements PhysicalNamingStrategy {
    @Override
    public Identifier toPhysicalCatalogName(Identifier logicalName, JdbcEnvironment jdbcEnvironment) {
        return this.apply(logicalName);
    }

    @Override
    public Identifier toPhysicalSchemaName(Identifier logicalName, JdbcEnvironment jdbcEnvironment) {
        return this.apply(logicalName);
    }

    @Override
    public Identifier toPhysicalTableName(Identifier logicalName, JdbcEnvironment jdbcEnvironment) {
        return this.apply(logicalName);
    }

    @Override
    public Identifier toPhysicalSequenceName(Identifier logicalName, JdbcEnvironment jdbcEnvironment) {
        return this.apply(logicalName);
    }

    @Override
    public Identifier toPhysicalColumnName(Identifier logicalName, JdbcEnvironment jdbcEnvironment) {
        return this.apply(logicalName);
    }

    private Identifier apply(Identifier name) {
        if (name == null) {
            return null;
        }
        if (name.isQuoted()) {
            return this.quotedIdentifier(name);
        }
        return this.unquotedIdentifier(name);
    }

    private String camelCaseToSnakeCase(String name) {
        StringBuilder builder = new StringBuilder(name.replace('.', '_'));
        for (int i = 1; i < builder.length() - 1; ++i) {
            if (!this.isUnderscoreRequired(builder.charAt(i - 1), builder.charAt(i), builder.charAt(i + 1))) continue;
            builder.insert(i++, '_');
        }
        return builder.toString();
    }

    protected Identifier unquotedIdentifier(Identifier name) {
        return new Identifier(this.camelCaseToSnakeCase(name.getText()).toLowerCase(Locale.ROOT));
    }

    protected Identifier quotedIdentifier(Identifier quotedName) {
        return quotedName;
    }

    private boolean isUnderscoreRequired(char before, char current, char after) {
        return !(!Character.isLowerCase(before) && !Character.isDigit(before) || !Character.isUpperCase(current) || !Character.isLowerCase(after) && !Character.isDigit(after));
    }
}

