/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.H2JsonValueFunction;
import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class H2JsonExistsFunction
extends JsonExistsFunction {
    public H2JsonExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, true);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String jsonPath;
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonExistsErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on H2");
        }
        try {
            jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
        }
        catch (Exception ex) {
            throw new QueryException("H2 json_value only support literal json paths, but got " + String.valueOf(arguments.jsonPath()));
        }
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(" is not null and ");
        H2JsonValueFunction.renderJsonPath(sqlAppender, arguments.jsonDocument(), arguments.isJsonType(), walker, jsonPath, arguments.passingClause());
        sqlAppender.appendSql(" is not null");
    }
}

