/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public final class GraalVM {
    private static final Logger log = Logger.getLogger(GraalVM.class);

    public static enum Distribution {
        GRAALVM,
        LIBERICA,
        MANDREL;

    }

    public static class Version
    implements Comparable<Version> {
        public static final Version VERSION_23_0_0 = new Version("GraalVM 23.0.0", "23.0.0", "17", Distribution.GRAALVM);
        public static final Version VERSION_23_1_0 = new Version("GraalVM 23.1.0", "23.1.0", "21", Distribution.GRAALVM);
        public static final Version VERSION_24_2_0 = new Version("GraalVM 24.2.0", "24.2.0", "24", Distribution.GRAALVM);
        public static final Version VERSION_25_0_0 = new Version("GraalVM 25.0.0", "25.0.0", "25", Distribution.GRAALVM);
        protected static final Map<String, String> GRAAL_MAPPING = Map.of("21", "23.1", "22", "24.0", "23", "24.1", "24", "24.2");
        private static final Map<String, String> MANDREL_JDK_REV_MAP;
        public static final Version MINIMUM;
        public static final Version CURRENT;
        public static final Version MINIMUM_SUPPORTED;
        private static final String DEFAULT_JDK_VERSION = "21";
        protected final String fullVersion;
        public final Runtime.Version javaVersion;
        protected final Distribution distribution;
        private int[] versions;
        private String suffix;

        Version(String fullVersion, String version, Distribution distro) {
            this(fullVersion, version, distro == Distribution.MANDREL || distro == Distribution.LIBERICA ? Version.communityJDKvers(version) : DEFAULT_JDK_VERSION, distro);
        }

        Version(String fullVersion, String version, String javaVersion, Distribution distro) {
            this(fullVersion, version, Runtime.Version.parse(javaVersion), distro);
        }

        protected Version(String fullVersion, String version, Runtime.Version javaVersion, Distribution distro) {
            this.fullVersion = fullVersion;
            this.breakdownVersion(version);
            this.javaVersion = javaVersion;
            this.distribution = distro;
        }

        private void breakdownVersion(String version) {
            int dash = version.indexOf(45);
            if (dash != -1) {
                this.suffix = version.substring(dash + 1);
                version = version.substring(0, dash);
            }
            this.versions = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }

        private static String communityJDKvers(String communityVersion) {
            try {
                String[] parts = communityVersion.split("\\.", 4);
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                if (major == 23 && minor > 0 || major > 23) {
                    String mandrelMajorMinor = String.format("%s.%s", parts[0], parts[1]);
                    String feature = MANDREL_JDK_REV_MAP.getOrDefault(mandrelMajorMinor, parts[0]);
                    if ("0".equals(parts[2])) {
                        return feature;
                    }
                    return String.format("%s.%s.%s", feature, "0", parts[2]);
                }
            }
            catch (Throwable e) {
                log.warnf("Failed to parse JDK version from GraalVM version: %s. Defaulting to currently supported version %s ", (Object)communityVersion, (Object)DEFAULT_JDK_VERSION);
            }
            return DEFAULT_JDK_VERSION;
        }

        @Override
        public int compareTo(Version o) {
            return this.compareTo(o.versions);
        }

        @Override
        public int compareTo(int[] versions) {
            int i;
            for (i = 0; i < this.versions.length; ++i) {
                if (i >= versions.length) {
                    if (this.versions[i] == 0) continue;
                    return 1;
                }
                if (this.versions[i] == versions[i]) continue;
                return this.versions[i] - versions[i];
            }
            while (i < versions.length) {
                if (versions[i] != 0) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public String getVersionAsString() {
            String version = Arrays.stream(this.versions).mapToObj(Integer::toString).collect(Collectors.joining("."));
            if (this.suffix != null) {
                return version + "-" + this.suffix;
            }
            return version;
        }

        public String getMajorMinorAsString() {
            if (this.versions.length >= 2) {
                return this.versions[0] + "." + this.versions[1];
            }
            return this.versions[0] + ".0";
        }

        public String toString() {
            return "Version{version=" + this.getVersionAsString() + ", fullVersion=" + this.fullVersion + ", distribution=" + (Object)((Object)this.distribution) + ", javaVersion=" + this.javaVersion + '}';
        }

        public static Version getCurrent() {
            String vendorVersion = System.getProperty("org.graalvm.vendorversion");
            return VersionParseHelper.parse(vendorVersion);
        }

        static {
            HashMap<String, String> reverseMap = new HashMap<String, String>(GRAAL_MAPPING.size());
            for (Map.Entry<String, String> entry : GRAAL_MAPPING.entrySet()) {
                reverseMap.put(entry.getValue(), entry.getKey());
            }
            MANDREL_JDK_REV_MAP = Collections.unmodifiableMap(reverseMap);
            MINIMUM = VERSION_23_0_0;
            MINIMUM_SUPPORTED = CURRENT = VERSION_23_1_0;
        }
    }

    static final class VersionParseHelper {
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)(?:(?:-(?<PRE>[a-zA-Z0-9]+))?\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String GRAALVM_CE_VERS_PREFIX = "GraalVM CE ";
        private static final String LIBERICA_NIK_VERS_PREFIX = "Liberica-NIK-";
        private static final String MANDREL_VERS_PREFIX = "Mandrel-";
        private static final String ORACLE_GRAALVM_VERS_PREFIX = "Oracle GraalVM ";
        private static final String VENDOR_PREFIX_GROUP = "VENDORPREFIX";
        private static final String VENDOR_PREFIX = "(?<VENDORPREFIX>GraalVM CE |Liberica-NIK-|Mandrel-|Oracle GraalVM )";
        private static final Pattern VENDOR_VERS_PATTERN = Pattern.compile("(?<VENDORPREFIX>GraalVM CE |Liberica-NIK-|Mandrel-|Oracle GraalVM )(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)(?:(?:-(?<PRE>[a-zA-Z0-9]+))?\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?");
        private static final String VERSION_GROUP = "VNUM";

        VersionParseHelper() {
        }

        static Version parse(String value) {
            Matcher versionMatcher = VENDOR_VERS_PATTERN.matcher(value);
            if (versionMatcher.find()) {
                String vendor = versionMatcher.group(VENDOR_PREFIX_GROUP);
                if (GRAALVM_CE_VERS_PREFIX.equals(vendor) || ORACLE_GRAALVM_VERS_PREFIX.equals(vendor)) {
                    String jdkFeature;
                    String version = versionMatcher.group(VERSION_GROUP);
                    String[] tokens = version.split("\\.", 3);
                    String jdkVers = jdkFeature = tokens[0];
                    if (tokens.length == 3) {
                        String interim = tokens[1];
                        String update = tokens[2].split("\\+")[0];
                        jdkVers = String.format("%s.%s.%s", jdkFeature, interim, update);
                    }
                    String versionMapping = Version.GRAAL_MAPPING.getOrDefault(jdkFeature, version);
                    return new Version(value, versionMapping, jdkVers, Distribution.GRAALVM);
                }
                if (LIBERICA_NIK_VERS_PREFIX.equals(vendor)) {
                    return new Version(value, versionMatcher.group(VERSION_GROUP), Distribution.LIBERICA);
                }
                if (MANDREL_VERS_PREFIX.equals(vendor)) {
                    return new Version(value, versionMatcher.group(VERSION_GROUP), Distribution.MANDREL);
                }
            }
            log.warnf("Failed to parse GraalVM version from: %s. Defaulting to currently supported version %s ", (Object)value, (Object)Version.CURRENT);
            return Version.CURRENT;
        }
    }
}

