/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVertexInputBindingDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BINDING;
    public static final int STRIDE;
    public static final int INPUTRATE;

    public VkVertexInputBindingDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVertexInputBindingDescription.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return VkVertexInputBindingDescription.nbinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkVertexInputBindingDescription.nstride(this.address());
    }

    @NativeType(value="VkVertexInputRate")
    public int inputRate() {
        return VkVertexInputBindingDescription.ninputRate(this.address());
    }

    public VkVertexInputBindingDescription binding(@NativeType(value="uint32_t") int value) {
        VkVertexInputBindingDescription.nbinding(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription stride(@NativeType(value="uint32_t") int value) {
        VkVertexInputBindingDescription.nstride(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription inputRate(@NativeType(value="VkVertexInputRate") int value) {
        VkVertexInputBindingDescription.ninputRate(this.address(), value);
        return this;
    }

    public VkVertexInputBindingDescription set(int binding, int stride, int inputRate) {
        this.binding(binding);
        this.stride(stride);
        this.inputRate(inputRate);
        return this;
    }

    public VkVertexInputBindingDescription set(VkVertexInputBindingDescription src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVertexInputBindingDescription malloc() {
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkVertexInputBindingDescription calloc() {
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkVertexInputBindingDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkVertexInputBindingDescription create(long address) {
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)address);
    }

    @Nullable
    public static VkVertexInputBindingDescription createSafe(long address) {
        return address == 0L ? null : (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkVertexInputBindingDescription.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVertexInputBindingDescription.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkVertexInputBindingDescription mallocStack() {
        return VkVertexInputBindingDescription.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputBindingDescription callocStack() {
        return VkVertexInputBindingDescription.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputBindingDescription mallocStack(MemoryStack stack) {
        return VkVertexInputBindingDescription.malloc(stack);
    }

    @Deprecated
    public static VkVertexInputBindingDescription callocStack(MemoryStack stack) {
        return VkVertexInputBindingDescription.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkVertexInputBindingDescription.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkVertexInputBindingDescription.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkVertexInputBindingDescription.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkVertexInputBindingDescription.calloc(capacity, stack);
    }

    public static VkVertexInputBindingDescription malloc(MemoryStack stack) {
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVertexInputBindingDescription calloc(MemoryStack stack) {
        return (VkVertexInputBindingDescription)VkVertexInputBindingDescription.wrap(VkVertexInputBindingDescription.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVertexInputBindingDescription.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nstride(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRIDE);
    }

    public static int ninputRate(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTRATE);
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void nstride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRIDE, value);
    }

    public static void ninputRate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTRATE, value);
    }

    static {
        Struct.Layout layout = VkVertexInputBindingDescription.__struct((Struct.Member[])new Struct.Member[]{VkVertexInputBindingDescription.__member((int)4), VkVertexInputBindingDescription.__member((int)4), VkVertexInputBindingDescription.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BINDING = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        INPUTRATE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVertexInputBindingDescription, Buffer>
    implements NativeResource {
        private static final VkVertexInputBindingDescription ELEMENT_FACTORY = VkVertexInputBindingDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkVertexInputBindingDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return VkVertexInputBindingDescription.nbinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkVertexInputBindingDescription.nstride(this.address());
        }

        @NativeType(value="VkVertexInputRate")
        public int inputRate() {
            return VkVertexInputBindingDescription.ninputRate(this.address());
        }

        public Buffer binding(@NativeType(value="uint32_t") int value) {
            VkVertexInputBindingDescription.nbinding(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkVertexInputBindingDescription.nstride(this.address(), value);
            return this;
        }

        public Buffer inputRate(@NativeType(value="VkVertexInputRate") int value) {
            VkVertexInputBindingDescription.ninputRate(this.address(), value);
            return this;
        }
    }
}

