/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.resthandler.live_queries;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.rules.action.live_queries.LiveQueriesAction;
import org.opensearch.plugin.insights.rules.action.live_queries.LiveQueriesRequest;
import org.opensearch.plugin.insights.rules.action.live_queries.LiveQueriesResponse;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestLiveQueriesAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = MetricType.allMetricTypes().stream().map(MetricType::toString).collect(Collectors.toSet());

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_insights/live_queries"));
    }

    public String getName() {
        return "query_insights_live_queries_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        LiveQueriesRequest liveQueriesRequest = RestLiveQueriesAction.prepareRequest(request);
        return channel -> client.execute((ActionType)LiveQueriesAction.INSTANCE, (ActionRequest)liveQueriesRequest, this.liveQueriesResponse((RestChannel)channel));
    }

    static LiveQueriesRequest prepareRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        boolean verbose = request.paramAsBoolean("verbose", true);
        String sortParam = request.param("sort", MetricType.LATENCY.toString());
        if (!ALLOWED_METRICS.contains(sortParam)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains invalid sort metric type [%s]", request.path(), sortParam));
        }
        MetricType sortBy = MetricType.fromString(sortParam);
        int size = request.paramAsInt("size", 100);
        return new LiveQueriesRequest(verbose, sortBy, size, nodesIds);
    }

    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    private RestResponseListener<LiveQueriesResponse> liveQueriesResponse(RestChannel channel) {
        return new RestResponseListener<LiveQueriesResponse>(this, channel){

            public RestResponse buildResponse(LiveQueriesResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

