/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util.destinationmigration;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.util.destinationmigration.DestinationMigrationUtilService;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;", "Lorg/opensearch/cluster/ClusterStateListener;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/opensearch/common/lifecycle/LifecycleListener;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/alerting/core/ScheduledJobIndices;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "runningLock", "", "scheduledMigration", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "clusterChanged", "", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "initMigrateDestinations", "opensearch-alerting"})
public final class DestinationMigrationCoordinator
extends LifecycleListener
implements ClusterStateListener,
CoroutineScope {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    private final Logger logger;
    @Nullable
    private Scheduler.Cancellable scheduledMigration;
    private volatile boolean runningLock;

    public DestinationMigrationCoordinator(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ScheduledJobIndices scheduledJobIndices) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.scheduledJobIndices = scheduledJobIndices;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.addLifecycleListener((LifecycleListener)this);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return Dispatchers.getDefault().plus((CoroutineContext)new CoroutineName("DestinationMigrationCoordinator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        block9: {
            block7: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (DestinationMigrationUtilService.Companion.getFinishFlag()) {
                        this.logger.info("Reset destination migration process.");
                        Scheduler.Cancellable cancellable = this.scheduledMigration;
                        if (cancellable != null) {
                            cancellable.cancel();
                        }
                        DestinationMigrationUtilService.Companion.setFinishFlag$opensearch_alerting(false);
                    }
                    if (!event.localNodeClusterManager() || this.runningLock) break block7;
                    if (this.scheduledMigration == null) break block8;
                    Scheduler.Cancellable cancellable = this.scheduledMigration;
                    Intrinsics.checkNotNull((Object)cancellable);
                    if (!cancellable.isCancelled()) break block7;
                }
                try {
                    this.runningLock = true;
                    this.initMigrateDestinations();
                }
                finally {
                    this.runningLock = false;
                }
            }
            if (event.localNodeClusterManager()) break block9;
            this.logger.info("Cancelling the migration process.");
            Scheduler.Cancellable cancellable = this.scheduledMigration;
            if (cancellable != null) {
                cancellable.cancel();
            }
        }
    }

    private final void initMigrateDestinations() {
        if (!this.scheduledJobIndices.scheduledJobIndexExists()) {
            this.logger.debug("Alerting config index is not initialized");
            Scheduler.Cancellable cancellable = this.scheduledMigration;
            if (cancellable != null) {
                cancellable.cancel();
            }
            return;
        }
        if (!this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            Scheduler.Cancellable cancellable = this.scheduledMigration;
            if (cancellable != null) {
                cancellable.cancel();
            }
            return;
        }
        if (DestinationMigrationUtilService.Companion.getFinishFlag()) {
            this.logger.info("Destination migration is already complete, cancelling migration process.");
            Scheduler.Cancellable cancellable = this.scheduledMigration;
            if (cancellable != null) {
                cancellable.cancel();
            }
            return;
        }
        Runnable scheduledJob2 = () -> DestinationMigrationCoordinator.initMigrateDestinations$lambda$0(this);
        this.scheduledMigration = this.threadPool.scheduleWithFixedDelay(scheduledJob2, TimeValue.timeValueMinutes((long)1L), "management");
    }

    private static final void initMigrateDestinations$lambda$0(DestinationMigrationCoordinator this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ DestinationMigrationCoordinator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (DestinationMigrationUtilService.Companion.getFinishFlag()) {
                            DestinationMigrationCoordinator.access$getLogger$p(this.this$0).info("Cancel background destination migration process.");
                            Scheduler.Cancellable cancellable = DestinationMigrationCoordinator.access$getScheduledMigration$p(this.this$0);
                            if (cancellable != null) {
                                Boxing.boxBoolean((boolean)cancellable.cancel());
                            }
                        }
                        DestinationMigrationCoordinator.access$getLogger$p(this.this$0).info("Performing migration of destination data.");
                        Client client = DestinationMigrationCoordinator.access$getClient$p(this.this$0);
                        Intrinsics.checkNotNull((Object)client, (String)"null cannot be cast to non-null type org.opensearch.transport.client.node.NodeClient");
                        this.label = 1;
                        Object object3 = DestinationMigrationUtilService.Companion.migrateDestinations((NodeClient)client, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            DestinationMigrationCoordinator.access$getLogger$p(this.this$0).error("Failed to migrate destination data", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DestinationMigrationCoordinator $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Scheduler.Cancellable access$getScheduledMigration$p(DestinationMigrationCoordinator $this) {
        return $this.scheduledMigration;
    }

    public static final /* synthetic */ Client access$getClient$p(DestinationMigrationCoordinator $this) {
        return $this.client;
    }
}

