/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.script.AggregationScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.storage.script.core.CalciteScript;

class CalciteAggregationScript
extends AggregationScript {
    private final CalciteScript calciteScript;
    private final RelDataType type;

    public CalciteAggregationScript(Function1<DataContext, Object[]> function, RelDataType type, SearchLookup lookup, LeafReaderContext context, Map<String, Object> params) {
        super(params, lookup, context);
        this.calciteScript = new CalciteScript(function, params);
        this.type = type;
    }

    public Object execute() {
        Object value = this.calciteScript.execute(() -> ((CalciteAggregationScript)this).getDoc())[0];
        ExprType exprType = OpenSearchTypeFactory.convertRelDataTypeToExprType(this.type);
        return switch ((ExprCoreType)exprType) {
            case ExprCoreType.TIME -> ChronoUnit.MILLIS.between(LocalTime.MIN, ExprValueUtils.fromObjectValue(value, ExprCoreType.TIME).timeValue());
            case ExprCoreType.DATE -> ExprValueUtils.fromObjectValue(value, ExprCoreType.DATE).timestampValue().toEpochMilli();
            case ExprCoreType.TIMESTAMP -> ExprValueUtils.fromObjectValue(value, ExprCoreType.TIMESTAMP).timestampValue().toEpochMilli();
            default -> value;
        };
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalciteAggregationScript)) {
            return false;
        }
        CalciteAggregationScript other = (CalciteAggregationScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalciteScript this$calciteScript = this.calciteScript;
        CalciteScript other$calciteScript = other.calciteScript;
        if (this$calciteScript == null ? other$calciteScript != null : !((Object)this$calciteScript).equals(other$calciteScript)) {
            return false;
        }
        RelDataType this$type = this.type;
        RelDataType other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalciteAggregationScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalciteScript $calciteScript = this.calciteScript;
        result = result * 59 + ($calciteScript == null ? 43 : ((Object)$calciteScript).hashCode());
        RelDataType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

