/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

public class GenerateRandomBytesInput {
    private final int length;

    protected GenerateRandomBytesInput(BuilderImpl builder) {
        this.length = builder.length();
    }

    public int length() {
        return this.length;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected int length;
        private boolean _lengthSet = false;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GenerateRandomBytesInput model) {
            this.length = model.length();
            this._lengthSet = true;
        }

        @Override
        public Builder length(int length) {
            this.length = length;
            this._lengthSet = true;
            return this;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public GenerateRandomBytesInput build() {
            if (!this._lengthSet) {
                throw new IllegalArgumentException("Missing value for required field `length`");
            }
            if (this._lengthSet && this.length() < 0) {
                throw new IllegalArgumentException("`length` must be greater than or equal to 0");
            }
            return new GenerateRandomBytesInput(this);
        }
    }

    public static interface Builder {
        public Builder length(int var1);

        public int length();

        public GenerateRandomBytesInput build();
    }
}

