/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.query.AgenticSearchQueryBuilder;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class AgenticQueryTranslatorProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(AgenticQueryTranslatorProcessor.class);
    public static final String TYPE = "agentic_query_translator";
    private final MLCommonsClientAccessor mlClient;
    private final String agentId;
    private final NamedXContentRegistry xContentRegistry;
    private static final Gson gson = new Gson();

    AgenticQueryTranslatorProcessor(String tag, String description, boolean ignoreFailure, MLCommonsClientAccessor mlClient, String agentId, NamedXContentRegistry xContentRegistry) {
        super(tag, description, ignoreFailure);
        this.mlClient = mlClient;
        this.agentId = agentId;
        this.xContentRegistry = xContentRegistry;
    }

    public void processRequestAsync(SearchRequest request, PipelineProcessingContext requestContext, ActionListener<SearchRequest> requestListener) {
        SearchSourceBuilder sourceBuilder = request.source();
        if (sourceBuilder == null || sourceBuilder.query() == null) {
            requestListener.onResponse((Object)request);
            return;
        }
        QueryBuilder query = sourceBuilder.query();
        if (!(query instanceof AgenticSearchQueryBuilder)) {
            requestListener.onResponse((Object)request);
            return;
        }
        if (this.hasOtherSearchFeatures(sourceBuilder)) {
            requestListener.onFailure((Exception)new IllegalArgumentException("Agentic search cannot be used with other search features like aggregations, sort, highlighters, etc."));
            return;
        }
        AgenticSearchQueryBuilder agenticQuery = (AgenticSearchQueryBuilder)query;
        this.executeAgentAsync(agenticQuery, request, requestListener);
    }

    private boolean hasOtherSearchFeatures(SearchSourceBuilder sourceBuilder) {
        return sourceBuilder.aggregations() != null || sourceBuilder.sorts() != null && !sourceBuilder.sorts().isEmpty() || sourceBuilder.highlighter() != null || sourceBuilder.postFilter() != null || sourceBuilder.suggest() != null || sourceBuilder.rescores() != null && !sourceBuilder.rescores().isEmpty() || sourceBuilder.collapse() != null;
    }

    private void executeAgentAsync(AgenticSearchQueryBuilder agenticQuery, SearchRequest request, ActionListener<SearchRequest> requestListener) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query_text", agenticQuery.getQueryText());
        if (request.indices() != null && request.indices().length > 0) {
            try {
                Map<String, String> indexMappings = NeuralSearchClusterUtil.instance().getIndexMapping(request.indices());
                parameters.put("index_mapping", indexMappings.toString());
            }
            catch (Exception e2) {
                log.warn("Failed to get index mapping", (Throwable)e2);
            }
        }
        if (agenticQuery.getQueryFields() != null && !agenticQuery.getQueryFields().isEmpty()) {
            parameters.put("query_fields", gson.toJson(agenticQuery.getQueryFields()));
        }
        this.mlClient.executeAgent(this.agentId, parameters, (ActionListener<String>)ActionListener.wrap(agentResponse -> {
            try {
                log.info("Generated Query: [{}]", agentResponse);
                BytesArray bytes = new BytesArray(agentResponse);
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, null, (InputStream)bytes.streamInput());){
                    SearchSourceBuilder newSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
                    request.source(newSourceBuilder);
                }
                requestListener.onResponse((Object)request);
            }
            catch (IOException e) {
                log.error("Failed to parse agent response", (Throwable)e);
                requestListener.onFailure((Exception)e);
            }
        }, e -> {
            log.error("Failed to execute agent", (Throwable)e);
            requestListener.onFailure((Exception)new RuntimeException("Failed to execute agentic search", (Throwable)e));
        }));
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        throw new UnsupportedOperationException("Use processRequestAsync for agentic search processor");
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        private final MLCommonsClientAccessor mlClient;
        private final NamedXContentRegistry xContentRegistry;
        private final NeuralSearchSettingsAccessor settingsAccessor;

        public Factory(MLCommonsClientAccessor mlClient, NamedXContentRegistry xContentRegistry, NeuralSearchSettingsAccessor settingsAccessor) {
            this.mlClient = mlClient;
            this.xContentRegistry = xContentRegistry;
            this.settingsAccessor = settingsAccessor;
        }

        public AgenticQueryTranslatorProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws IllegalArgumentException, IllegalStateException {
            if (!this.settingsAccessor.isAgenticSearchEnabled()) {
                throw new IllegalStateException("Agentic search is currently disabled. Enable it using the 'plugins.neural_search.agentic_search_enabled' setting.");
            }
            String agentId = ConfigurationUtils.readStringProperty((String)AgenticQueryTranslatorProcessor.TYPE, (String)tag, config, (String)"agent_id");
            if (agentId == null || agentId.trim().isEmpty()) {
                throw new IllegalArgumentException("agent_id is required for agentic_query_translator processor");
            }
            return new AgenticQueryTranslatorProcessor(tag, description, ignoreFailure, this.mlClient, agentId, this.xContentRegistry);
        }
    }
}

