/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class NeuralQueryParser {
    public static Supplier<float[]> vectorSupplierStreamInput(@NonNull StreamInput in) throws IOException {
        Objects.requireNonNull(in, "in is marked non-null but is null");
        if (!in.readBoolean()) {
            return null;
        }
        float[] vector = in.readFloatArray();
        return () -> vector;
    }

    public static void vectorSupplierStreamOutput(@NonNull StreamOutput out, Supplier<float[]> vectorSupplier) throws IOException {
        Objects.requireNonNull(out, "out is marked non-null but is null");
        if (vectorSupplier == null || vectorSupplier.get() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeFloatArray(vectorSupplier.get());
        }
    }

    public static Map<String, Supplier<float[]>> modelIdToVectorSupplierMapStreamInput(@NonNull StreamInput in) throws IOException {
        Objects.requireNonNull(in, "in is marked non-null but is null");
        if (!in.readBoolean()) {
            return null;
        }
        HashMap<String, Supplier<float[]>> modelIdToVectorSupplierMap = new HashMap<String, Supplier<float[]>>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String modelId = in.readString();
            float[] vector = in.readFloatArray();
            Supplier<float[]> vectorSupplier = () -> vector;
            modelIdToVectorSupplierMap.put(modelId, vectorSupplier);
        }
        return modelIdToVectorSupplierMap;
    }

    public static void modelIdToVectorSupplierMapStreamOutput(@NonNull StreamOutput out, Map<String, Supplier<float[]>> modelIdToVectorSupplierMap) throws IOException {
        Objects.requireNonNull(out, "out is marked non-null but is null");
        if (modelIdToVectorSupplierMap == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        int size = modelIdToVectorSupplierMap.size();
        out.writeVInt(size);
        for (Map.Entry<String, Supplier<float[]>> entry : modelIdToVectorSupplierMap.entrySet()) {
            try {
                out.writeString(entry.getKey());
                out.writeFloatArray(entry.getValue().get());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Failed to write modelIdToVectorSupplierMap to StreamOutput for the neural query due to: %s", e.getMessage()), e);
            }
        }
    }

    public static Supplier<Map<String, Float>> queryTokensMapSupplierStreamInput(@NonNull StreamInput in) throws IOException {
        Objects.requireNonNull(in, "in is marked non-null but is null");
        if (!in.readBoolean()) {
            return null;
        }
        Map queryTokens = in.readMap(StreamInput::readString, StreamInput::readFloat);
        return () -> queryTokens;
    }

    public static void queryTokensMapSupplierStreamOutput(@NonNull StreamOutput out, Supplier<Map<String, Float>> queryTokensMapSupplier) throws IOException {
        Objects.requireNonNull(out, "out is marked non-null but is null");
        if (queryTokensMapSupplier == null || queryTokensMapSupplier.get() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(queryTokensMapSupplier.get(), StreamOutput::writeString, StreamOutput::writeFloat);
        }
    }

    public static Map<String, Supplier<Map<String, Float>>> modelIdToQueryTokensSupplierMapStreamInput(@NonNull StreamInput in) throws IOException {
        Objects.requireNonNull(in, "in is marked non-null but is null");
        if (!in.readBoolean()) {
            return null;
        }
        HashMap<String, Supplier<Map<String, Float>>> modelIdToQueryTokensSupplierMap = new HashMap<String, Supplier<Map<String, Float>>>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String modelId = in.readString();
            Map queryTokenMap = in.readMap(StreamInput::readString, StreamInput::readFloat);
            Supplier<Map> queryTokenMapSupplier = () -> queryTokenMap;
            modelIdToQueryTokensSupplierMap.put(modelId, queryTokenMapSupplier);
        }
        return modelIdToQueryTokensSupplierMap;
    }

    public static void modelIdToQueryTokensSupplierMapStreamOutput(@NonNull StreamOutput out, Map<String, Supplier<Map<String, Float>>> modelIdToQueryTokensMapSupplier) throws IOException {
        Objects.requireNonNull(out, "out is marked non-null but is null");
        if (modelIdToQueryTokensMapSupplier == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        int size = modelIdToQueryTokensMapSupplier.size();
        out.writeVInt(size);
        for (Map.Entry<String, Supplier<Map<String, Float>>> entry : modelIdToQueryTokensMapSupplier.entrySet()) {
            try {
                out.writeString(entry.getKey());
                out.writeMap(entry.getValue().get(), StreamOutput::writeString, StreamOutput::writeFloat);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Failed to write modelIdToQueryTokensSupplierMap to StreamOutput for the neural query due to: %s", e.getMessage()), e);
            }
        }
    }
}

