/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.queryset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.QuerySetEntry;
import org.opensearch.searchrelevance.transport.queryset.PostQuerySetRequest;
import org.opensearch.searchrelevance.ubi.QuerySampler;
import org.opensearch.searchrelevance.ubi.UbiValidator;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class PostQuerySetTransportAction
extends HandledTransportAction<PostQuerySetRequest, IndexResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final QuerySetDao querySetDao;

    @Inject
    public PostQuerySetTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client, QuerySetDao querySetDao) {
        super("cluster:admin/opensearch/search_relevance/queryset/create", transportService, actionFilters, PostQuerySetRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.querySetDao = querySetDao;
    }

    protected void doExecute(Task task, PostQuerySetRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        String id = UUID.randomUUID().toString();
        String timestamp = TimeUtils.getTimestamp();
        String name = request.getName();
        String description = request.getDescription();
        if (!UbiValidator.checkUbiIndicesExist(this.clusterService)) {
            throw new SearchRelevanceException("UBI is not initialized", RestStatus.CONFLICT);
        }
        String sampling = request.getSampling();
        int querySetSize = request.getQuerySetSize();
        QuerySampler querySampler = QuerySampler.create(sampling, querySetSize, this.client);
        Map<Object, Object> querySetQueries = new HashMap();
        try {
            querySetQueries = querySampler.sample().get();
        }
        catch (InterruptedException | ExecutionException e) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to build querySetQueries. Request: " + String.valueOf((Object)request), RestStatus.BAD_REQUEST)));
        }
        if (name == null || name.trim().isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Name cannot be null or empty. Request: " + String.valueOf((Object)request), RestStatus.BAD_REQUEST)));
            return;
        }
        List<QuerySetEntry> querySetEntries = querySetQueries.entrySet().stream().map(entry -> QuerySetEntry.Builder.builder().queryText((String)entry.getKey()).build()).collect(Collectors.toList());
        QuerySet querySet = new QuerySet(id, name, description, timestamp, sampling, querySetEntries);
        this.querySetDao.putQuerySet(querySet, listener);
    }
}

