/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;

public class CorrelationParamsContext
implements ToXContentFragment,
Writeable {
    public static final String VECTOR_SIMILARITY_FUNCTION = "similarityFunction";
    public static final String PARAMETERS = "parameters";
    private final VectorSimilarityFunction similarityFunction;
    private final Map<String, Object> parameters;

    public CorrelationParamsContext(VectorSimilarityFunction similarityFunction, Map<String, Object> parameters) {
        this.similarityFunction = similarityFunction;
        this.parameters = parameters;
    }

    public CorrelationParamsContext(StreamInput sin) throws IOException {
        this.similarityFunction = VectorSimilarityFunction.valueOf((String)sin.readString());
        this.parameters = sin.available() > 0 ? sin.readMap() : null;
    }

    public static CorrelationParamsContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse CorrelationParamsContext");
        }
        Map contextMap = (Map)in;
        VectorSimilarityFunction similarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry contextEntry : contextMap.entrySet()) {
            String key = (String)contextEntry.getKey();
            Object value = contextEntry.getValue();
            if (VECTOR_SIMILARITY_FUNCTION.equals(key)) {
                if (value != null && !(value instanceof String)) {
                    throw new MapperParsingException(String.format(Locale.getDefault(), "%s must be a string", VECTOR_SIMILARITY_FUNCTION));
                }
                try {
                    similarityFunction = VectorSimilarityFunction.valueOf((String)((String)value));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new MapperParsingException(String.format(Locale.getDefault(), "Invalid %s: %s", VECTOR_SIMILARITY_FUNCTION, value));
                }
            }
            if (PARAMETERS.equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for Correlation context");
                }
                Map valueMap = (Map)value;
                assert (parameters != null);
                parameters.putAll(valueMap);
                continue;
            }
            throw new MapperParsingException(String.format(Locale.getDefault(), "Invalid parameter for : %s", key));
        }
        return new CorrelationParamsContext(similarityFunction, parameters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VECTOR_SIMILARITY_FUNCTION, this.similarityFunction.name());
        if (params == null) {
            builder.field(PARAMETERS, (String)null);
        } else {
            builder.startObject(PARAMETERS);
            for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
                builder.field(parameter.getKey(), parameter.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationParamsContext that = (CorrelationParamsContext)o;
        return this.similarityFunction == that.similarityFunction && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.similarityFunction, this.parameters);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.similarityFunction.name());
        if (this.parameters != null) {
            out.writeMap(this.parameters);
        }
    }

    public VectorSimilarityFunction getSimilarityFunction() {
        return this.similarityFunction;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

