/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.frames;

import com.projectlibre.ui.ribbon.CustomRibbonBandGenerator;
import com.projectlibre.ui.ribbon.ProjectLibreRibbonUI;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.contrib.ClassLoaderUtils;
import com.projectlibre1.dialog.AboutDialog;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.dialog.BaselineDialog;
import com.projectlibre1.dialog.FindDialog;
import com.projectlibre1.dialog.HelpDialog;
import com.projectlibre1.dialog.LocaleDialog;
import com.projectlibre1.dialog.OpenProjectDialog;
import com.projectlibre1.dialog.ProjectDialog;
import com.projectlibre1.dialog.ProjectInformationDialog;
import com.projectlibre1.dialog.RenameProjectDialog;
import com.projectlibre1.dialog.ResourceInformationDialog;
import com.projectlibre1.dialog.ResourceMappingDialog;
import com.projectlibre1.dialog.TaskInformationDialog;
import com.projectlibre1.dialog.TipOfTheDay;
import com.projectlibre1.dialog.WelcomeDialog;
import com.projectlibre1.dialog.assignment.AssignmentDialog;
import com.projectlibre1.dialog.options.CalendarDialogBox;
import com.projectlibre1.document.Document;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.exchange.ResourceMappingForm;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.SpreadSheetFieldArray;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.VoidNodeImpl;
import com.projectlibre1.grouping.core.transform.ViewTransformer;
import com.projectlibre1.grouping.core.transform.filtering.NodeFilter;
import com.projectlibre1.grouping.core.transform.filtering.ResourceInTeamFilter;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobQueue;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.job.Mutex;
import com.projectlibre1.menu.MenuActionConstants;
import com.projectlibre1.menu.MenuActionsMap;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.pm.graphic.TabbedNavigation;
import com.projectlibre1.pm.graphic.frames.DocumentFrame;
import com.projectlibre1.pm.graphic.frames.DocumentSelectedEvent;
import com.projectlibre1.pm.graphic.frames.StartupFactory;
import com.projectlibre1.pm.graphic.frames.workspace.DefaultFrameManager;
import com.projectlibre1.pm.graphic.frames.workspace.FrameHolder;
import com.projectlibre1.pm.graphic.frames.workspace.FrameManager;
import com.projectlibre1.pm.graphic.frames.workspace.NamedFrame;
import com.projectlibre1.pm.graphic.frames.workspace.NamedFrameEvent;
import com.projectlibre1.pm.graphic.frames.workspace.NamedFrameListener;
import com.projectlibre1.pm.graphic.laf.LafManager;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.graphic.views.ProjectsDialog;
import com.projectlibre1.pm.graphic.views.Searchable;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.ProjectFactory;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.preference.ConfigurationFile;
import com.projectlibre1.preference.GlobalPreferences;
import com.projectlibre1.print.GraphPageable;
import com.projectlibre1.print.PrintDocumentFactory;
import com.projectlibre1.server.data.DocumentData;
import com.projectlibre1.session.CreateOptions;
import com.projectlibre1.session.LoadOptions;
import com.projectlibre1.session.SaveOptions;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.toolbar.FilterToolBarManager;
import com.projectlibre1.toolbar.TransformComboBox;
import com.projectlibre1.undo.CommandInfo;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.BrowserControl;
import com.projectlibre1.util.ClassUtils;
import com.projectlibre1.util.Environment;
import com.projectlibre1.workspace.SavableToWorkspace;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.commons.collections.Closure;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class GraphicManager
implements FrameHolder,
NamedFrameListener,
WindowStateListener,
SelectionNodeListener,
ObjectEvent.Listener,
ActionMap,
MenuActionConstants,
SavableToWorkspace {
    private static final boolean BINARY_WORKSPACE = true;
    private static GraphicManager lastGraphicManager = null;
    private DocumentFrame currentFrame = null;
    private List frameList = new ArrayList();
    private HashMap<Project, NamedFrame> frameMap = new HashMap();
    private NamedFrame viewBarFrame;
    private FrameManager frameManager;
    private MenuManager menuManager;
    MenuActionsMap actionsMap = null;
    private static String server = null;
    private AssignmentDialog assignResourcesDialog = null;
    private FindDialog findDialog = null;
    private ProjectInformationDialog projectInformationDialog = null;
    private TaskInformationDialog taskInformationDialog = null;
    private ResourceInformationDialog resourceInformationDialog = null;
    private AboutDialog aboutDialog = null;
    private HelpDialog helpDialog = null;
    private BaselineDialog baselineDialog = null;
    private ResourceMappingDialog resourceMappingDialog = null;
    ProjectFactory projectFactory = null;
    protected Container container;
    protected Frame frame;
    TabbedNavigation topTabs = null;
    private static Object lastWorkspace = null;
    static LinkedList graphicManagers = new LinkedList();
    private static LafManager lafManager;
    public static boolean badLAF;
    private StartupFactory startupFactory = null;
    protected JobQueue jobQueue = null;
    protected GlobalPreferences preferences = null;
    private FilterToolBarManager filterToolBarManager;
    private JMenu projectListMenu = null;
    private ArrayList<CommandInfo> history = new ArrayList();
    private String fileName = "../projectlibre_exchange/testdata/New Product.mpp";
    private ViewAction resourceAction;
    protected static int project_suffix_count;
    boolean doingOpenDialog = false;
    protected boolean resourceType = false;
    protected boolean taskType = false;
    protected Node lastNode = null;
    private HashMap colorThemes = null;
    private ResourceInTeamFilter assignmentDialogTransformerInitializationClosure;
    boolean initialized = false;
    private Mutex initializing = new Mutex();
    protected String lastFileName;

    public static GraphicManager getInstance(Component component) {
        Component component2 = component;
        for (component2 = component; component2 != null; component2 = component2.getParent()) {
            if (component2 instanceof FrameHolder) {
                return ((FrameHolder)((Object)component2)).getGraphicManager();
            }
            if (component2.getName() == null || !component2.getName().endsWith("BootstrapApplet") || !component2.getClass().getName().endsWith("BootstrapApplet")) continue;
            System.out.println("applet: " + component2.getClass().getName());
            try {
                FrameHolder frameHolder = (FrameHolder)Class.forName("com.projectlibre1.bootstrap.BootstrapApplet.class").getMethod("getObject", null).invoke((Object)component2, null);
                return frameHolder.getGraphicManager();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return lastGraphicManager;
    }

    public static GraphicManager getInstance() {
        return lastGraphicManager;
    }

    public static Frame getFrameInstance() {
        return lastGraphicManager.getFrame();
    }

    public static DocumentFrame getDocumentFrameInstance() {
        return lastGraphicManager == null ? null : lastGraphicManager.getCurrentFrame();
    }

    void setMeAsLastGraphicManager() {
        lastGraphicManager = this;
        if (this.jobQueue != null) {
            SessionFactory.getInstance().setJobQueue(this.getJobQueue());
        }
    }

    public static LinkedList getGraphicManagers() {
        return graphicManagers;
    }

    public GraphicManager(String string, Container container) throws HeadlessException {
        graphicManagers.add(this);
        lastGraphicManager = this;
        container.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GraphicManager.this.setMeAsLastGraphicManager();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.projectFactory = ProjectFactory.getInstance();
        this.projectFactory.getPortfolio().addObjectListener(this);
        server = string;
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
        if (container instanceof FrameHolder) {
            ((FrameHolder)((Object)container)).setGraphicManager(this);
        } else {
            try {
                FrameHolder frameHolder = (FrameHolder)Class.forName("com.projectlibre1.bootstrap.BootstrapApplet").getMethod("getObject", null).invoke((Object)container, null);
                frameHolder.setGraphicManager(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.registerForMacOSXEvents();
    }

    public GraphicManager(Container container) {
        this(server, container);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void cleanUp() {
        this.projectFactory.getPortfolio().removeObjectListener(this);
        ((DefaultFrameManager)this.frameManager).cleanUp();
        graphicManagers.remove(this);
        if (graphicManagers.isEmpty()) {
            this.getLafManager().clean();
        }
        if (this.jobQueue != null) {
            this.jobQueue.cancel();
        }
        this.jobQueue = null;
    }

    public LafManager getLafManager() {
        if (lafManager == null) {
            try {
                String string = Messages.getMetaString("LafManager");
                lafManager = (LafManager)Class.forName(string).getConstructor(GraphicManager.class).newInstance(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return lafManager;
    }

    private static String getTabIdForProject(Project project) {
        if (project == null) {
            return null;
        }
        return "" + project.getUniqueId();
    }

    void setTabNameAndTitle(DocumentFrame documentFrame, Project project) {
        documentFrame.setTabNameAndTitle(project);
    }

    public void switchToProject(long l) {
        Project project = ProjectFactory.getInstance().findFromId(l);
        if (project == null) {
            return;
        }
        DocumentFrame documentFrame = (DocumentFrame)this.frameMap.get(project);
        if (documentFrame == null) {
            return;
        }
        this.setCurrentFrame(documentFrame);
    }

    protected void setCurrentFrame(DocumentFrame documentFrame) {
        if (documentFrame instanceof DocumentFrame) {
            if (this.currentFrame != null && this.projectListMenu != null && !Environment.isPlugin()) {
                this.currentFrame.getMenuItem().setSelected(false);
            }
            if (this.currentFrame != null && !Environment.isPlugin()) {
                this.currentFrame.refreshViewButtons(false);
            }
            this.currentFrame = documentFrame;
            if (this.projectListMenu != null && !Environment.isPlugin()) {
                this.currentFrame.getMenuItem().setSelected(true);
            }
            if (this.topTabs != null && !Environment.isPlugin()) {
                this.topTabs.setCurrentFrame(this.currentFrame);
            }
            DocumentSelectedEvent.fire(this, this.currentFrame);
            if (this.projectInformationDialog != null) {
                this.projectInformationDialog.documentSelected(new DocumentSelectedEvent(this, this.currentFrame));
            }
            if (this.taskInformationDialog != null) {
                this.taskInformationDialog.documentSelected(new DocumentSelectedEvent(this, this.currentFrame));
            }
            if (this.resourceInformationDialog != null) {
                this.resourceInformationDialog.documentSelected(new DocumentSelectedEvent(this, this.currentFrame));
            }
            this.setTitle(false);
            if (this.currentFrame != null) {
                this.currentFrame.refreshViewButtons(true);
            }
            this.getFrameManager().activateFrame(this.currentFrame);
            if (!Environment.isPlugin()) {
                this.setEnabledDocumentMenuActions(this.currentFrame != null);
                this.setButtonState(null, this.currentFrame.getProject());
            }
            if (this.currentFrame != null && this.currentFrame.getProject() != null) {
                CalendarOption calendarOption;
                if (!Environment.isPlugin()) {
                    this.currentFrame.getFilterToolBarManager().transformBasedOnValue();
                }
                if ((calendarOption = this.currentFrame.getProject().getCalendarOption()) != null) {
                    CalendarOption.setInstance(calendarOption);
                }
            } else {
                CalendarOption.setInstance(CalendarOption.getDefaultInstance());
            }
        }
    }

    void setTitle(boolean bl) {
        DocumentFrame documentFrame = this.getCurrentFrame();
        Object object = Messages.getContextString("Text.ApplicationTitle");
        if (documentFrame != null && documentFrame.getProject() != null) {
            object = Environment.getStandAlone() ? documentFrame.getProject().getTitle() : (String)object + " - " + documentFrame.getProject().getName();
            if (!bl && documentFrame.getProject().needsSaving()) {
                object = (String)object + " *";
            }
        }
        Frame frame = this.getFrame();
        if (this.frame != null) {
            this.frame.setTitle((String)object);
        }
    }

    public DocumentFrame addProjectFrame(Project project) {
        String string = GraphicManager.getTabIdForProject(project);
        if (project == null) {
            return null;
        }
        final DocumentFrame documentFrame = new DocumentFrame(this, project, string);
        if (documentFrame == null) {
            return null;
        }
        this.getFrameManager().addFrame(documentFrame);
        this.setTabNameAndTitle(documentFrame, project);
        documentFrame.setShowTitleBar(false);
        this.getFrameManager().showFrame(documentFrame);
        documentFrame.addNamedFrameListener(this);
        project.addProjectListener(documentFrame);
        if (this.projectListMenu != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SelectDocumentAction(documentFrame));
            jRadioButtonMenuItem.setSelected(true);
            documentFrame.setMenuItem(jRadioButtonMenuItem);
            this.projectListMenu.add(jRadioButtonMenuItem);
        }
        this.setCurrentFrame(documentFrame);
        this.frameList.add(documentFrame);
        this.frameMap.put(project, documentFrame);
        if (!Environment.isPlugin()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    documentFrame.getFilterToolBarManager().clear();
                }
            });
        }
        this.getMenuManager().setActionEnabled("OpenProject", documentFrame == null || !documentFrame.isEditingResourcePool());
        return documentFrame;
    }

    private void closeProjectFrame(Project project) {
        String string = GraphicManager.getTabIdForProject(project);
        DocumentFrame documentFrame = (DocumentFrame)this.frameMap.get(project);
        if (documentFrame != null) {
            if (this.currentFrame == documentFrame) {
                documentFrame.setVisible(false);
                JRadioButtonMenuItem jRadioButtonMenuItem = documentFrame.getMenuItem();
                if (jRadioButtonMenuItem != null && this.projectListMenu != null) {
                    this.projectListMenu.remove(jRadioButtonMenuItem);
                }
                if (this.frameList.size() <= 1) {
                    documentFrame.refreshViewButtons(false);
                    this.currentFrame = null;
                    this.setTitle(false);
                    this.setEnabledDocumentMenuActions(false);
                } else {
                    DocumentFrame documentFrame2;
                    int n = 0;
                    Iterator iterator = this.frameList.iterator();
                    while (iterator.hasNext() && !string.equals(GraphicManager.getTabIdForProject((documentFrame2 = (DocumentFrame)iterator.next()).getProject()))) {
                        ++n;
                    }
                    this.setCurrentFrame((DocumentFrame)this.frameList.get(n == 0 ? 1 : n - 1));
                }
            }
            project.removeProjectListener(documentFrame);
            documentFrame.removeNamedFrameListener(this);
            this.getFrameManager().removeFrame(documentFrame);
            documentFrame.onClose();
            this.frameList.remove(documentFrame);
            this.frameMap.remove(project);
        }
        this.setAllButResourceDisabled(false);
        this.getMenuManager().setActionEnabled("OpenProject", true);
    }

    public String doRenameProjectDialog(String string, Set set, boolean bl) {
        this.finishAnyOperations();
        RenameProjectDialog renameProjectDialog = RenameProjectDialog.getInstance(this.getFrame(), null);
        renameProjectDialog.getForm().setName(string);
        renameProjectDialog.getForm().setProjectNames(set);
        renameProjectDialog.getForm().setSaveAs(bl);
        if (renameProjectDialog.doModal()) {
            return renameProjectDialog.getForm().getName();
        }
        return null;
    }

    public void doWelcomeDialog() {
        String string = ConfigurationFile.getProperty("preLoadProject");
        if (string != null) {
            this.loadLocalDocument(string, false);
            return;
        }
        WelcomeDialog welcomeDialog = WelcomeDialog.getInstance(this.getFrame(), this.getMenuManager());
        if (welcomeDialog.doModal()) {
            this.waitInitialization();
            if (welcomeDialog.getForm().isCreateProject()) {
                this.doNewProjectDialog();
            } else if (welcomeDialog.getForm().isOpenProject()) {
                if (Environment.getStandAlone()) {
                    this.openLocalProject();
                } else {
                    this.doOpenProjectDialog();
                }
            } else if (welcomeDialog.getForm().isManageResources()) {
                this.loadMasterProject();
            }
        }
    }

    public boolean doNewProjectDialog() {
        ProjectDialog.Form form = this.doNewProjectDialog1();
        if (form == null) {
            return false;
        }
        return this.doNewProjectDialog2(form);
    }

    public boolean doNewProjectNoDialog(HashMap hashMap) {
        Closure closure;
        ProjectDialog.Form form = this.doNewProjectNoDialog1();
        if (form == null) {
            return false;
        }
        if (hashMap != null && (closure = (Closure)hashMap.get("updateViewClosure")) != null) {
            closure.execute(form);
        }
        return this.doNewProjectDialog2(form);
    }

    public ProjectDialog.Form doNewProjectDialog1() {
        this.addHistory("doNewProjectDialog");
        this.finishAnyOperations();
        ProjectDialog projectDialog = ProjectDialog.getInstance(this.getFrame(), null);
        projectDialog.getForm().setManager(Environment.getUser().getName());
        if (!projectDialog.doModal()) {
            return null;
        }
        return projectDialog.getForm();
    }

    public ProjectDialog.Form doNewProjectNoDialog1() {
        System.out.println("doNewProjectNoDialog1 begin");
        this.addHistory("doNewProjectNoDialog");
        this.finishAnyOperations();
        ProjectDialog.Form form = new ProjectDialog.Form();
        form.setName("Project" + project_suffix_count++);
        System.out.println("doNewProjectNoDialog1 end");
        return form;
    }

    public boolean doNewProjectDialog2(ProjectDialog.Form form) {
        this.showWaitCursor(true);
        ResourcePool resourcePool = form.getResourcePool();
        boolean bl = form.isLocal();
        if (resourcePool != null) {
            resourcePool.setLocal(bl);
        }
        CreateOptions createOptions = new CreateOptions();
        createOptions.setResourcePool(form.getResourcePool());
        createOptions.setLocal(bl);
        createOptions.setName(form.getName());
        createOptions.setAddResources(!bl);
        Project project = this.projectFactory.createProject(createOptions);
        try {
            project.setManager(form.getManager());
            project.setName(form.getName());
            project.setNotes(form.getNotes());
            project.setForward(form.isForward());
            project.setGroup(form.getGroup());
            project.setDivision(form.getDivision());
            project.setProjectType(form.getProjectType());
            project.setProjectStatus(form.getProjectStatus());
            project.setExpenseType(form.getExpenseType());
            if (!form.isLocal()) {
                project.setAccessControlPolicy(form.getAccessControlType());
                project.resetRoles(form.getAccessControlType() == 0);
            }
            if (form.isLocal()) {
                project.setLocal(true);
            } else {
                project.setTemporaryLocal(true);
            }
            if (form.isForward()) {
                project.setStartDate(form.getStartDate());
            } else {
                project.setFinishDate(form.getStartDate());
            }
            project.getExtraFields().putAll(form.getExtra().getExtraFields());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showWaitCursor(false);
        return true;
    }

    private void doOpenProjectDialog() {
        if (this.doingOpenDialog) {
            return;
        }
        this.doingOpenDialog = true;
        this.finishAnyOperations();
        final ArrayList arrayList = new ArrayList();
        Session session = SessionFactory.getInstance().getSession(false);
        Job job = (Job)SessionFactory.callNoEx(session, "getLoadProjectDescriptorsJob", new Class[]{Boolean.TYPE, List.class, Boolean.TYPE}, new Object[]{true, arrayList, !Environment.isAdministrator()});
        job.addSwingRunnable(new JobRunnable(this, "Local: loadDocument"){
            final /* synthetic */ GraphicManager this$0;
            {
                this.this$0 = graphicManager;
                super(string);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Closure closure = new Closure(this){

                    @Override
                    public void execute(Object object) {
                    }
                };
                Closure closure2 = new Closure(){

                    @Override
                    public void execute(Object object) {
                        Object[] objectArray = (Object[])object;
                        if (objectArray != null) {
                            DocumentData documentData = (DocumentData)objectArray[0];
                            boolean bl = (Boolean)objectArray[1];
                            this$0.loadDocument(documentData.getUniqueId(), false, bl);
                        }
                    }
                };
                try {
                    boolean bl = this.this$0.getCurrentFrame() == null && Environment.isAdministrator();
                    OpenProjectDialog.getInstance(this.this$0.getFrame(), arrayList, Messages.getString("Text.openProject"), bl, true, null).execute(closure, closure2);
                }
                finally {
                    this.this$0.doingOpenDialog = false;
                }
                return null;
            }
        });
        session.schedule(job);
    }

    private void doInsertProjectDialog() {
        if (this.doingOpenDialog) {
            return;
        }
        this.doingOpenDialog = true;
        this.finishAnyOperations();
        final Project project = this.getCurrentFrame().getProject();
        final ArrayList arrayList = new ArrayList();
        Session session = SessionFactory.getInstance().getSession(false);
        Job job = (Job)SessionFactory.callNoEx(session, "getLoadProjectDescriptorsJob", new Class[]{Boolean.TYPE, List.class, Boolean.TYPE}, new Object[]{true, arrayList, true});
        job.addSwingRunnable(new JobRunnable(this, "Local: add"){
            final /* synthetic */ GraphicManager this$0;
            {
                this.this$0 = graphicManager;
                super(string);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Closure closure = new Closure(this){

                    @Override
                    public void execute(Object object) {
                    }
                };
                Closure closure2 = new Closure(){

                    @Override
                    public void execute(Object object) {
                        Object[] objectArray = (Object[])object;
                        if (objectArray != null) {
                            DocumentData documentData = (DocumentData)objectArray[0];
                            if (documentData.isMaster()) {
                                return;
                            }
                            this$0.insertSubproject(project, documentData.getUniqueId(), true);
                        }
                    }
                };
                try {
                    OpenProjectDialog openProjectDialog = OpenProjectDialog.getInstance(this.this$0.getFrame(), arrayList, Messages.getString("Text.insertProject"), false, false, project);
                    openProjectDialog.execute(closure, closure2);
                }
                catch (Exception exception) {
                    Alert.error(Messages.getString("Message.serverUnreachable"), this.this$0.getContainer());
                    exception.printStackTrace();
                }
                finally {
                    this.this$0.doingOpenDialog = false;
                }
                return null;
            }
        });
        session.schedule(job);
    }

    public void insertSubproject(Project project, long l, boolean bl) {
        DataFactoryUndoController dataFactoryUndoController;
        this.addHistory("insertSubproject", new Object[]{project.getName(), project.getUniqueId(), l});
        Project project2 = ProjectFactory.getInstance().findFromId(l);
        if (!project.getSubprojectHandler().canInsertProject(l)) {
            Alert.error(Messages.getString("GraphicManager.SelectedProjectAlreadySubproject"));
            return;
        }
        if (project2 != null && project2.isOpenedAsSubproject()) {
            Alert.error(Messages.getString("GraphicManager.SelectedProjectAlreadyOpenedAsSubproject"));
            return;
        }
        SubProj subProj = project.getSubprojectHandler().createSubProj(l);
        Node node = this.getCurrentFrame().addNodeForImpl(subProj, 1);
        ProjectFactory.getInstance().openSubproject(project, node, true);
        if (bl && (dataFactoryUndoController = project.getUndoController()).getEditSupport() != null) {
            dataFactoryUndoController.clear();
        }
    }

    private void doProjectInformationDialog() {
        if (!this.getCurrentFrame().isActive()) {
            return;
        }
        this.finishAnyOperations();
        if (this.projectInformationDialog == null) {
            this.projectInformationDialog = ProjectInformationDialog.getInstance(this.getFrame(), this.getCurrentFrame().getProject());
            this.projectInformationDialog.pack();
            this.projectInformationDialog.setModal(false);
        } else {
            this.projectInformationDialog.setObject(this.getCurrentFrame().getProject());
        }
        this.projectInformationDialog.setLocationRelativeTo(this.getCurrentFrame());
        this.projectInformationDialog.setVisible(true);
    }

    public void doInformationDialog(boolean bl) {
        if (!this.isDocumentActive()) {
            return;
        }
        this.finishAnyOperations();
        List list = this.getCurrentFrame().getSelectedNodes(false);
        if (list == null) {
            return;
        }
        if (list.size() > 1) {
            Alert.warn(Messages.getString("Message.onlySelectOneElement"), this.getContainer());
            return;
        }
        Node node = (Node)list.get(0);
        Object object = node.getImpl();
        if (object instanceof Task || object instanceof Assignment && this.taskType) {
            Task task = (Task)(object instanceof Assignment ? ((Assignment)object).getTask() : object);
            if (this.taskInformationDialog == null) {
                this.taskInformationDialog = TaskInformationDialog.getInstance(this.getFrame(), task, bl);
                this.taskInformationDialog.pack();
                this.taskInformationDialog.setModal(false);
            } else {
                this.taskInformationDialog.setObject(task);
                this.taskInformationDialog.updateAll();
            }
            this.taskInformationDialog.setLocationRelativeTo(this.getCurrentFrame());
            if (bl) {
                this.taskInformationDialog.showNotes();
            } else if (object instanceof Assignment) {
                this.taskInformationDialog.showResources();
            }
            this.taskInformationDialog.setVisible(true);
        } else if (object instanceof Resource || object instanceof Assignment && this.resourceType) {
            Resource resource = (Resource)(object instanceof Assignment ? ((Assignment)object).getResource() : object);
            if (this.resourceInformationDialog == null) {
                this.resourceInformationDialog = ResourceInformationDialog.getInstance(this.getFrame(), resource);
                this.resourceInformationDialog.pack();
                this.resourceInformationDialog.setModal(false);
            } else {
                this.resourceInformationDialog.setObject(resource);
                this.resourceInformationDialog.updateAll();
            }
            this.resourceInformationDialog.setLocationRelativeTo(this.getCurrentFrame());
            if (bl) {
                this.resourceInformationDialog.showNotes();
            }
            this.resourceInformationDialog.setVisible(true);
        } else if (object instanceof Project) {
            this.doProjectInformationDialog();
        }
    }

    @Override
    public Action getAction(String string) throws MissingListenerException {
        Action action;
        if (this.actionsMap == null) {
            this.addHandlers();
        }
        if ((action = this.actionsMap.getConcreteAction(string)) == null) {
            throw new MissingListenerException("no listener for mainFrame", this.getClass().getName(), string);
        }
        return action;
    }

    @Override
    public String getStringFromAction(Action action) throws MissingListenerException {
        return this.actionsMap.getStringFromAction(action);
    }

    public Action getRawAction(String string) {
        return this.actionsMap.getActionFromMenuId(string);
    }

    public void addHandlers() {
        this.actionsMap = new MenuActionsMap(this, this.menuManager);
        this.actionsMap.addHandler("NewProject", new NewProjectAction());
        this.actionsMap.addHandler("OpenProject", new OpenProjectAction());
        this.actionsMap.addHandler("InsertProject", new InsertProjectAction());
        this.actionsMap.addHandler("Exit", new ExitAction());
        this.actionsMap.addHandler("ImportMSProject", new ImportMSProjectAction());
        this.actionsMap.addHandler("ExportMSProject", new ExportMSProjectAction());
        this.actionsMap.addHandler("AboutProjectLibre", new AboutAction());
        this.actionsMap.addHandler("ProjectLibre", new ProjectLibreAction());
        this.actionsMap.addHandler("ProjectLibreDocumentation", new HelpAction());
        this.actionsMap.addHandler("TipOfTheDay", new TipOfTheDayAction());
        this.actionsMap.addHandler("ProjectInformation", new ProjectInformationAction());
        this.actionsMap.addHandler("ProjectsDialog", new ProjectsDialogAction());
        this.actionsMap.addHandler("TeamFilter", new TeamFilterAction());
        this.actionsMap.addHandler("Documents", new DocumentsAction());
        this.actionsMap.addHandler("Information", new InformationAction());
        this.actionsMap.addHandler("Notes", new NotesAction());
        this.actionsMap.addHandler("AssignResources", new AssignResourcesAction());
        this.actionsMap.addHandler("Find", new FindAction());
        this.actionsMap.addHandler("GoTo", new GoToAction());
        this.actionsMap.addHandler("InsertTask", new InsertTaskAction());
        this.actionsMap.addHandler("InsertResource", new InsertTaskAction());
        this.actionsMap.addHandler("SaveProject", new SaveProjectAction());
        this.actionsMap.addHandler("SaveProjectAs", new SaveProjectAsAction());
        this.actionsMap.addHandler("Print", new PrintAction());
        this.actionsMap.addHandler("PrintPreview", new PrintPreviewAction());
        this.actionsMap.addHandler("PDF", new PDFAction());
        this.actionsMap.addHandler("CloseProject", new CloseProjectAction());
        this.actionsMap.addHandler("Undo", new UndoAction());
        this.actionsMap.addHandler("Redo", new RedoAction());
        this.actionsMap.addHandler("ChangeWorkingTime", new ChangeWorkingTimeAction());
        this.actionsMap.addHandler("LevelResources", new LevelResourcesAction());
        this.actionsMap.addHandler("DelegateTasks", new DelegateTasksAction());
        this.actionsMap.addHandler("UpdateTasks", new UpdateTasksAction());
        this.actionsMap.addHandler("UpdateProject", new UpdateProjectAction());
        this.actionsMap.addHandler("Bar", new BarAction());
        this.actionsMap.addHandler("InsertRecurring", new RecurringTaskAction());
        this.actionsMap.addHandler("Sort", new SortAction());
        this.actionsMap.addHandler("Group", new GroupAction());
        this.actionsMap.addHandler("CalendarOptions", new CalendarOptionsAction());
        this.actionsMap.addHandler("SaveBaseline", new SaveBaselineAction());
        this.actionsMap.addHandler("ClearBaseline", new ClearBaselineAction());
        this.actionsMap.addHandler("LocaleAction", new LocaleAction());
        this.actionsMap.addHandler("Link", new LinkAction());
        this.actionsMap.addHandler("Unlink", new UnlinkAction());
        this.actionsMap.addHandler("ZoomIn", new ZoomInAction());
        this.actionsMap.addHandler("ZoomOut", new ZoomOutAction());
        this.actionsMap.addHandler("ScrollToTask", new ScrollToTaskAction());
        this.actionsMap.addHandler("Indent", new IndentAction());
        this.actionsMap.addHandler("Outdent", new OutdentAction());
        this.actionsMap.addHandler("Collapse", new CollapseAction());
        this.actionsMap.addHandler("Expand", new ExpandAction());
        this.actionsMap.addHandler("Cut", new CutAction());
        this.actionsMap.addHandler("Copy", new CopyAction());
        this.actionsMap.addHandler("Paste", new PasteAction());
        this.actionsMap.addHandler("Delete", new DeleteAction());
        this.actionsMap.addHandler("Gantt", new ViewAction("Gantt"));
        this.actionsMap.addHandler("TrackingGantt", new ViewAction("TrackingGantt"));
        this.actionsMap.addHandler("TaskUsageDetail", new ViewAction("TaskUsageDetail"));
        this.actionsMap.addHandler("ResourceUsageDetail", new ViewAction("ResourceUsageDetail"));
        this.actionsMap.addHandler("Network", new ViewAction("Network"));
        this.actionsMap.addHandler("WBS", new ViewAction("WBS"));
        this.actionsMap.addHandler("RBS", new ViewAction("RBS"));
        this.actionsMap.addHandler("Report", new ViewAction("Report"));
        this.actionsMap.addHandler("Projects", new ViewAction("Projects"));
        this.resourceAction = new ViewAction("Resources");
        this.actionsMap.addHandler("Resources", this.resourceAction);
        this.actionsMap.addHandler("Histogram", new ViewAction("Histogram"));
        this.actionsMap.addHandler("Charts", new ViewAction("Charts"));
        this.actionsMap.addHandler("TaskUsage", new ViewAction("TaskUsage"));
        this.actionsMap.addHandler("ResourceUsage", new ViewAction("ResourceUsage"));
        this.actionsMap.addHandler("NoSubWindow", new ViewAction("NoSubWindow"));
        this.actionsMap.addHandler("ChooseFilter", new TransformAction());
        this.actionsMap.addHandler("ChooseSort", new TransformAction());
        this.actionsMap.addHandler("ChooseGroup", new TransformAction());
        this.actionsMap.addHandler("Palette", new PaletteAction());
        this.actionsMap.addHandler("LookAndFeel", new LookAndFeelAction());
        this.actionsMap.addHandler("FullScreen", new FullScreenAction());
        this.actionsMap.addHandler("Refresh", new RefreshAction());
    }

    private boolean isEnabledFieldAction(String string, Object object) {
        Field field = FieldDictionary.getInstance().getActionField("Documents");
        return object != null && field != null && field.getValue(object, null) != null;
    }

    private void invokeFieldAction(String string, Object object) {
        Field field = FieldDictionary.getInstance().getActionField("Documents");
        if (field != null) {
            field.invokeAction(object);
        }
    }

    public void doUndoRedo(boolean bl) {
        DocumentFrame documentFrame = this.getCurrentFrame();
        UndoController undoController = GraphicManager.getUndoController();
        Object[] objectArray = null;
        if (undoController != null) {
            if (bl) {
                String string = undoController.getUndoName();
                if (string != null) {
                    objectArray = new Object[]{true, string};
                }
            } else {
                String string = undoController.getRedoName();
                if (string != null) {
                    objectArray = new Object[]{false, string};
                }
            }
        }
        if (objectArray == null) {
            objectArray = new Object[]{bl};
        }
        this.addHistory("doUndoRedo", objectArray);
        documentFrame.doUndoRedo(bl);
    }

    public void closeApplication() {
        this.addHistory("closeApplication");
        new Thread(){

            @Override
            public void run() {
                JobRunnable jobRunnable = new JobRunnable("Local: closeProjects"){

                    @Override
                    public Object run() throws Exception {
                        Frame frame = GraphicManager.this.getFrame();
                        if (frame != null) {
                            frame.dispose();
                        }
                        System.exit(0);
                        return null;
                    }
                };
                Job job = GraphicManager.this.projectFactory.getPortfolio().getRemoveAllProjectsJob(jobRunnable, true, null);
                SessionFactory.getInstance().getLocalSession().schedule(job);
            }
        }.start();
    }

    public void initLayout() {
        this.getFrameManager().getWorkspace().setLayout(new BorderLayout());
    }

    public void initProject() {
        if (this.currentFrame != null) {
            this.currentFrame.activateView("Gantt");
        }
    }

    void setEnabledDocumentMenuActions(boolean bl) {
        if (Environment.isPlugin()) {
            return;
        }
        this.actionsMap.setEnabledDocumentMenuActions(bl);
        if (this.getCurrentFrame() != null) {
            this.getCurrentFrame().getFilterToolBarManager().setEnabled(bl);
        }
        if (this.topTabs != null) {
            this.topTabs.setTrackingEnabled(bl && this.isDocumentWritable());
        }
    }

    protected Document loadMasterProject() {
        return this.loadDocument(-2L, false, false);
    }

    public Document loadDocument(long l, boolean bl, boolean bl2) {
        return this.loadDocument(l, bl, bl2, null);
    }

    protected Document loadDocument(long l, boolean bl, boolean bl2, Closure closure) {
        this.addHistory("loadDocument", new Object[]{l, bl, bl2, closure == null});
        if (l == -1L) {
            return null;
        }
        ProjectFactory projectFactory = this.projectFactory;
        projectFactory.setServer(server);
        LoadOptions loadOptions = new LoadOptions();
        loadOptions.setId(l);
        loadOptions.setSync(bl);
        loadOptions.setOpenAs(bl2);
        loadOptions.setEndSwingClosure(closure);
        Project project = projectFactory.openProject(loadOptions);
        return project;
    }

    protected boolean loadLocalDocument(String string, boolean bl) {
        Project project;
        this.addHistory("loadLocalDocument", new Object[]{string, bl});
        if (string == null) {
            project = this.projectFactory.createProject();
        } else {
            LoadOptions loadOptions = new LoadOptions();
            loadOptions.setFileName(string);
            loadOptions.setLocal(true);
            loadOptions.setSync(false);
            if (bl) {
                loadOptions.setResourceMapping(new ResourceMappingForm(){

                    @Override
                    public boolean execute() {
                        if (this.getImportedResources().size() == 0) {
                            return true;
                        }
                        if (GraphicManager.this.resourceMappingDialog == null) {
                            GraphicManager.this.resourceMappingDialog = ResourceMappingDialog.getInstance(this);
                            GraphicManager.this.resourceMappingDialog.pack();
                            GraphicManager.this.resourceMappingDialog.setModal(true);
                        } else {
                            GraphicManager.this.resourceMappingDialog.setForm(this);
                        }
                        GraphicManager.this.resourceMappingDialog.bind(true);
                        GraphicManager.this.resourceMappingDialog.setLocationRelativeTo(GraphicManager.this.getCurrentFrame());
                        GraphicManager.this.resourceMappingDialog.setVisible(true);
                        return GraphicManager.this.resourceMappingDialog.getDialogResult() == 0;
                    }
                });
            }
            if (string.endsWith(".pod")) {
                loadOptions.setImporter(Environment.getStandAlone() ? "com.projectlibre1.exchange.LocalFileImporter" : "com.projectlibre1.exchange.ServerLocalFileImporter");
            } else {
                loadOptions.setImporter("com.projectlibre1.exchange.MicrosoftImporter");
            }
            project = this.projectFactory.openProject(loadOptions);
        }
        return project != null;
    }

    protected void saveLocalDocument(String string, final boolean bl) {
        this.addHistory("saveLocalDocument", new Object[]{string, bl});
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.setLocal(true);
        final Project project = this.getCurrentFrame().getProject();
        if (project.getFileName() != string) {
            final DocumentFrame documentFrame = this.getCurrentFrame();
            if (bl) {
                saveOptions.setSaveAs(true);
            }
            saveOptions.setPostSaving(new Closure(){
                final /* synthetic */ GraphicManager this$0;
                {
                    this.this$0 = graphicManager;
                }

                @Override
                public void execute(Object object) {
                    if (bl) {
                        documentFrame.setId("" + project.getUniqueId());
                    }
                    this.this$0.refreshSaveStatus(true);
                }
            });
        }
        if (string.endsWith(".pod")) {
            saveOptions.setFileName(string);
            saveOptions.setImporter("com.projectlibre1.exchange.LocalFileImporter");
        } else {
            saveOptions.setFileName(string);
            saveOptions.setImporter("com.projectlibre1.exchange.MicrosoftImporter");
        }
        saveOptions.setPreSaving(this.getSavingClosure());
        this.projectFactory.saveProject(this.getCurrentFrame().getProject(), saveOptions);
    }

    private Closure getSavingClosure() {
        return null;
    }

    private Closure getLoadClosure() {
        return null;
    }

    protected void saveLocalDocument(Project project, String string) {
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.setFileName(string);
        saveOptions.setLocal(true);
        saveOptions.setPreSaving(this.getSavingClosure());
        this.projectFactory.saveProject(project, saveOptions);
    }

    protected void closeProject(Project project) {
        this.projectFactory.removeProject(project, true, true, true);
    }

    public void openLocalProject() {
        String string = SessionFactory.getInstance().getLocalSession().chooseFileName(false, null);
        if (string != null) {
            this.loadLocalDocument(string, !Environment.getStandAlone());
        }
    }

    public void saveLocalProject(boolean bl) {
        String string = null;
        Project project = this.getCurrentFrame().getProject();
        if (!bl) {
            string = project.getFileName();
        }
        if (string == null) {
            string = SessionFactory.getInstance().getLocalSession().chooseFileName(true, project.getGuessedFileName());
        }
        if (string != null) {
            this.saveLocalDocument(string, bl);
        }
    }

    public void showAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = AboutDialog.getInstance(this.getFrame());
            this.aboutDialog.pack();
            this.aboutDialog.setModal(true);
        }
        this.aboutDialog.setLocationRelativeTo(this.getFrame());
        this.aboutDialog.setVisible(true);
    }

    public void showHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = HelpDialog.getInstance(this.getFrame());
            this.helpDialog.pack();
            this.helpDialog.setModal(true);
        }
        this.helpDialog.setLocationRelativeTo(this.getFrame());
        this.helpDialog.setVisible(true);
    }

    public void showAssignmentDialog(DocumentFrame documentFrame) {
        if (this.currentFrame == null || !this.getCurrentFrame().isActive()) {
            return;
        }
        if (this.assignResourcesDialog == null) {
            this.assignResourcesDialog = new AssignmentDialog(documentFrame);
            this.assignResourcesDialog.pack();
            this.assignResourcesDialog.setModal(false);
        }
        this.assignResourcesDialog.setLocationRelativeTo(documentFrame);
        this.assignResourcesDialog.setVisible(true);
    }

    void doCalendarOptionsDialog() {
        this.finishAnyOperations();
        CalendarDialogBox.getInstance(this.getFrame(), null).doModal();
    }

    void print() {
        GraphPageable graphPageable = PrintDocumentFactory.getInstance().createDocument(this.getCurrentFrame(), true, false);
        if (graphPageable != null) {
            graphPageable.print();
        }
    }

    void printPreview() {
        GraphPageable graphPageable = PrintDocumentFactory.getInstance().createDocument(this.getCurrentFrame(), false, false);
        if (graphPageable != null) {
            graphPageable.preview();
        }
    }

    void savePDF() {
        GraphPageable graphPageable = PrintDocumentFactory.getInstance().createDocument(this.getCurrentFrame(), false, false);
        try {
            Class clazz = ClassLoaderUtils.forName("org.projectlibre.export.ImageExport");
            clazz.getMethod("export", GraphPageable.class, Component.class).invoke(null, graphPageable, this.getContainer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DocumentFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Container getContainer() {
        return this.container;
    }

    public JobQueue getJobQueue() {
        if (this.jobQueue == null) {
            this.jobQueue = new JobQueue("GraphicManager", false);
        }
        return this.jobQueue;
    }

    public boolean isDocumentActive() {
        return this.currentFrame != null && this.currentFrame.isActive();
    }

    public boolean isDocumentWritable() {
        return this.currentFrame != null && this.currentFrame.isActive() && !this.currentFrame.getProject().isReadOnly();
    }

    @Override
    public void namedFrameActivated(NamedFrameEvent namedFrameEvent) {
        NamedFrame namedFrame = namedFrameEvent.getNamedFrame();
        if (namedFrame instanceof DocumentFrame) {
            DocumentFrame documentFrame = (DocumentFrame)namedFrame;
            this.setCurrentFrame(documentFrame);
        }
    }

    @Override
    public void namedFrameShown(NamedFrameEvent namedFrameEvent) {
    }

    @Override
    public void namedFrameTabShown(NamedFrameEvent namedFrameEvent) {
        NamedFrame namedFrame = namedFrameEvent.getNamedFrame();
        if (namedFrame instanceof DocumentFrame) {
            DocumentFrame documentFrame = (DocumentFrame)namedFrame;
            this.setCurrentFrame(documentFrame);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.assignResourcesDialog) {
            this.assignResourcesDialog = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public void setTaskInformation(boolean bl, boolean bl2) {
        this.taskType = bl;
        this.resourceType = bl2;
    }

    public void setConnected(boolean bl) {
        this.getMenuManager().setActionEnabled("ImportMSProject", bl);
        this.getMenuManager().setActionEnabled("OpenProject", bl);
        this.getMenuManager().setActionEnabled("NewProject", bl);
        if (bl) {
            this.refreshSaveStatus(true);
        }
    }

    Set getActionSet() {
        HashSet<String> hashSet = null;
        DocumentFrame documentFrame = this.getCurrentFrame();
        if (documentFrame != null) {
            String[] stringArray;
            SpreadSheet spreadSheet = documentFrame.getActiveSpreadSheet();
            hashSet = new HashSet<String>();
            if (spreadSheet != null && (stringArray = spreadSheet.getActionList()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
        }
        return hashSet;
    }

    void setButtonState(Object object, Project project) {
        Set set = this.getActionSet();
        boolean bl = object != null && (object instanceof Assignment || object instanceof Task || object instanceof Resource);
        boolean bl2 = object != null && !(object instanceof VoidNodeImpl);
        boolean bl3 = !this.isDocumentWritable();
        this.getMenuManager().setActionEnabled("Information", bl);
        this.getMenuManager().setActionEnabled("Notes", bl);
        this.getMenuManager().setActionEnabled("InsertTask", !(bl3 || !this.taskType && !this.resourceType || set != null && !set.contains("InsertTask")));
        this.getMenuManager().setActionEnabled("InsertResource", !(bl3 || !this.taskType && !this.resourceType || set != null && !set.contains("InsertTask")));
        this.getMenuManager().setActionEnabled("Cut", !bl3 && bl2 && (set == null || set.contains("Cut")));
        this.getMenuManager().setActionEnabled("Copy", bl2 && (set == null || set.contains("Copy")));
        this.getMenuManager().setActionEnabled("Paste", !bl3 && (set == null || set.contains("Paste")));
        this.getMenuManager().setActionEnabled("Delete", !bl3 && (set == null || set.contains("Delete")));
        boolean bl4 = object != null && object instanceof Task;
        boolean bl5 = object != null && object instanceof Resource;
        boolean bl6 = object != null && object instanceof HasStartAndEnd;
        boolean bl7 = object != null && !ClassUtils.isObjectReadOnly(object);
        this.getMenuManager().setActionEnabled("Indent", !(bl3 || !bl4 && !bl5 || set != null && !set.contains("Indent")));
        this.getMenuManager().setActionEnabled("Outdent", !(bl3 || !bl4 && !bl5 || set != null && !set.contains("Outdent")));
        this.getMenuManager().setActionEnabled("Link", bl4);
        this.getMenuManager().setActionEnabled("Unlink", bl4);
        this.getMenuManager().setActionEnabled("AssignResources", bl4 && bl7);
        this.getMenuManager().setActionEnabled("DelegateTasks", bl4 && bl7);
        this.getMenuManager().setActionEnabled("UpdateTasks", !bl3 && bl4);
        boolean bl8 = this.getCurrentFrame().isCurrentRowInMainProject();
        this.getMenuManager().setActionEnabled("InsertProject", !bl3 && bl8);
        BaseView baseView = null;
        DocumentFrame documentFrame = this.getCurrentFrame();
        if (documentFrame != null) {
            baseView = (BaseView)((Object)documentFrame.getMainView().getTopComponent());
        }
        this.getMenuManager().setActionEnabled("ScrollToTask", bl6 && baseView.canScrollToTask());
        if (this.currentFrame != null) {
            this.currentFrame.refreshUndoButtons();
        }
        boolean bl9 = this.currentFrame != null && this.currentFrame.isPrintable();
        this.getMenuManager().setActionEnabled("Print", bl9);
        this.getMenuManager().setActionEnabled("PrintPreview", bl9);
        this.setZoomButtons();
        Field field = FieldDictionary.getInstance().getActionField("Documents");
        this.getMenuManager().setActionVisible("Documents", this.currentFrame != null && field != null);
        this.getMenuManager().setActionEnabled("Documents", this.currentFrame != null && this.isEnabledFieldAction("Documents", this.currentFrame.getProject()));
    }

    public void setZoomButtons() {
        this.getMenuManager().setActionEnabled("ZoomIn", this.currentFrame != null && this.currentFrame.canZoomIn());
        this.getMenuManager().setActionEnabled("ZoomOut", this.currentFrame != null && this.currentFrame.canZoomOut());
    }

    @Override
    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        if (this.assignResourcesDialog != null) {
            this.assignResourcesDialog.selectionChanged(selectionNodeEvent);
        }
        Node node = selectionNodeEvent.getCurrentNode();
        Object object = node.getImpl();
        this.setButtonState(object, this.currentFrame.getProject());
        if (this.lastNode != null && this.taskInformationDialog != null && (this.lastNode.getImpl() instanceof Task || this.lastNode.getImpl() instanceof Assignment) && node.getImpl() instanceof Resource) {
            this.taskInformationDialog.setVisible(false);
            this.doInformationDialog(false);
        } else if (this.lastNode != null && this.resourceInformationDialog != null && this.lastNode.getImpl() instanceof Resource && (node.getImpl() instanceof Task || node.getImpl() instanceof Assignment)) {
            this.resourceInformationDialog.setVisible(false);
            this.doInformationDialog(false);
        } else {
            if (this.taskInformationDialog != null) {
                this.taskInformationDialog.selectionChanged(selectionNodeEvent);
            }
            if (this.resourceInformationDialog != null) {
                this.resourceInformationDialog.selectionChanged(selectionNodeEvent);
            }
        }
        this.lastNode = node;
    }

    void refreshSaveStatus(boolean bl) {
        this.getMenuManager().setActionEnabled("SaveProject", this.currentFrame != null && !bl && this.currentFrame.getProject().needsSaving());
        this.setTitle(bl);
        FrameManager frameManager = this.getFrameManager();
        if (frameManager != null) {
            frameManager.update();
        }
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (objectEvent.getObject() instanceof Project) {
            Project project = (Project)objectEvent.getObject();
            if (objectEvent.isCreate()) {
                if (project.isOpenedAsSubproject()) {
                    this.closeProjectFrame(project);
                } else {
                    DocumentFrame documentFrame = this.addProjectFrame(project);
                }
            } else if (objectEvent.isDelete()) {
                this.closeProjectFrame(project);
            }
            if (this.projectInformationDialog != null) {
                this.projectInformationDialog.objectChanged(objectEvent);
            }
            if (this.taskInformationDialog != null) {
                this.taskInformationDialog.objectChanged(objectEvent);
            }
            if (this.resourceInformationDialog != null) {
                this.resourceInformationDialog.objectChanged(objectEvent);
            }
        }
    }

    public MenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = MenuManager.getInstance(this);
            this.addHandlers();
        }
        return this.menuManager;
    }

    public void finishAnyOperations() {
        if (this.getCurrentFrame() != null) {
            this.getCurrentFrame().finishAnyOperations();
        }
    }

    public void showWaitCursor(boolean bl) {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if (bl) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    public final ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    public String getTopViewId() {
        if (this.getCurrentFrame() == null) {
            return "Gantt";
        }
        return this.getCurrentFrame().getTopViewId();
    }

    public boolean isApplet() {
        return false;
    }

    public void setRibbon(JRibbonFrame jRibbonFrame, MenuManager menuManager) {
        JComponent jComponent2;
        final JPanel jPanel = new JPanel(new GridLayout(3, 1));
        this.filterToolBarManager = FilterToolBarManager.create(this.getMenuManager());
        this.filterToolBarManager.addButtonsInRibbonBand(jPanel);
        CustomRibbonBandGenerator customRibbonBandGenerator = new CustomRibbonBandGenerator(){

            @Override
            public JComponent createRibbonComponent(String string) {
                if ("FiltersRibbonBand".equals(string)) {
                    return jPanel;
                }
                return null;
            }
        };
        Collection<RibbonTask> collection = menuManager.getRibbon("StandardRibbon", customRibbonBandGenerator);
        JRibbon jRibbon = jRibbonFrame.getRibbon();
        for (RibbonTask object2 : collection) {
            jRibbon.addTask(object2);
        }
        RibbonApplicationMenu ribbonApplicationMenu = new RibbonApplicationMenu();
        jRibbon.setApplicationMenu(ribbonApplicationMenu);
        Collection<AbstractCommandButton> collection2 = menuManager.getTaskBar("StandardRibbon");
        for (JComponent jComponent2 : collection2) {
            jRibbon.addTaskbarComponent(jComponent2);
        }
        jRibbon.configureHelp(IconManager.getRibbonIcon("ribbon.help", 26, 26), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicManager.this.showHelpDialog();
            }
        });
        JPanel jPanel2 = jRibbon.getProjectViews();
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.getMenuManager().initComponent("RibbonViewToolBar", jPanel2);
        jComponent2 = jRibbon.getFileSelector();
        jComponent2.setLayout(new BorderLayout());
        jComponent2.setBackground(ProjectLibreRibbonUI.RIBBON_MENU_COLOR);
        JPanel jPanel3 = ((DefaultFrameManager)this.getFrameManager()).getProjectComboPanel();
        jPanel3.setBackground(ProjectLibreRibbonUI.RIBBON_MENU_COLOR);
        jComponent2.add((Component)jPanel3, "East");
        JPanel jPanel4 = jRibbon.getLanguageSelector();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBackground(ProjectLibreRibbonUI.RIBBON_MENU_COLOR);
        JButton jButton = new JButton(IconManager.getIcon("menu16.locale"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog localeDialog = LocaleDialog.getInstance(GraphicManager.this.getGraphicManager());
                localeDialog.doModal();
            }
        });
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jPanel4.add((Component)jButton, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void setToolBarAndMenus(Container container) {
        if (Environment.isRibbonUI()) {
            if (Environment.isNeedToRestart()) {
                container.add((Component)new JLabel(Messages.getString("Error.restart")), "Center");
                return;
            }
            this.setRibbon((JRibbonFrame)this.container, this.getMenuManager());
        } else if (Environment.isNewLook()) {
            if (Environment.isNeedToRestart()) {
                container.add((Component)new JLabel(Messages.getString("Error.restart")), "Center");
                return;
            }
            JToolBar jToolBar = this.getMenuManager().getToolBar("BigToolBar");
            if (!this.getLafManager().isToolbarOpaque()) {
                jToolBar.setOpaque(false);
            }
            if (!this.isApplet()) {
                this.getMenuManager().setActionVisible("FullScreen", false);
            }
            if (Environment.isExternal()) {
                this.getMenuManager().setActionVisible("TeamFilter", false);
            }
            jToolBar.addSeparator(new Dimension(20, 20));
            jToolBar.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE)));
            jToolBar.add(((DefaultFrameManager)this.getFrameManager()).getProjectComboPanel());
            jToolBar.add(Box.createRigidArea(new Dimension(20, 20)));
            if (Environment.isNewLaf()) {
                jToolBar.setBackground(Color.WHITE);
            }
            jToolBar.setFloatable(false);
            jToolBar.setCursor(Cursor.getPredefinedCursor(12));
            Box box = new Box(1);
            jToolBar.setAlignmentX(0.0f);
            box.add(jToolBar);
            JToolBar jToolBar2 = this.getMenuManager().getToolBar("ViewToolBarNoSubView");
            this.topTabs = new TabbedNavigation();
            JComponent jComponent = this.topTabs.createContentPanel(this.getMenuManager(), jToolBar2, 0, 1, true);
            jComponent.setAlignmentX(0.0f);
            box.add(jComponent);
            JComponent jComponent2 = new TabbedNavigation().createContentPanel(this.getMenuManager(), jToolBar2, 1, 3, false);
            container.add((Component)box, "First");
            container.add((Component)jComponent2, "Last");
            if (Environment.isNewLaf()) {
                container.setBackground(Color.WHITE);
            }
            if (Environment.isMac()) {
                JMenuBar jMenuBar = this.getMenuManager().getMenu(Environment.getStandAlone() ? "MacStandardMenuBar" : "ServerStandardMenuBar");
                ((JFrame)this.container).setJMenuBar(jMenuBar);
                this.projectListMenu = (JMenu)jMenuBar.getComponent(5);
            }
        } else {
            JToolBar jToolBar = this.getMenuManager().getToolBar(Environment.isMac() ? "MacStandardToolBar" : "StandardToolBar");
            this.filterToolBarManager = FilterToolBarManager.create(this.getMenuManager());
            this.filterToolBarManager.addButtons(jToolBar);
            container.add((Component)jToolBar, "First");
            JToolBar jToolBar3 = this.getMenuManager().getToolBar("ViewToolBar");
            jToolBar3.setOrientation(1);
            jToolBar3.setRollover(true);
            container.add((Component)jToolBar3, "West");
            JMenuBar jMenuBar = this.getMenuManager().getMenu(Environment.getStandAlone() ? (Environment.isMac() ? "MacStandardMenuBar" : "StandardMenuBar") : "ServerStandardMenuBar");
            if (!Environment.isMac()) {
                jMenuBar.setBorder(BorderFactory.createEmptyBorder());
                JMenuItem jMenuItem = (JMenuItem)jMenuBar.getComponent(0);
                jMenuItem.setBorder(BorderFactory.createEmptyBorder());
                jMenuItem.setMaximumSize(new Dimension(124, 52));
                jMenuItem.setCursor(Cursor.getPredefinedCursor(12));
            }
            ((JFrame)this.container).setJMenuBar(jMenuBar);
            this.projectListMenu = (JMenu)jMenuBar.getComponent(Environment.isMac() ? 5 : 6);
        }
        this.addCtrlAccel(71, "GoTo", null);
        this.addCtrlAccel(76, "GoTo", null);
        this.addCtrlAccel(70, "Find", null);
        this.addCtrlAccel(90, "Undo", null);
        this.addCtrlAccel(89, "Redo", null);
        this.addCtrlAccel(78, "NewProject", null);
        this.addCtrlAccel(79, "OpenProject", null);
        this.addCtrlAccel(83, "SaveProject", null);
        this.addCtrlAccel(80, "Print", null);
        this.addCtrlAccel(73, "InsertTask", null);
        this.addCtrlAccel(46, "Indent", null);
        this.addCtrlAccel(44, "Outdent", null);
        this.addCtrlAccel(521, "Expand", new ExpandAction());
        this.addCtrlAccel(107, "Expand", new ExpandAction());
        this.addCtrlAccel(61, "Expand", new ExpandAction());
        this.addCtrlAccel(45, "Collapse", new CollapseAction());
        this.addCtrlAccel(109, "Collapse", new CollapseAction());
        this.addCtrlAccel(82, "Recalculate", new RecalculateAction());
    }

    private void addCtrlAccel(int n, String string, Action action) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.container);
        InputMap inputMap = rootPaneContainer.getRootPane().getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(keyStroke, string);
        if (action == null) {
            action = this.menuManager.getActionFromId(string);
        }
        rootPaneContainer.getRootPane().getActionMap().put(string, action);
    }

    private LookAndFeel getPlaf() {
        return this.getLafManager().getPlaf();
    }

    public void invalidate() {
        this.container.invalidate();
        ((RootPaneContainer)((Object)this.container)).getContentPane().invalidate();
        ((RootPaneContainer)((Object)this.container)).getContentPane().repaint();
    }

    public void initLookAndFeel() {
        this.getLafManager().initLookAndFeel();
    }

    public HashMap getColorThemes() {
        if (this.colorThemes == null) {
            this.colorThemes = new HashMap();
            this.colorThemes.put("Gantt", "Bloody Moon");
            this.colorThemes.put("TrackingGantt", "Mahogany");
            this.colorThemes.put("Network", "Emerald Grass");
            this.colorThemes.put("Resources", "Blue Yonder");
            this.colorThemes.put("Projects", "Emerald Grass");
            this.colorThemes.put("WBS", "Sepia");
            this.colorThemes.put("RBS", "Steel Blue");
            this.colorThemes.put("Report", "Aqua");
            this.colorThemes.put("TaskUsageDetail", "Brown Velvet");
            this.colorThemes.put("ResourceUsageDetail", "Earth Fresco");
        }
        return this.colorThemes;
    }

    public void setPaletteText(String string) {
        this.getMenuManager().setText("Palette", string);
    }

    void setColorTheme(String string) {
        this.getLafManager().setColorTheme(string);
    }

    private Workspace decodeWorkspaceXML() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)lastWorkspace).getBytes());
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(byteArrayInputStream));
        Workspace workspace = (Workspace)xMLDecoder.readObject();
        xMLDecoder.close();
        return workspace;
    }

    private Workspace decodeWorkspaceBinary() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])lastWorkspace);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (Workspace)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public Workspace decodeWorkspace() {
        if (lastWorkspace == null) {
            return null;
        }
        return this.decodeWorkspaceBinary();
    }

    private void encodeWorkspaceXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(byteArrayOutputStream));
        xMLEncoder.writeObject(this.createWorkspace(0));
        xMLEncoder.close();
        lastWorkspace = byteArrayOutputStream.toString();
    }

    private void encodeWorkspaceBinary() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.createWorkspace(0));
            objectOutputStream.close();
            byteArrayOutputStream.close();
            lastWorkspace = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void encodeWorkspace() {
        this.encodeWorkspaceBinary();
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.colorThemes = workspace.colorThemes;
        this.getFrameManager().restoreWorkspace(workspace.frames, n);
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.colorThemes = this.getColorThemes();
        workspace.frames = this.getFrameManager().createWorkspace(n);
        return workspace;
    }

    public static final Object getLastWorkspace() {
        return lastWorkspace;
    }

    @Override
    public GraphicManager getGraphicManager() {
        return this;
    }

    @Override
    public void setGraphicManager(GraphicManager graphicManager) {
    }

    @Override
    public FrameManager getFrameManager() {
        return this.frameManager;
    }

    public void setFrameManager(FrameManager frameManager) {
        this.frameManager = frameManager;
    }

    public void initView() {
        Container container = this.container;
        if (this.container != null && this.container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)this.container)).getContentPane();
        }
        if (!Environment.isRibbonUI()) {
            container.setLayout(new BorderLayout());
        }
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        this.setFrameManager(new DefaultFrameManager(this.container, jPanel, this));
        this.initLayout();
        if (!Environment.isPlugin()) {
            this.setToolBarAndMenus(container);
        }
        this.setEnabledDocumentMenuActions(false);
        Workspace workspace = this.decodeWorkspace();
        if (workspace != null) {
            this.restoreWorkspace(workspace, 0);
        } else {
            this.initProject();
        }
    }

    public BaselineDialog getBaselineDialog() {
        return this.baselineDialog;
    }

    public void setBaselineDialog(BaselineDialog baselineDialog) {
        this.baselineDialog = baselineDialog;
    }

    public StartupFactory getStartupFactory() {
        return this.startupFactory;
    }

    public void setStartupFactory(StartupFactory startupFactory) {
        this.startupFactory = startupFactory;
    }

    public boolean isEditingMasterProject() {
        Project project = this.currentFrame.getProject();
        if (project == null) {
            return false;
        }
        return project.isMaster() && !project.isReadOnly();
    }

    public GlobalPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new GlobalPreferences();
            if (Environment.isExternal()) {
                this.preferences.setShowProjectResourcesOnly(true);
            }
        }
        return this.preferences;
    }

    public Closure setAssignmentDialogTransformerInitializationClosure() {
        return new Closure(){

            @Override
            public void execute(Object object) {
                ViewTransformer viewTransformer = (ViewTransformer)object;
                NodeFilter nodeFilter = viewTransformer.getHiddenFilter();
                if (nodeFilter != null && nodeFilter instanceof ResourceInTeamFilter) {
                    GraphicManager.this.assignmentDialogTransformerInitializationClosure = (ResourceInTeamFilter)nodeFilter;
                    GraphicManager.this.assignmentDialogTransformerInitializationClosure.setFilterTeam(GraphicManager.this.getGraphicManager().getPreferences().isShowProjectResourcesOnly());
                } else {
                    GraphicManager.this.assignmentDialogTransformerInitializationClosure = null;
                }
            }
        };
    }

    public ResourceInTeamFilter getAssignmentDialogTransformerInitializationClosure() {
        return this.assignmentDialogTransformerInitializationClosure;
    }

    public FilterToolBarManager getFilterToolBarManager() {
        return this.filterToolBarManager;
    }

    public void beginInitialization() {
        this.showWaitCursor(true);
        this.initializing.lock();
    }

    public void finishInitialization() {
        this.container.setVisible(true);
        this.initialized = true;
        this.initializing.unlock();
        this.showWaitCursor(false);
    }

    public void waitInitialization() {
        this.initializing.waitUntilUnlocked();
    }

    public static SpreadSheetFieldArray getCurrentFieldArray() {
        return GraphicManager.getDocumentFrameInstance().getGanttView().getSpreadSheet().getFieldArrayWithWidths(GraphicManager.getDocumentFrameInstance().getGanttColumns());
    }

    public static void setCurrentFieldArray(Object object) {
        GraphicManager.getDocumentFrameInstance().getGanttView().getSpreadSheet().setFieldArrayWithWidths((SpreadSheetFieldArray)object);
    }

    public static UndoController getUndoController() {
        DocumentFrame documentFrame = GraphicManager.getDocumentFrameInstance();
        if (documentFrame == null) {
            return null;
        }
        return documentFrame.getUndoController();
    }

    public void setAllButResourceDisabled(boolean bl) {
        if (this.topTabs != null) {
            this.topTabs.setAllButResourceDisabled(bl);
        }
    }

    public void doFind(Searchable searchable, Field field) {
        if (this.currentFrame == null || !this.getCurrentFrame().isActive()) {
            return;
        }
        if (searchable == null) {
            return;
        }
        this.currentFrame.doFind(searchable, field);
    }

    public void registerForMacOSXEvents() {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                desktop.setAboutHandler(new AboutHandler(){

                    @Override
                    public void handleAbout(AboutEvent aboutEvent) {
                        GraphicManager.this.showAboutDialog();
                    }
                });
            }
            if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                desktop.setQuitHandler(new QuitHandler(){

                    @Override
                    public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
                        try {
                            boolean bl = GraphicManager.this.quitApplication();
                            if (bl) {
                                quitResponse.performQuit();
                            } else {
                                quitResponse.cancelQuit();
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
            if (Environment.getStandAlone() && desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
                desktop.setOpenFileHandler(new OpenFilesHandler(){

                    @Override
                    public void openFiles(OpenFilesEvent openFilesEvent) {
                        if (openFilesEvent.getFiles() != null && !openFilesEvent.getFiles().isEmpty()) {
                            GraphicManager.this.openFile(openFilesEvent.getFiles().getFirst().getPath());
                        }
                    }
                });
            }
        }
    }

    public void openFile(String string) {
        this.lastFileName = string;
        if (string != null && this.initialized) {
            this.loadLocalDocument(string, !Environment.getStandAlone());
        }
    }

    public String getLastFileName() {
        return this.lastFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quitApplication() throws Exception {
        final boolean[] blArray = new boolean[]{false};
        JobRunnable jobRunnable = new JobRunnable(this, "Local: closeProjects"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    blArray.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
        };
        boolean[] blArray2 = new boolean[]{false};
        Job job = this.projectFactory.getPortfolio().getRemoveAllProjectsJob(jobRunnable, false, blArray2);
        SessionFactory.getInstance().getLocalSession().schedule(job);
        Object object = blArray;
        synchronized (blArray) {
            while (!blArray[0]) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (blArray2[0]) {
                object = this.getFrame();
                if (object != null) {
                    ((Window)object).dispose();
                }
                return true;
            }
            return false;
        }
    }

    public static Project getProject() {
        if (lastGraphicManager == null) {
            return null;
        }
        if (GraphicManager.lastGraphicManager.currentFrame == null) {
            return null;
        }
        return GraphicManager.lastGraphicManager.currentFrame.getProject();
    }

    public void addHistory(String string, Object[] objectArray) {
        this.history.add(new CommandInfo(string, objectArray));
    }

    public void addHistory(String string) {
        this.history.add(new CommandInfo(string, null));
    }

    public static List<CommandInfo> getHistory() {
        if (lastGraphicManager == null) {
            return null;
        }
        return GraphicManager.lastGraphicManager.history;
    }

    static {
        badLAF = false;
        project_suffix_count = 1;
    }

    public class SelectDocumentAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;
        DocumentFrame frame;

        public SelectDocumentAction(DocumentFrame documentFrame) {
            this.frame = documentFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.setCurrentFrame(this.frame);
        }

        @Override
        public Object getValue(String string) {
            if (string == "Name") {
                return this.frame.getProject().getName();
            }
            return super.getValue(string);
        }
    }

    public class NewProjectAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doNewProjectDialog();
        }

        @Override
        protected boolean allowed(boolean bl) {
            DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
            return documentFrame == null || !documentFrame.isEditingResourcePool();
        }
    }

    public class OpenProjectAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (Environment.getStandAlone()) {
                GraphicManager.this.openLocalProject();
            } else {
                GraphicManager.this.doOpenProjectDialog();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
            return documentFrame == null || !documentFrame.isEditingResourcePool();
        }

        @Override
        protected boolean needsDocument() {
            return !this.allowed(true);
        }
    }

    public class InsertProjectAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doInsertProjectDialog();
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class ExitAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.closeApplication();
        }
    }

    public class ImportMSProjectAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.openLocalProject();
        }
    }

    public class ExportMSProjectAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.saveLocalProject(true);
        }
    }

    public class AboutAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.showAboutDialog();
        }
    }

    public class ProjectLibreAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            BrowserControl.displayURL("http://www.projectlibre.com/");
        }
    }

    public class HelpAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.showHelpDialog();
        }
    }

    public class TipOfTheDayAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            TipOfTheDay.showDialog(GraphicManager.this.getFrame(), true);
        }
    }

    public class ProjectInformationAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doProjectInformationDialog();
        }
    }

    public class ProjectsDialogAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            ProjectsDialog.show(GraphicManager.this);
        }
    }

    public class TeamFilterAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GlobalPreferences globalPreferences = GraphicManager.this.getPreferences();
            boolean bl = !globalPreferences.isShowProjectResourcesOnly();
            globalPreferences.setShowProjectResourcesOnly(bl);
            ArrayList arrayList = GraphicManager.this.getMenuManager().getToolBarFactory().getButtonsFromId("TeamFilter");
            if (arrayList != null && arrayList.size() == 1) {
                JButton jButton = (JButton)arrayList.get(0);
                if (Environment.isNewLook()) {
                    jButton.setIcon(IconManager.getIcon(bl ? "menu24.showTeamResources" : "menu24.showAllResources"));
                } else {
                    jButton.setIcon(IconManager.getIcon(bl ? "menu.showTeamResourcesSmall" : "menu.showAllResourcesSmall"));
                }
            }
            GraphicManager.this.menuManager.setActionSelected("TeamFilter", bl);
        }
    }

    public class DocumentsAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (!GraphicManager.this.isDocumentActive()) {
                return;
            }
            GraphicManager.this.invokeFieldAction("Documents", GraphicManager.this.getCurrentFrame().getProject());
        }
    }

    public class InformationAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doInformationDialog(false);
        }
    }

    public class NotesAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doInformationDialog(true);
        }
    }

    public class AssignResourcesAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.showAssignmentDialog(GraphicManager.this.getCurrentFrame());
        }
    }

    public class FindAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.doFind(GraphicManager.this.getCurrentFrame().getTopSpreadSheet(), null);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.currentFrame.getActiveSpreadSheet() != null;
        }
    }

    public class GoToAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.doFind(GraphicManager.this.getCurrentFrame().getTopSpreadSheet(), Configuration.getFieldFromId("Field.id"));
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.currentFrame.getActiveSpreadSheet() != null;
        }
    }

    public class InsertTaskAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().addNodeForImpl(null);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class SaveProjectAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (Environment.getStandAlone()) {
                GraphicManager.this.saveLocalProject(false);
            } else if (GraphicManager.this.isDocumentActive()) {
                DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
                Project project = documentFrame.getProject();
                SaveOptions saveOptions = new SaveOptions();
                saveOptions.setPostSaving(new Closure(){

                    @Override
                    public void execute(Object object) {
                        GraphicManager.this.refreshSaveStatus(true);
                    }
                });
                saveOptions.setPreSaving(GraphicManager.this.getSavingClosure());
                GraphicManager.this.addHistory("saveProject", new Object[]{project.getName(), project.getUniqueId()});
                GraphicManager.this.projectFactory.saveProject(project, saveOptions);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
            if (documentFrame == null) {
                return false;
            }
            Project project = GraphicManager.this.getCurrentFrame().getProject();
            if (project == null) {
                return false;
            }
            return Environment.isProjectLibre() || !project.isLocal() && project.needsSaving();
        }
    }

    public class SaveProjectAsAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (Environment.getStandAlone()) {
                GraphicManager.this.saveLocalProject(true);
            } else if (GraphicManager.this.isDocumentActive()) {
                final DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
                final Project project = documentFrame.getProject();
                SaveOptions saveOptions = new SaveOptions();
                saveOptions.setPostSaving(new Closure(){
                    final /* synthetic */ SaveProjectAsAction this$1;
                    {
                        this.this$1 = saveProjectAsAction;
                    }

                    @Override
                    public void execute(Object object) {
                        documentFrame.setId("" + project.getUniqueId());
                        this.this$1.GraphicManager.this.refreshSaveStatus(true);
                    }
                });
                saveOptions.setSaveAs(true);
                saveOptions.setPreSaving(GraphicManager.this.getSavingClosure());
                GraphicManager.this.projectFactory.saveProject(project, saveOptions);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            DocumentFrame documentFrame = GraphicManager.this.getCurrentFrame();
            if (documentFrame == null) {
                return false;
            }
            Project project = GraphicManager.this.getCurrentFrame().getProject();
            if (project == null) {
                return false;
            }
            if (project.isMaster() && !Environment.getStandAlone() && !Environment.isProjectLibre()) {
                return false;
            }
            return project.isSavable();
        }
    }

    public class PrintAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.print();
            }
        }
    }

    public class PrintPreviewAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                Component component = (Component)actionEvent.getSource();
                Cursor cursor = component.getCursor();
                component.setCursor(Cursor.getPredefinedCursor(3));
                GraphicManager.this.printPreview();
                component.setCursor(cursor);
            }
        }
    }

    public class PDFAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                Component component = (Component)actionEvent.getSource();
                Cursor cursor = component.getCursor();
                component.setCursor(Cursor.getPredefinedCursor(3));
                GraphicManager.this.savePDF();
                component.setCursor(cursor);
            }
        }
    }

    public class CloseProjectAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.closeProject(GraphicManager.this.getCurrentFrame().getProject());
            }
        }
    }

    public class UndoAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.doUndoRedo(true);
            }
        }
    }

    public class RedoAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.doUndoRedo(false);
            }
        }
    }

    public class ChangeWorkingTimeAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            GraphicManager.this.setMeAsLastGraphicManager();
            JDialog jDialog = AbstractDialog.containedInDialog(actionEvent.getSource());
            boolean bl2 = bl = jDialog != null;
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doChangeWorkingTimeDialog(bl);
            }
        }
    }

    public class LevelResourcesAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doLevelResourcesDialog();
            }
        }
    }

    public class DelegateTasksAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doDelegateTasksDialog();
            }
        }
    }

    public class UpdateTasksAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doUpdateTasksDialog();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class UpdateProjectAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doUpdateProjectDialog();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class BarAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doBarDialog();
            }
        }
    }

    public class RecurringTaskAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doRecurringTaskDialog();
            }
        }
    }

    public class SortAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doSortDialog();
            }
        }
    }

    public class GroupAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doGroupDialog();
            }
        }
    }

    public class CalendarOptionsAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.doCalendarOptionsDialog();
        }
    }

    public class SaveBaselineAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doBaselineDialog(true);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class ClearBaselineAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doBaselineDialog(false);
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class LocaleAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            LocaleDialog localeDialog = LocaleDialog.getInstance(GraphicManager.this.getGraphicManager());
            localeDialog.doModal();
        }
    }

    public class LinkAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doLinkTasks();
            }
        }
    }

    public class UnlinkAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doUnlinkTasks();
            }
        }
    }

    public class ZoomInAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doZoomIn();
            }
            GraphicManager.this.setZoomButtons();
        }
    }

    public class ZoomOutAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doZoomOut();
            }
            GraphicManager.this.setZoomButtons();
        }
    }

    public class ScrollToTaskAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doScrollToTask();
            }
        }
    }

    public class IndentAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doIndent();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class OutdentAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doOutdent();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class CollapseAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doCollapse();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class ExpandAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doExpand();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class CutAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.addHistory("doCut");
                GraphicManager.this.getCurrentFrame().doCut();
            }
        }
    }

    public class CopyAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.addHistory("doCopy");
                GraphicManager.this.getCurrentFrame().doCopy();
            }
        }
    }

    public class PasteAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.addHistory("doPaste");
                GraphicManager.this.getCurrentFrame().doPaste();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class DeleteAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doDelete();
            }
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!bl) {
                return true;
            }
            return GraphicManager.this.isDocumentWritable();
        }
    }

    public class ViewAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;
        private String viewName;

        public ViewAction(String string) {
            this.viewName = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.getCurrentFrame() == null) {
                return;
            }
            GraphicManager.this.setColorTheme(this.viewName);
            GraphicManager.this.getCurrentFrame().activateView(this.viewName);
            GraphicManager.this.setButtonState(null, GraphicManager.this.currentFrame.getProject());
        }

        public final String getViewName() {
            return this.viewName;
        }
    }

    public class TransformAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (!GraphicManager.this.isDocumentActive()) {
                return;
            }
            SpreadSheet spreadSheet = GraphicManager.this.getCurrentFrame().getTopSpreadSheet();
            if (spreadSheet != null) {
                if (spreadSheet.isEditing()) {
                    spreadSheet.getCellEditor().stopCellEditing();
                }
                spreadSheet.clearSelection();
            }
            TransformComboBox transformComboBox = (TransformComboBox)actionEvent.getSource();
            transformComboBox.transformBasedOnValue();
        }
    }

    public class PaletteAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.getLafManager().changePalette();
        }

        @Override
        protected boolean allowed(boolean bl) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            return GraphicManager.this.getLafManager().isChangePaletteAllowed(lookAndFeel);
        }
    }

    public class LookAndFeelAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
        }
    }

    public class FullScreenAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class RefreshAction
    extends MenuActionsMap.GlobalMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            GraphicManager.this.getStartupFactory().restart(GraphicManager.this);
        }
    }

    public class RecalculateAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().getProject().recalculate();
            }
        }
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -6606344141026658401L;
        private HashMap colorThemes;
        WorkspaceSetting frames;

        public HashMap getColorThemes() {
            return this.colorThemes;
        }

        public void setColorThemes(HashMap hashMap) {
            this.colorThemes = hashMap;
        }

        public WorkspaceSetting getFrames() {
            return this.frames;
        }

        public void setFrames(WorkspaceSetting workspaceSetting) {
            this.frames = workspaceSetting;
        }
    }

    public class DefineCodeAction
    extends MenuActionsMap.DocumentMenuAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphicManager.this.setMeAsLastGraphicManager();
            if (GraphicManager.this.isDocumentActive()) {
                GraphicManager.this.getCurrentFrame().doDefineCodeDialog();
            }
        }
    }

    protected class CreateSubprojectEdit
    extends AbstractUndoableEdit {
        protected Project project;
        protected final Node subprojectNode;
        protected long subprojectUniqueId;

        public CreateSubprojectEdit(Project project, Node node, long l) {
            this.project = project;
            this.subprojectNode = node;
            this.subprojectUniqueId = l;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            GraphicManager.this.insertSubproject(this.project, this.subprojectUniqueId, false);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.project.getTaskOutline().remove(this.subprojectNode, 1);
        }
    }
}

