/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.router.util.PQEntry;
import net.i2p.util.Log;

public class PriBlockingQueue<E extends PQEntry>
extends PriorityBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    protected final transient I2PAppContext _context;
    protected final transient Log _log;
    protected final String _name;
    private final AtomicLong _seqNum = new AtomicLong();
    private final String STAT_FULL;
    protected static final long[] RATES = new long[]{300000L, 3600000L};
    protected static final int BACKLOG_SIZE = 256;
    protected static final int MAX_SIZE = 512;

    public PriBlockingQueue(I2PAppContext ctx, String name, int initialCapacity) {
        super(initialCapacity, new PriorityComparator());
        this._context = ctx;
        this._log = ctx.logManager().getLog(PriorityBlockingQueue.class);
        this._name = name;
        this.STAT_FULL = ("pbq." + name + ".full").intern();
        ctx.statManager().createRateStat(this.STAT_FULL, "queue full", "Router", RATES);
    }

    @Override
    @Deprecated
    public boolean add(E o) {
        this.timestamp(o);
        if (this.size() >= 512) {
            this._context.statManager().addRateData(this.STAT_FULL, 1L);
            return false;
        }
        return super.add(o);
    }

    @Override
    public boolean offer(E o) {
        this.timestamp(o);
        if (this.size() >= 512) {
            this._context.statManager().addRateData(this.STAT_FULL, 1L);
            return false;
        }
        return super.offer(o);
    }

    @Override
    @Deprecated
    public boolean offer(E o, long timeout, TimeUnit unit) {
        this.timestamp(o);
        if (this.size() >= 512) {
            this._context.statManager().addRateData(this.STAT_FULL, 1L);
            return false;
        }
        return super.offer(o, timeout, unit);
    }

    @Override
    @Deprecated
    public void put(E o) {
        this.timestamp(o);
        super.put(o);
    }

    public boolean isBacklogged() {
        return this.size() >= 256;
    }

    protected void timestamp(E o) {
        o.setSeqNum(this._seqNum.incrementAndGet());
    }

    private static class PriorityComparator<E extends PQEntry>
    implements Comparator<E>,
    Serializable {
        private PriorityComparator() {
        }

        @Override
        public int compare(E l, E r) {
            int d = r.getPriority() - l.getPriority();
            if (d != 0) {
                return d;
            }
            long ld = l.getSeqNum() - r.getSeqNum();
            return ld > 0L ? 1 : -1;
        }
    }
}

