/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.criteria.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaCriteriaInsert;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;

public abstract class AbstractSqmInsertStatement<T>
extends AbstractSqmDmlStatement<T>
implements SqmInsertStatement<T> {
    private List<SqmPath<?>> insertionTargetPaths;
    private @Nullable SqmConflictClause<T> conflictClause;

    protected AbstractSqmInsertStatement(SqmRoot<T> targetRoot, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(targetRoot, querySource, nodeBuilder);
    }

    protected AbstractSqmInsertStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths, SqmConflictClause<T> conflictClause) {
        super(builder, querySource, parameters, cteStatements, target);
        this.insertionTargetPaths = insertionTargetPaths;
        this.conflictClause = conflictClause;
    }

    protected List<SqmPath<?>> copyInsertionTargetPaths(SqmCopyContext context) {
        if (this.insertionTargetPaths == null) {
            return null;
        }
        ArrayList insertionTargetPaths = new ArrayList(this.insertionTargetPaths.size());
        for (SqmPath<?> insertionTargetPath : this.insertionTargetPaths) {
            insertionTargetPaths.add((SqmPath<?>)insertionTargetPath.copy(context));
        }
        return insertionTargetPaths;
    }

    void setConflictClause(SqmConflictClause<T> conflictClause) {
        this.conflictClause = conflictClause;
    }

    protected void verifyInsertTypesMatch(List<SqmPath<?>> insertionTargetPaths, List<? extends SqmTypedNode<?>> expressions) {
        int expressionsSize;
        int size = insertionTargetPaths.size();
        if (size != (expressionsSize = expressions.size())) {
            throw new SemanticException(String.format("Expected insert attribute count [%d] did not match Query selection count [%d]", size, expressionsSize), null, null);
        }
        for (int i = 0; i < expressionsSize; ++i) {
            SqmTypedNode<?> expression = expressions.get(i);
            SqmPath<?> targetPath = insertionTargetPaths.get(i);
            TypecheckUtil.assertAssignable(null, targetPath, expression, this.nodeBuilder());
        }
    }

    @Override
    public void setTarget(JpaRoot<T> root) {
        if (root.getModel() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' is not an entity", root.getModel().getHibernateEntityName()));
        }
        super.setTarget(root);
    }

    @Override
    public List<SqmPath<?>> getInsertionTargetPaths() {
        return this.insertionTargetPaths == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertionTargetPaths);
    }

    @Override
    public SqmInsertStatement<T> setInsertionTargetPaths(Path<?> ... insertionTargetPaths) {
        return this.setInsertionTargetPaths(Arrays.asList(insertionTargetPaths));
    }

    @Override
    public SqmInsertStatement<T> setInsertionTargetPaths(List<? extends Path<?>> insertionTargetPaths) {
        this.insertionTargetPaths = insertionTargetPaths;
        return this;
    }

    public void addInsertTargetStateField(SqmPath<?> stateField) {
        if (this.insertionTargetPaths == null) {
            this.insertionTargetPaths = new ArrayList();
        }
        this.insertionTargetPaths.add(stateField);
    }

    @Override
    public void visitInsertionTargetPaths(Consumer<SqmPath<?>> consumer) {
        if (this.insertionTargetPaths != null) {
            this.insertionTargetPaths.forEach(consumer);
        }
    }

    @Override
    public SqmConflictClause<T> createConflictClause() {
        return new SqmConflictClause(this);
    }

    @Override
    public @Nullable SqmConflictClause<T> getConflictClause() {
        return this.conflictClause;
    }

    @Override
    public JpaConflictClause<T> onConflict() {
        this.conflictClause = this.createConflictClause();
        return this.conflictClause;
    }

    @Override
    public JpaCriteriaInsert<T> onConflict(@Nullable JpaConflictClause<T> conflictClause) {
        this.conflictClause = (SqmConflictClause)conflictClause;
        return this;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.appendHqlCteString(hql, context);
        hql.append("insert into ");
        hql.append(((SqmRoot)this.getTarget()).getEntityName());
        if (this.insertionTargetPaths != null && !this.insertionTargetPaths.isEmpty()) {
            hql.append('(');
            this.insertionTargetPaths.get(0).appendHqlString(hql, context);
            for (int i = 1; i < this.insertionTargetPaths.size(); ++i) {
                hql.append(", ");
                this.insertionTargetPaths.get(i).appendHqlString(hql, context);
            }
            hql.append(')');
        }
    }
}

