/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import liquibase.GlobalConfiguration;
import liquibase.changelog.ChangeSet;
import liquibase.resource.ResourceAccessor;
import liquibase.util.BomAwareInputStream;
import liquibase.util.ObjectUtil;
import org.apache.commons.io.IOUtils;

public abstract class StreamUtil {
    public static String getLineSeparator() {
        return GlobalConfiguration.OUTPUT_LINE_SEPARATOR.getCurrentValue();
    }

    @Deprecated
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    @Deprecated
    public static byte[] readStream(InputStream stream) throws IOException {
        return IOUtils.toByteArray((InputStream)stream);
    }

    public static String readStreamAsString(InputStream stream) throws IOException {
        return StreamUtil.readStreamAsString(stream, null);
    }

    public static String readStreamAsString(InputStream stream, String encoding) throws IOException {
        try (Reader reader = StreamUtil.readStreamWithReader(stream, encoding);){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    public static Reader readStreamWithReader(InputStream stream, String encoding) throws IOException {
        BomAwareInputStream encodingAwareStream = new BomAwareInputStream(stream);
        Charset detectedEncoding = encodingAwareStream.getDetectedCharset();
        if (encoding == null) {
            if (detectedEncoding != null) {
                encoding = detectedEncoding.name();
            }
        } else {
            String canonicalEncodingName = Charset.forName(encoding).name();
            if (detectedEncoding != null && canonicalEncodingName.startsWith("UTF") && !canonicalEncodingName.equals(detectedEncoding.name())) {
                throw new IllegalArgumentException("Expected encoding was '" + encoding + "' but a BOM was detected for '" + detectedEncoding + "'");
            }
        }
        return new InputStreamReader((InputStream)((Object)encodingAwareStream), ObjectUtil.defaultIfNull(encoding == null ? null : Charset.forName(encoding), GlobalConfiguration.FILE_ENCODING.getCurrentValue()));
    }

    @Deprecated
    public static InputStream openStream(String path, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        if (relativeToChangelogFile != null && relativeToChangelogFile.booleanValue()) {
            path = resourceAccessor.get(changeSet.getChangeLog().getPhysicalFilePath()).resolveSibling(path).getPath();
        }
        return resourceAccessor.getExisting(path).openInputStream();
    }
}

