/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.undo;

import java.util.Stack;
import org.aesh.readline.undo.UndoAction;

public class UndoManager {
    private static short UNDO_SIZE = (short)50;
    private Stack<UndoAction> undoStack = new Stack();
    private int counter;

    public UndoManager() {
        this.undoStack.setSize(UNDO_SIZE);
        this.counter = 0;
    }

    public UndoAction getNext() {
        if (this.counter > 0) {
            --this.counter;
            return this.undoStack.pop();
        }
        return null;
    }

    public void addUndo(UndoAction u) {
        if (this.counter <= UNDO_SIZE) {
            ++this.counter;
            this.undoStack.push(u);
        } else {
            this.undoStack.remove(UNDO_SIZE);
            this.undoStack.push(u);
        }
    }

    public void clear() {
        this.undoStack.clear();
        this.counter = 0;
    }

    public boolean isEmpty() {
        return this.counter == 0;
    }

    public int size() {
        return this.counter;
    }
}

