/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import org.wildfly.common.Assert;
import org.wildfly.security.password.impl.ThreadLocalSecureRandom;

final class PasswordUtil {
    private static final ThreadLocalSecureRandom THREAD_LOCAL_SECURE_RANDOM = new ThreadLocalSecureRandom();

    PasswordUtil() {
    }

    public static byte[] generateRandomSalt(int saltSize) {
        byte[] randomSalt = new byte[saltSize];
        THREAD_LOCAL_SECURE_RANDOM.get().nextBytes(randomSalt);
        return randomSalt;
    }

    static int generateRandomSaltInt() {
        byte[] saltBytes = PasswordUtil.generateRandomSalt(4);
        return PasswordUtil.convertBytesToInt(saltBytes);
    }

    static int convertBytesToInt(byte[] saltBytes) {
        Assert.assertTrue((saltBytes.length == 4 ? 1 : 0) != 0);
        return (saltBytes[0] & 0xFF) << 24 | (saltBytes[1] & 0xFF) << 16 | (saltBytes[2] & 0xFF) << 8 | saltBytes[3] & 0xFF;
    }
}

