/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.parsers;

import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public abstract class AbstractStaxParser<T, E>
implements StaxParser {
    protected static final PicketLinkLogger LOGGER = PicketLinkLoggerFactory.getLogger();
    protected final QName expectedStartElement;
    private final E unknownElement;

    public AbstractStaxParser(QName expectedStartElement, E unknownElement) {
        this.unknownElement = unknownElement;
        this.expectedStartElement = expectedStartElement;
    }

    public T parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        QName actualQName = startElement.getName();
        this.validateStartElement(startElement);
        T target = this.instantiateElement(xmlEventReader, startElement);
        QName currentSubelement = null;
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peekNextTag(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                QName qName = endElement.getName();
                if (Objects.equals(qName, currentSubelement)) {
                    StaxParserUtil.advance(xmlEventReader);
                    currentSubelement = null;
                    continue;
                }
                if (Objects.equals(qName, actualQName)) {
                    StaxParserUtil.advance(xmlEventReader);
                    break;
                }
                String elementName = StaxParserUtil.getElementName(endElement);
                throw LOGGER.parserUnknownEndElement(elementName, xmlEvent.getLocation());
            }
            startElement = (StartElement)xmlEvent;
            currentSubelement = startElement.getName();
            E token = this.getElementFromName(currentSubelement);
            if (token == null) {
                token = this.unknownElement;
            }
            this.processSubElement(xmlEventReader, target, token, startElement);
            if (StaxParserUtil.peek(xmlEventReader) == startElement) {
                StaxParserUtil.bypassElementBlock(xmlEventReader);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Element %s bypassed", currentSubelement));
                }
            }
            if (!Objects.equals(actualQName, currentSubelement) && !this.isUnknownElement(token)) continue;
            currentSubelement = null;
        }
        return target;
    }

    protected void validateStartElement(StartElement startElement) {
        StaxParserUtil.validate(startElement, this.expectedStartElement);
    }

    protected boolean isUnknownElement(E token) {
        return token == null || Objects.equals(token, this.unknownElement);
    }

    protected abstract E getElementFromName(QName var1);

    protected abstract T instantiateElement(XMLEventReader var1, StartElement var2) throws ParsingException;

    protected abstract void processSubElement(XMLEventReader var1, T var2, E var3, StartElement var4) throws ParsingException;
}

