/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SignatureAlgorithm;

public class RedirectBindingSignatureUtil {
    private static final Logger log = Logger.getLogger(RedirectBindingSignatureUtil.class);

    private RedirectBindingSignatureUtil() {
    }

    public static boolean validateRedirectBindingSignature(SignatureAlgorithm sigAlg, byte[] rawQueryBytes, byte[] decodedSignature, KeyLocator locator, String keyId) throws KeyManagementException, VerificationException {
        try {
            try {
                Key key = locator.getKey(keyId);
                if (key != null) {
                    return RedirectBindingSignatureUtil.validateRedirectBindingSignatureForKey(sigAlg, rawQueryBytes, decodedSignature, key);
                }
            }
            catch (KeyManagementException key) {}
        }
        catch (SignatureException ex) {
            log.debug("Verification failed for key %s: %s", (Object)keyId, (Throwable)ex);
            log.trace((Object)ex);
        }
        log.trace((Object)"Trying hard to validate XML signature using all available keys.");
        for (Key key : locator) {
            try {
                if (!RedirectBindingSignatureUtil.validateRedirectBindingSignatureForKey(sigAlg, rawQueryBytes, decodedSignature, key)) continue;
                return true;
            }
            catch (SignatureException ex) {
                log.debug((Object)"Verification failed: %s", (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean validateRedirectBindingSignatureForKey(SignatureAlgorithm sigAlg, byte[] rawQueryBytes, byte[] decodedSignature, Key key) throws SignatureException {
        if (key == null) {
            return false;
        }
        if (!(key instanceof PublicKey)) {
            log.warnf("Unusable key for signature validation: %s", (Object)key);
            return false;
        }
        Signature signature = sigAlg.createSignature();
        try {
            signature.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException ex) {
            log.warnf((Throwable)ex, "Unusable key for signature validation: %s", (Object)key);
            return false;
        }
        signature.update(rawQueryBytes);
        return signature.verify(decodedSignature);
    }
}

