/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.encoder;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoder;
import org.pentaho.reporting.libraries.base.encoder.JpegImageEncoder;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.PngEncoder;

public class ImageEncoderRegistry {
    private static ImageEncoderRegistry instance;
    private HashMap encoders = new HashMap();
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_JPEG = "image/jpeg";

    public static synchronized ImageEncoderRegistry getInstance() {
        if (instance == null) {
            instance = new ImageEncoderRegistry();
            instance.registerDefaults();
        }
        return instance;
    }

    private ImageEncoderRegistry() {
    }

    private void registerDefaults() {
        this.encoders.put(IMAGE_PNG, PngEncoder.class.getName());
        if (JpegImageEncoder.isJpegEncodingAvailable()) {
            this.encoders.put(IMAGE_JPEG, JpegImageEncoder.class.getName());
            this.encoders.put("image/jpg", JpegImageEncoder.class.getName());
        }
    }

    public void addEncoder(String mimeType, String encoderClass) {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        if (encoderClass == null) {
            throw new NullPointerException();
        }
        this.encoders.put(mimeType, encoderClass);
    }

    public boolean isEncoderAvailable(String mimeType) {
        return this.encoders.containsKey(mimeType);
    }

    public String[] getRegisteredEncoders() {
        return this.encoders.keySet().toArray(new String[this.encoders.size()]);
    }

    public ImageEncoder createEncoder(String mimeType) throws UnsupportedEncoderException {
        Object o = this.encoders.get(mimeType);
        if (o == null) {
            throw new UnsupportedEncoderException("No encoder for mime-type " + mimeType);
        }
        ImageEncoder imageEncoder = (ImageEncoder)ObjectUtilities.loadAndInstantiate((String)o, ImageEncoderRegistry.class, ImageEncoder.class);
        if (imageEncoder == null) {
            throw new UnsupportedEncoderException("No encoder for mime-type " + mimeType);
        }
        return imageEncoder;
    }
}

